/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.ContactRefV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.GroupV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.IdentityDetailsV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.PreGroupV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="pending_group_member_table")
public class PendingGroupMemberV1
extends AbstractTableGenerated<PendingGroupMemberV1>
implements Table {
    public static final String TABLE_NAME = "pending_group_member_table";
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<PendingGroupMemberV1, GroupV1> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<PendingGroupMemberV1, PreGroupV1> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingGroupMemberV1, ContactRefV1> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<PendingGroupMemberV1, IdentityDetailsV1> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    private static final String SORT_DISPLAY_NAME_NAME = "sort_display_name";
    public static final Column.ObjectColumn<PendingGroupMemberV1, byte[]> SORT_DISPLAY_NAME = new Column.ObjectColumn("sort_display_name", false);
    private static final String DECLINED_NAME = "declined";
    public static final Column.booleanColumn<PendingGroupMemberV1> DECLINED = new Column.booleanColumn("declined");
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group REFERENCES group_table(gen_id) ON DELETE CASCADE")
    protected GroupV1 fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group REFERENCES pre_group_table(gen_id) ON DELETE CASCADE")
    protected PreGroupV1 fkPreGroup;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV1 fkContactRef;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetailsV1 fkIdentityDetails;
    @DatabaseField(columnName="sort_display_name", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] sortDisplayName;
    @DatabaseField(columnName="declined", dataType=DataType.BOOLEAN)
    protected boolean declined;
    @DatabaseField(columnName="virtual_fk_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_group, 0)) VIRTUAL")
    private long virtualGroup;
    @DatabaseField(columnName="virtual_fk_pre_group", uniqueCombo=true, readOnly=true, columnDefinition="GENERATED ALWAYS AS (COALESCE(fk_pre_group, 0)) VIRTUAL")
    private long virtualPreGroup;

    public PendingGroupMemberV1() {
    }

    public PendingGroupMemberV1(long genId) {
        super(genId);
    }

    public PendingGroupMemberV1(long genId, GroupV1 group, PreGroupV1 preGroup, ContactRefV1 contactRef, IdentityDetailsV1 identityDetails, byte[] sortDisplayName, boolean declined) {
        super(genId);
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.fkContactRef = contactRef;
        this.fkIdentityDetails = identityDetails;
        this.sortDisplayName = sortDisplayName;
        this.declined = declined;
    }

    public Optional<Id<GroupV1>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<PreGroupV1>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRefV1> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public Id<IdentityDetailsV1> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public byte[] getSortDisplayName() {
        return this.sortDisplayName;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public void setDeclined(boolean declined) {
        this.declined = declined;
    }

    public String toString() {
        return String.format("PendingGroupMember[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingGroupMemberV1 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && Objects.equals(this.fkContactRef, casted.fkContactRef) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails) && Arrays.equals(this.sortDisplayName, casted.sortDisplayName) && this.declined == casted.declined;
    }

    @Override
    protected Class<PendingGroupMemberV1> getClazz() {
        return PendingGroupMemberV1.class;
    }
}

