/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.ContactRefV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.OwnedIdentityV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="identity_ref_table")
public class IdentityRefV1
extends AbstractTableGenerated<IdentityRefV1>
implements Table {
    public static final String TABLE_NAME = "identity_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<IdentityRefV1, OwnedIdentityV1> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<IdentityRefV1, ContactRefV1> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", true);
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity UNIQUE REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV1 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV1 fkContactRef;

    public IdentityRefV1() {
    }

    public IdentityRefV1(long genId) {
        super(genId);
    }

    public IdentityRefV1(long genId, OwnedIdentityV1 ownedIdentity, ContactRefV1 contactRef) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContactRef = contactRef;
    }

    public Optional<Id<OwnedIdentityV1>> getOwnedIdentityId() {
        return Optional.ofNullable(this.fkOwnedIdentity).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactRefV1>> getContactRefId() {
        return Optional.ofNullable(this.fkContactRef).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("IdentityRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityRefV1 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<IdentityRefV1> getClazz() {
        return IdentityRefV1.class;
    }
}

