/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations;

import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.database.migrations.gen.Migration4To5Generated;
import io.olvid.windows.messenger.database.migrations.gen.v5.ContactRefV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.DiscussionV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.StartupJobV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.InboundMessageSequenceIntervalV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.InboundMessageV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.OwnedMessageSequenceIntervalV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.OwnedMessageV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.misc.startupJob.StartupJobKind;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class Migration4To5Impl
extends Migration4To5Generated {
    private final Map<InboundKey, List<Interval>> inboundIntervals = new HashMap<InboundKey, List<Interval>>();
    private final Map<OwnedKey, List<Interval>> ownedIntervals = new HashMap<OwnedKey, List<Interval>>();

    @Override
    public void setupMigration() throws Exception, SQLException {
        int inboundCollisionCount = 0;
        List inboundMessages = this.getInboundMessageDao().getAll();
        for (InboundMessageV5 inboundMessage : inboundMessages) {
            InboundKey key = new InboundKey(inboundMessage.getDiscussionId(), inboundMessage.getSenderId(), inboundMessage.getSenderThreadIdentifier());
            Optional<Interval> intervalOpt = this.findInterval(key, this.inboundIntervals, inboundMessage.getSenderSequenceNumber());
            if (intervalOpt.isPresent()) {
                ++inboundCollisionCount;
                continue;
            }
            Optional<Interval> previousInterval = this.previousInterval(key, this.inboundIntervals, inboundMessage.getSenderSequenceNumber());
            Optional<Interval> nextInterval = this.nextInterval(key, this.inboundIntervals, inboundMessage.getSenderSequenceNumber());
            long sequenceNumber = inboundMessage.getSenderSequenceNumber();
            long timestamp = inboundMessage.getTimestamp();
            double sortIndex = inboundMessage.getSortIndex();
            this.merge(key, this.inboundIntervals, previousInterval, timestamp, sortIndex, sequenceNumber, nextInterval);
        }
        if (inboundCollisionCount > 0) {
            this.logger.info(String.format("Found %d inbound messages interval collisions", inboundCollisionCount));
        }
        int ownedCollisionCount = 0;
        List ownedMessages = this.getOwnedMessageDao().getAll();
        for (OwnedMessageV5 ownedMessage : ownedMessages) {
            OwnedKey key = new OwnedKey(ownedMessage.getDiscussionId(), ownedMessage.getSenderThreadIdentifier());
            Optional<Interval> intervalOpt = this.findInterval(key, this.ownedIntervals, ownedMessage.getSenderSequenceNumber());
            if (intervalOpt.isPresent()) {
                ++ownedCollisionCount;
                continue;
            }
            Optional<Interval> previousInterval = this.previousInterval(key, this.ownedIntervals, ownedMessage.getSenderSequenceNumber());
            Optional<Interval> nextInterval = this.nextInterval(key, this.ownedIntervals, ownedMessage.getSenderSequenceNumber());
            long sequenceNumber = ownedMessage.getSenderSequenceNumber();
            long timestamp = ownedMessage.getTimestamp();
            double sortIndex = ownedMessage.getSortIndex();
            this.merge(key, this.ownedIntervals, previousInterval, timestamp, sortIndex, sequenceNumber, nextInterval);
            if (ownedCollisionCount <= 0) continue;
            this.logger.info(String.format("Found %d owned messages interval collisions", ownedCollisionCount));
        }
    }

    @Override
    public void performMigration() throws SQLException, DbMigration.DbMigrationException {
        int inboundIntervalsCount = 0;
        for (InboundKey inboundKey : this.inboundIntervals.keySet()) {
            List<Interval> intervals = this.inboundIntervals.get(inboundKey);
            for (Interval interval : intervals) {
                InboundMessageSequenceIntervalV5 intervalV5 = new InboundMessageSequenceIntervalV5(0L, new DiscussionV5(inboundKey.discussionId.getId()), inboundKey.senderThreadIdentifier, interval.start, interval.end, interval.startSortIndex, interval.endSortIndex, interval.startTimestamp, interval.endTimestamp, new ContactRefV5(inboundKey.senderId.getId()));
                this.getInboundMessageSequenceIntervalDao().insertOrThrow((InboundMessageSequenceIntervalV5[])new InboundMessageSequenceIntervalV5[]{intervalV5});
                ++inboundIntervalsCount;
            }
        }
        this.logger.info(String.format("Create %d inbound messages sequence intervals", inboundIntervalsCount));
        int ownedIntervalsCount = 0;
        for (OwnedKey ownedKey : this.ownedIntervals.keySet()) {
            List<Interval> intervals = this.ownedIntervals.get(ownedKey);
            for (Interval interval : intervals) {
                OwnedMessageSequenceIntervalV5 intervalV5 = new OwnedMessageSequenceIntervalV5(0L, new DiscussionV5(ownedKey.discussionId.getId()), ownedKey.senderThreadIdentifier, interval.start, interval.end, interval.startSortIndex, interval.endSortIndex, interval.startTimestamp, interval.endTimestamp);
                this.getOwnedMessageSequenceIntervalDao().insertOrThrow((OwnedMessageSequenceIntervalV5[])new OwnedMessageSequenceIntervalV5[]{intervalV5});
                ++ownedIntervalsCount;
            }
        }
        this.logger.info(String.format("Create %d owned messages sequence intervals", ownedIntervalsCount));
        this.getStartupJobDao().insertOrThrow((StartupJobV5[])new StartupJobV5[]{new StartupJobV5(StartupJobKind.CLEAN_INBOUND_MESSAGE_EPHEMERAL_INFO)});
    }

    private <Key> void merge(Key key, Map<Key, List<Interval>> intervalsMap, Optional<Interval> previousOpt, long timestamp, double sortIndex, long sequenceNumber, Optional<Interval> nextOpt) {
        if (previousOpt.isPresent()) {
            Interval previous = previousOpt.get();
            if (previous.end + 1L == sequenceNumber) {
                previous.endTimestamp = timestamp;
                previous.endSortIndex = sortIndex;
                previous.end = sequenceNumber;
                if (nextOpt.isPresent() && nextOpt.get().start - 1L == sequenceNumber) {
                    Interval after = nextOpt.get();
                    previous.endTimestamp = after.endTimestamp;
                    previous.endSortIndex = after.endSortIndex;
                    previous.end = after.end;
                    intervalsMap.get(key).remove(after);
                }
                return;
            }
        }
        if (nextOpt.isPresent() && nextOpt.get().start - 1L == sequenceNumber) {
            Interval next = nextOpt.get();
            next.startTimestamp = timestamp;
            next.startSortIndex = sortIndex;
            next.start = sequenceNumber;
            return;
        }
        List intervals = intervalsMap.computeIfAbsent(key, k -> new ArrayList());
        intervals.add(new Interval(sequenceNumber, sequenceNumber, timestamp, sortIndex));
    }

    private <Key> Optional<Interval> findInterval(Key key, Map<Key, List<Interval>> intervalsMap, long senderSequenceNumber) {
        List<Interval> intervals = intervalsMap.get(key);
        if (intervals == null) {
            return Optional.empty();
        }
        for (Interval interval : intervals) {
            if (interval.start > senderSequenceNumber || senderSequenceNumber > interval.end) continue;
            return Optional.of(interval);
        }
        return Optional.empty();
    }

    private <Key> Optional<Interval> previousInterval(Key key, Map<Key, List<Interval>> intervalsMap, long senderSequenceNumber) {
        List<Interval> intervals = intervalsMap.get(key);
        if (intervals == null) {
            return Optional.empty();
        }
        Interval lastPrevious = null;
        for (Interval interval : intervals) {
            if (interval.end >= senderSequenceNumber || lastPrevious != null && interval.start <= lastPrevious.start) continue;
            lastPrevious = interval;
        }
        return Optional.ofNullable(lastPrevious);
    }

    private <Key> Optional<Interval> nextInterval(Key key, Map<Key, List<Interval>> intervalsMap, long senderSequenceNumber) {
        List<Interval> intervals = intervalsMap.get(key);
        if (intervals == null) {
            return Optional.empty();
        }
        Interval firstNext = null;
        for (Interval interval : intervals) {
            if (interval.start <= senderSequenceNumber || firstNext != null && interval.start >= firstNext.start) continue;
            firstNext = interval;
        }
        return Optional.ofNullable(firstNext);
    }

    private record InboundKey(Id<DiscussionV5> discussionId, Id<ContactRefV5> senderId, UUID senderThreadIdentifier) {
    }

    private record OwnedKey(Id<DiscussionV5> discussionId, UUID senderThreadIdentifier) {
    }

    private static class Interval {
        public long start;
        public long end;
        public long startTimestamp;
        public long endTimestamp;
        public double startSortIndex;
        public double endSortIndex;

        public Interval(long start, long end, long timestamp, double sortIndex) {
            this.start = start;
            this.end = end;
            this.startTimestamp = timestamp;
            this.endTimestamp = timestamp;
            this.startSortIndex = sortIndex;
            this.endSortIndex = sortIndex;
        }
    }
}

