/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations;

import com.j256.ormlite.field.DataType;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.database.migrations.gen.Migration1To2Generated;
import io.olvid.windows.messenger.database.migrations.gen.v2.FyleV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.StartupJobV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.attachment.AbstractAttachmentV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.attachment.InboundAttachmentV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.attachment.OutboundAttachmentV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.attachment.OwnedAttachmentV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.message.AbstractUserMessageV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.message.InboundMessageV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.message.OutboundMessageV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.message.OwnedMessageV2;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.fx.misc.OpenGraphHelper;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.startupJob.StartupJobKind;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.image.Image;

public class Migration1To2Impl
extends Migration1To2Generated {
    @Override
    public void setupMigration() throws SQLException {
        this.addColumn("inbound_message_table", InboundMessageV2.LINK_PREVIEW_KIND.name, DataType.ENUM_NAME, List.of());
        this.addColumn("inbound_message_table", InboundMessageV2.LINK_PREVIEW_DESCRIPTION.name, DataType.STRING, List.of());
        this.addColumn("inbound_message_table", InboundMessageV2.LINK_PREVIEW_IMAGE_WIDTH.name, DataType.DOUBLE_OBJ, List.of());
        this.dropColumn("inbound_message_table", Migration1To2Generated.InboundMessageV1Pojo.WIPED_ATTACHMENT_COUNT.name);
        this.addColumn("outbound_message_table", OutboundMessageV2.LINK_PREVIEW_KIND.name, DataType.ENUM_NAME, List.of());
        this.addColumn("outbound_message_table", OutboundMessageV2.LINK_PREVIEW_DESCRIPTION.name, DataType.STRING, List.of());
        this.addColumn("outbound_message_table", OutboundMessageV2.LINK_PREVIEW_IMAGE_WIDTH.name, DataType.DOUBLE_OBJ, List.of());
        this.dropColumn("outbound_message_table", Migration1To2Generated.OutboundMessageV1Pojo.WIPED_ATTACHMENT_COUNT.name);
        this.addColumn("owned_message_table", OwnedMessageV2.LINK_PREVIEW_KIND.name, DataType.ENUM_NAME, List.of());
        this.addColumn("owned_message_table", OwnedMessageV2.LINK_PREVIEW_DESCRIPTION.name, DataType.STRING, List.of());
        this.addColumn("owned_message_table", OwnedMessageV2.LINK_PREVIEW_IMAGE_WIDTH.name, DataType.DOUBLE_OBJ, List.of());
        this.dropColumn("owned_message_table", Migration1To2Generated.OwnedMessageV1Pojo.WIPED_ATTACHMENT_COUNT.name);
    }

    @Override
    public void performMigration() throws SQLException, DbMigration.DbMigrationException {
        this.performMigration(this.getInboundMessageDao(), this.getInboundAttachmentDao(), InboundAttachmentV2.FK_MESSAGE);
        this.performMigration(this.getOutboundMessageDao(), this.getOutboundAttachmentDao(), OutboundAttachmentV2.FK_MESSAGE);
        this.performMigration(this.getOwnedMessageDao(), this.getOwnedAttachmentDao(), OwnedAttachmentV2.FK_MESSAGE);
        this.getStartupJobDao().insert((StartupJobV2[])new StartupJobV2[]{new StartupJobV2(StartupJobKind.DOWNLOAD_DOWNLOADABLE_LINK_PREVIEWS)});
        this.getStartupJobDao().insert((StartupJobV2[])new StartupJobV2[]{new StartupJobV2(StartupJobKind.CLEAN_CONTACT_GROUP_JOIN)});
    }

    private <Message extends AbstractUserMessageV2<Message>, Attachment extends AbstractAttachmentV2<Attachment>> List<Attachment> getAttachmentsForMessage(Id<Message> message, OlvidDao<Attachment> attachmentDao, Column.ForeignColumn<Attachment, Message> column) throws SQLException {
        ObvQueryBuilder<AbstractAttachmentV2<?>> attachmentQB = attachmentDao.queryBuilder();
        attachmentQB.where().eq(column, message);
        attachmentQB.orderBy(AbstractAttachmentV2.IDX, true);
        return attachmentQB.query();
    }

    private <Message extends AbstractUserMessageV2<Message>, Attachment extends AbstractAttachmentV2<Attachment>> void performMigration(OlvidDao<Message> messageDao, OlvidDao<Attachment> attachmentDao, Column.ForeignColumn<Attachment, Message> column) throws SQLException {
        List messages = messageDao.getAll();
        for (AbstractUserMessageV2 message : messages) {
            List<Attachment> attachments = this.getAttachmentsForMessage((Id<Message>)message.getItemId(), attachmentDao, column);
            Optional<LinkPreviewInfo> linkPreviewInfoOpt = this.of(attachments);
            if (linkPreviewInfoOpt.isPresent()) {
                LinkPreviewInfo linkPreviewInfo = linkPreviewInfoOpt.get();
                message.setLinkPreviewKind(linkPreviewInfo.getLinkPreviewKind());
                message.setLinkPreviewDescription(linkPreviewInfo.description());
                message.setLinkPreviewImageWidth(linkPreviewInfo.imageWidth());
            } else {
                message.setLinkPreviewKind(AbstractUserMessageV2.LinkPreviewKind.NONE);
            }
            messageDao.updateOrThrow(message);
        }
    }

    private <Attachment extends AbstractAttachmentV2<Attachment>> Optional<LinkPreviewInfo> of(List<Attachment> attachments) {
        for (AbstractAttachmentV2 attachment : attachments) {
            if (!ImageUtils.isLink(Migration1To2Impl.getNonNullMimeType(attachment))) continue;
            FyleV2 openGraphFyle = this.getFyleDao().get(attachment.getFyleId());
            boolean isComplete = openGraphFyle.getSha256().isPresent();
            if (!isComplete) {
                return Optional.of(new LinkPreviewInfo(Optional.empty(), false, Optional.empty()));
            }
            Result<OpenGraph, Throwable> openGraphResult = OpenGraphHelper.loadOpenGraph(openGraphFyle.getFilePath());
            if (openGraphResult.isFailure()) {
                return Optional.empty();
            }
            OpenGraph openGraph = openGraphResult.getSuccess();
            byte[] imageBytes = openGraph.getImageBytes();
            String description = StringUtils.isEmpty(openGraph.getDescription()) ? openGraph.getUrl() : openGraph.getDescription();
            if (imageBytes == null) {
                return Optional.of(new LinkPreviewInfo(Optional.ofNullable(description), true, Optional.empty()));
            }
            Image image = new Image((InputStream)new ByteArrayInputStream(imageBytes));
            return Optional.of(new LinkPreviewInfo(Optional.ofNullable(description), true, Optional.of(image.getWidth())));
        }
        return Optional.empty();
    }

    private static String getNonNullMimeType(AbstractAttachmentV2<?> attachment) {
        String mimeType = attachment.getMimeType();
        String filename = attachment.getFilename();
        if (mimeType == null || !mimeType.contains("/")) {
            String type = URLConnection.getFileNameMap().getContentTypeFor(filename);
            return Objects.requireNonNullElse(type, "application/octet-stream");
        }
        return mimeType;
    }

    private record LinkPreviewInfo(Optional<String> description, boolean isComplete, Optional<Double> imageWidth) {
        public AbstractUserMessageV2.LinkPreviewKind getLinkPreviewKind() {
            if (!this.isComplete) {
                return AbstractUserMessageV2.LinkPreviewKind.DOWNLOADING;
            }
            if (this.imageWidth.isEmpty()) {
                return AbstractUserMessageV2.LinkPreviewKind.PARTIAL;
            }
            return AbstractUserMessageV2.LinkPreviewKind.FULL;
        }
    }
}

