/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableUtils;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.database.management.gen.AppSchemaVersion;
import io.olvid.windows.messenger.database.migrations.MigrationDelegate;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMigration {
    public final AppSchemaVersion from;
    public final AppSchemaVersion to;
    protected final AppLogger logger = new AppLogger(this.getClass());
    public MigrationDelegate migrationDelegate = null;

    public AbstractMigration(AppSchemaVersion from, AppSchemaVersion to) {
        if (from == to) {
            throw new IllegalStateException();
        }
        this.from = from;
        this.to = to;
    }

    public abstract void setupMigration() throws Exception, SQLException;

    public abstract void registerDaos() throws SQLException;

    public abstract void unregisterDaos() throws SQLException;

    public abstract void performMigration() throws SQLException, DbMigration.DbMigrationException;

    public void saveForeignConstraints() throws Exception {
        try (GenericRawResults foreignKeyCheckResults = this.migrationDelegate.queryRaw("PRAGMA foreign_key_check;", AbstractMigration::mapRowForeignKeyCheck);){
            for (ViolatedConstraint violatedConstraint : foreignKeyCheckResults) {
                AppLogger.e("Foreign key constraint violated: " + String.valueOf(violatedConstraint));
                this.migrationDelegate.executeRaw(String.format("DELETE FROM `%s` WHERE `gen_id` = %d;", violatedConstraint.table(), violatedConstraint.rowid()), new String[0]);
            }
        }
    }

    public void verifyMigration() throws Exception {
        List foreignKeyCheck;
        try (GenericRawResults foreignKeyCheckResults = this.migrationDelegate.queryRaw("PRAGMA foreign_key_check;", AbstractMigration::mapRowForeignKeyCheck);){
            foreignKeyCheck = foreignKeyCheckResults.getResults();
        }
        if (!foreignKeyCheck.isEmpty()) {
            throw new DbMigration.DbMigrationException(String.join((CharSequence)System.lineSeparator(), foreignKeyCheck.stream().map(ViolatedConstraint::toString).toList()));
        }
    }

    protected final void addColumn(String table, String column, DataType type, List<String> contraints) throws SQLException {
        Object contraintsSQL = contraints.isEmpty() ? "" : " " + String.join((CharSequence)" ", contraints);
        String query = String.format("ALTER TABLE %s ADD COLUMN %s %s%s", table, column, this.toSql(type), contraintsSQL);
        this.migrationDelegate.executeRaw(query, new String[0]);
    }

    protected final void copyColumn(String table, String fromColumn, String toColumn) throws SQLException {
        String query = String.format("UPDATE %s SET %s = %s", table, fromColumn, toColumn);
        this.migrationDelegate.executeRaw(query, new String[0]);
    }

    protected final void dropColumn(String table, String column) throws SQLException {
        String query = String.format("ALTER TABLE %s DROP COLUMN %s", table, column);
        this.logger.trace(query);
        this.migrationDelegate.executeRaw(query, new String[0]);
    }

    protected final void renameColumn(String table, String column, String newName) throws SQLException {
        String query = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", table, column, newName);
        this.logger.trace(query);
        this.migrationDelegate.executeRaw(query, new String[0]);
    }

    protected final void dropIndex(String indexName) throws SQLException {
        String query = String.format("DROP INDEX %s", indexName);
        this.logger.trace(query);
        this.migrationDelegate.executeRaw(query, new String[0]);
    }

    private String toSql(DataType dataType) {
        return switch (dataType) {
            case DataType.STRING -> "VARCHAR";
            case DataType.LONG -> "LONG";
            case DataType.BOOLEAN -> "BOOLEAN";
            case DataType.DOUBLE_OBJ -> "DOUBLE PRECISION";
            default -> null;
        };
    }

    private static ViolatedConstraint mapRowForeignKeyCheck(DatabaseResults results) {
        try {
            Column.ObjectColumn tableColumn = new Column.ObjectColumn("table", false);
            String table = AbstractTableGenerated.getStringObj(results, tableColumn, "");
            Column.ObjectColumn rowidColumn = new Column.ObjectColumn("rowid", false);
            Long rowid = AbstractTableGenerated.getLongObj(results, rowidColumn, "");
            Column.ObjectColumn parentColumn = new Column.ObjectColumn("parent", false);
            String parent = AbstractTableGenerated.getStringObj(results, parentColumn, "");
            return new ViolatedConstraint(table, rowid, parent);
        }
        catch (Exception e) {
            AppLogger.e("Unable to get constraints violation", e);
            return null;
        }
    }

    private void debugCheck(TableInfo info, OlvidAbstractDao<?> dao) throws SQLException {
        List statements = TableUtils.getCreateTableStatements((ConnectionSource)DbManager.getInstance().getConnectionSource(), dao.getDataClass());
        if (statements.isEmpty()) {
            throw new IllegalStateException();
        }
        String ormLiteStatement = (String)statements.get(0);
        String generateStatement = info.createStatement();
        if (!ormLiteStatement.equals(generateStatement = generateStatement.replaceAll("_migration0to1", ""))) {
            this.logger.trace("ORM " + ormLiteStatement);
            this.logger.trace("OBV " + generateStatement);
            throw new IllegalStateException();
        }
    }

    protected void checkStatementGenerator(List<TableInfo> tableInfos) throws SQLException {
        for (TableInfo info : tableInfos) {
            Collection<OlvidAbstractDao<?>> daos = this.migrationDelegate.getAllDao();
            Optional<OlvidAbstractDao> daoOpt = daos.stream().filter(dao -> info.clazz().isAssignableFrom(dao.getDataClass())).findAny();
            if (daoOpt.isEmpty()) {
                throw new IllegalStateException();
            }
            OlvidAbstractDao dao2 = daoOpt.get();
            this.debugCheck(info, dao2);
        }
    }

    protected void addConstraints(List<TableInfo> tableInfos) throws SQLException, DbMigration.DbMigrationException {
        for (TableInfo info : tableInfos) {
            Collection<OlvidAbstractDao<?>> daos = this.migrationDelegate.getAllDao();
            Optional<OlvidAbstractDao> daoOpt = daos.stream().filter(dao -> info.clazz().isAssignableFrom(dao.getDataClass())).findAny();
            if (daoOpt.isEmpty()) {
                throw new IllegalStateException();
            }
            OlvidAbstractDao dao2 = daoOpt.get();
            this.logger.info("Create temp table for " + info.name());
            String createStatement = info.createStatement();
            this.migrationDelegate.executeRaw(createStatement, new String[0]);
            List<String> uniqueIndices = info.uniqueIndices();
            for (String uniqueIndex : uniqueIndices) {
                this.logger.info("Drop index " + uniqueIndex);
                String dropIndexStatement = String.format("DROP INDEX %s;", uniqueIndex);
                this.migrationDelegate.executeRaw(dropIndexStatement, new String[0]);
            }
            List<String> statementsAfter = info.statementsAfter();
            for (String statementAfter : statementsAfter) {
                this.logger.info("Execute after statement " + statementAfter);
                this.migrationDelegate.executeRaw(statementAfter, new String[0]);
            }
            this.logger.info("Copy element temp table from " + info.name() + " to " + info.migrationName());
            long count = dao2.countOf();
            String copyStatement = String.format("INSERT INTO %s SELECT * FROM %s;", info.migrationName(), info.name());
            if ((long)this.migrationDelegate.executeRaw(copyStatement, new String[0]) != count) {
                throw new DbMigration.DbMigrationException("Wrong count copyStatement");
            }
            this.logger.info("Drop table " + info.name());
            String dropTableStatement = String.format("DROP TABLE %s;", info.name());
            this.migrationDelegate.executeRaw(dropTableStatement, new String[0]);
            this.logger.info("Rename table " + info.migrationName() + "  into " + info.name());
            String renameTableStatement = String.format("ALTER TABLE %s RENAME TO %s;", info.migrationName(), info.name());
            this.migrationDelegate.executeRaw(renameTableStatement, new String[0]);
        }
    }

    record ViolatedConstraint(String table, Long rowid, String parent) {
    }

    public record TableInfo(String name, String migrationName, Class<?> clazz, String createStatement, List<String> statementsAfter, List<String> uniqueIndices) {
    }
}

