/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.management;

import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.database.management.gen.AbstractMigrationsRegister;
import io.olvid.windows.messenger.database.management.gen.AppSchemaVersion;
import io.olvid.windows.messenger.database.management.gen.MigrationsProvider;
import io.olvid.windows.messenger.database.migrations.AbstractMigration;
import java.util.Objects;
import java.util.Optional;

public class MigrationsRegister
extends AbstractMigrationsRegister {
    protected MigrationsRegister(MigrationsProvider provider) {
        super(provider);
    }

    @Override
    protected void registerMigration(AbstractMigration migration) {
        Objects.requireNonNull(migration);
        AppSchemaVersion from = migration.from;
        if (this.register.containsKey((Object)from)) {
            throw new IllegalStateException(String.format("Try to register a migration failed since registered migrations already contain a migration from state %s.", from.name()));
        }
        Optional<AppSchemaVersion> nextOpt = DbMigration.next(from);
        if (nextOpt.isEmpty()) {
            throw new IllegalStateException(String.format("Try to register a migration from the state %s that does not have next version.", from.name()));
        }
        AppSchemaVersion next = nextOpt.get();
        if (next != migration.to) {
            throw new IllegalStateException(String.format("Try to register a migration from %s that is incoherent: The migration.to is %s, but %s.next is %s.", from.name(), migration.to.name(), from.name(), next.name()));
        }
        this.register.put(from, migration);
    }

    public Optional<AbstractMigration> getMigrationFrom(AppSchemaVersion version) {
        return Optional.ofNullable((AbstractMigration)this.register.get((Object)version));
    }

    public void dispose() {
        this.register.clear();
    }
}

