/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.management;

import io.olvid.windows.messenger.database.dao.attachment.ReceivedAttachmentDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.management.AbstractDbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;

public class DbManager
extends AbstractDbManager {
    private static DbManager appDatabaseMgrSingletonInstance;
    private static Long UIThreadId;

    private DbManager() {
        Properties props = new Properties();
        props.setProperty("journal_mode", "WAL");
        props.setProperty("foreign_keys", "ON");
        try {
            this.configure(Optional.of(props));
            this.loggerInstance.debug("Connection to app db successful");
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static synchronized DbManager getInstance() {
        if (appDatabaseMgrSingletonInstance == null) {
            appDatabaseMgrSingletonInstance = new DbManager();
        }
        return appDatabaseMgrSingletonInstance;
    }

    public static void clearConnections() {
        if (appDatabaseMgrSingletonInstance != null) {
            DbManager.appDatabaseMgrSingletonInstance.olvidDaoManager.clearConnections();
        }
    }

    public static boolean isOnUIThread() {
        return UIThreadId != null && UIThreadId.longValue() == Thread.currentThread().getId();
    }

    public static void setUIThreadId(long UITid) {
        UIThreadId = UITid;
    }

    public <Message extends ReceivedMessageGenerated<Message>> ReceivedMessageDao<Message, ?, ?> getReceivedMessageDao(Id<Message> messageId) {
        if (messageId.clazz == InboundMessage.class) {
            return DbManager.getInstance().getInboundMessageDao();
        }
        if (messageId.clazz == OwnedMessage.class) {
            return DbManager.getInstance().getOwnedMessageDao();
        }
        throw new IllegalArgumentException();
    }

    public <Attachment extends ReceivedAttachmentGenerated<Attachment>, Message extends ReceivedMessageGenerated<Message>> ReceivedAttachmentDao<Message, Attachment> getReceivedAttachmentDao(Id<Attachment> attachmentId) {
        if (attachmentId.clazz == InboundAttachment.class) {
            return DbManager.getInstance().getInboundAttachmentDao();
        }
        if (attachmentId.clazz == OwnedAttachment.class) {
            return DbManager.getInstance().getOwnedAttachmentDao();
        }
        throw new IllegalArgumentException();
    }

    public void vacuumDatabase() {
        try {
            this.getDiscussionDao().executeRaw("VACUUM", new String[0]);
            this.getDiscussionDao().executeRaw("PRAGMA wal_checkpoint(TRUNCATE)", new String[0]);
        }
        catch (SQLException e) {
            this.loggerInstance.error("Cannot vacuum", e);
        }
    }

    static {
        UIThreadId = null;
    }
}

