/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.datatypes.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonMessageReference {
    long senderSequenceNumber;
    UUID senderThreadIdentifier;
    byte[] senderIdentifier;

    public JsonMessageReference() {
    }

    public JsonMessageReference(long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier) {
        this.senderSequenceNumber = senderSequenceNumber;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.senderIdentifier = senderIdentifier;
    }

    public static JsonMessageReference of(AbstractUserMessageGenerated<?> message) {
        byte[] senderIdentifier;
        if (message instanceof InboundMessage) {
            InboundMessage inboundMessage = (InboundMessage)message;
            senderIdentifier = DbManager.getInstance().getInboundMessageDao().getSenderIdentifier(inboundMessage);
        } else if (message instanceof OutboundMessage) {
            OutboundMessage outboundMessage = (OutboundMessage)message;
            senderIdentifier = DbManager.getInstance().getOutboundMessageDao().getSenderIdentifier(outboundMessage);
        } else if (message instanceof OwnedMessage) {
            OwnedMessage ownedMessage = (OwnedMessage)message;
            senderIdentifier = DbManager.getInstance().getOwnedMessageDao().getSenderIdentifier(ownedMessage);
        } else {
            AppLogger.e("Found a message with unexpected type");
            senderIdentifier = null;
        }
        return new JsonMessageReference(message.getSenderSequenceNumber(), message.getSenderThreadIdentifier(), senderIdentifier);
    }

    @JsonProperty(value="ssn")
    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    @JsonProperty(value="ssn")
    public void setSenderSequenceNumber(long senderSequenceNumber) {
        this.senderSequenceNumber = senderSequenceNumber;
    }

    @JsonProperty(value="sti")
    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    @JsonProperty(value="sti")
    public void setSenderThreadIdentifier(UUID senderThreadIdentifier) {
        this.senderThreadIdentifier = senderThreadIdentifier;
    }

    @JsonProperty(value="si")
    public byte[] getSenderIdentifier() {
        return this.senderIdentifier;
    }

    @JsonProperty(value="si")
    public void setSenderIdentifier(byte[] senderIdentifier) {
        this.senderIdentifier = senderIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonMessageReference that = (JsonMessageReference)o;
        return this.senderSequenceNumber == that.senderSequenceNumber && Objects.equals(this.senderThreadIdentifier, that.senderThreadIdentifier) && Arrays.equals(this.senderIdentifier, that.senderIdentifier);
    }

    public int hashCode() {
        int result = Objects.hash(this.senderSequenceNumber, this.senderThreadIdentifier);
        result = 31 * result + Arrays.hashCode(this.senderIdentifier);
        return result;
    }
}

