/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.remoterequest;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.remoterequest.AbstractRemoteRequestGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractRemoteRequestDao<T extends AbstractRemoteRequestGenerated<T>>
extends OlvidDao<T> {
    public AbstractRemoteRequestDao(ConnectionSource singleConnectionSource, Class<T> clazz) throws SQLException {
        super(singleConnectionSource, clazz);
    }

    public Optional<T> getByMessageRef(Discussion discussion, MessageRef messageRef) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (discussion == null || messageRef == null) {
            AppLogger.e("AbstractRemoteRequestDao.getBySenderSequenceNumber: invalid params");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(AbstractRemoteRequestGenerated.FK_DISCUSSION, discussion).and().eq(AbstractRemoteRequestGenerated.FK_MESSAGE_REF, messageRef);
            return Optional.ofNullable((AbstractRemoteRequestGenerated)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("AbstractRemoteRequestDao.getBySenderSequenceNumber: query error", e);
            return Optional.empty();
        }
    }

    public List<T> getAllByMessageRef(Discussion discussion, MessageRef messageRef) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (discussion == null || messageRef == null) {
            AppLogger.e("AbstractRemoteRequestDao.getAllBySenderSequenceNumber: invalid params");
            return Collections.emptyList();
        }
        try {
            queryBuilder.where().eq(AbstractRemoteRequestGenerated.FK_DISCUSSION, discussion).and().eq(AbstractRemoteRequestGenerated.FK_MESSAGE_REF, messageRef);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("AbstractRemoteRequestDao.getAllBySenderSequenceNumber: Unable to update", throwables);
            return Collections.emptyList();
        }
    }

    public void deleteAllByMessageRef(Discussion discussion, MessageRef messageRef) {
        this.checkThread();
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        if (discussion == null || messageRef == null) {
            AppLogger.e("AbstractRemoteRequestDao.deleteAllByMessageRef: invalid params");
            return;
        }
        try {
            deleteBuilder.where().eq(AbstractRemoteRequestGenerated.FK_DISCUSSION, discussion).and().eq(AbstractRemoteRequestGenerated.FK_MESSAGE_REF, messageRef);
            deleteBuilder.delete();
        }
        catch (SQLException throwables) {
            AppLogger.e("AbstractRemoteRequestDao.deleteAllByMessageRef: Unable to update", throwables);
        }
    }

    public T getByMessageAndIdentityRef(Discussion discussion, MessageRef messageRef, IdentityRef identityRef) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (discussion == null || messageRef == null || identityRef == null) {
            AppLogger.e("AbstractRemoteRequestDao.getByMessageAndIdentityRef: invalid params");
        }
        try {
            queryBuilder.where().eq(AbstractRemoteRequestGenerated.FK_DISCUSSION, discussion).and().eq(AbstractRemoteRequestGenerated.FK_MESSAGE_REF, messageRef).and().eq(AbstractRemoteRequestGenerated.FK_IDENTITY_REF, identityRef);
            return (T)((AbstractRemoteRequestGenerated)queryBuilder.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("AbstractRemoteRequestDao.getByMessageAndIdentityRef: Unable to update", throwables);
            return null;
        }
    }
}

