/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.reaction;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.interfaces.DaoWithForeignMessage;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public abstract class AbstractReactionDao<Message extends AbstractUserMessageGenerated<Message>, Reaction extends AbstractReactionGenerated<Reaction>>
extends OlvidDao<Reaction>
implements DaoWithForeignMessage<Message> {
    protected AbstractReactionDao(ConnectionSource singleConnectionSource, Class<Reaction> reactionClass) throws SQLException {
        super(singleConnectionSource, reactionClass);
    }

    protected abstract Column.ForeignColumn<Reaction, Message> getMessageColumn();

    public List<Reaction> getAllReactionsForDiscussion(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
        ObvQueryBuilder messagesQB = this.messageQueryBuilder(discussionID, sortIndexMin, excludeMin, sortIndexMax, excludeMax);
        ObvQueryBuilder<Object> queryBuilder = this.queryBuilder();
        queryBuilder.where().isNotNull(AbstractReactionGenerated.EMOJI);
        queryBuilder.join(this.getMessageColumn(), AbstractUserMessageGenerated.GEN_ID, messagesQB);
        queryBuilder.orderBy(AbstractReactionGenerated.TIMESTAMP, true);
        return queryBuilder.query();
    }

    public Optional<Reaction> getReaction(Message message, IdentityRef identityRef) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (message == null) {
            AppLogger.w("ReactionDao.getReaction: invalid params");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(this.getMessageColumn(), message).and().eq(AbstractReactionGenerated.FK_SENDER, identityRef);
            return Optional.ofNullable((AbstractReactionGenerated)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("ReactionDao.getReaction: Unable to query", e);
            return Optional.empty();
        }
    }

    public void deleteAllReactionsForMessage(Message message) {
        this.checkThread();
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        if (message == null) {
            AppLogger.w("ReactionDao.deleteAllForMessage: invalid params");
            return;
        }
        try {
            deleteBuilder.where().eq(this.getMessageColumn(), message);
            deleteBuilder.delete();
        }
        catch (SQLException e) {
            AppLogger.e("ReactionDao.deleteAllForMessage: Unable to update", e);
        }
    }

    public void updateEmojiAndTimestamp(Id<Reaction> reactionId, Optional<String> emoji, long timestamp) {
        this.checkThread();
        ObvUpdateBuilder<AbstractReactionGenerated<?>> updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(AbstractReactionGenerated.GEN_ID, reactionId);
            updateBuilder.updateColumnValue(AbstractReactionGenerated.EMOJI, emoji.orElse(null));
            updateBuilder.updateColumnValue(AbstractReactionGenerated.TIMESTAMP, timestamp);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("ReactionDao.updateEmojiAndTimestamp: Unable to update", throwables);
        }
    }
}

