/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.metadata;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.interfaces.DaoWithForeignMessage;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractMessageMetadataDao<Message extends AbstractUserMessageGenerated<Message>, Metadata extends AbstractMessageMetadataGenerated<Metadata>>
extends OlvidDao<Metadata>
implements DaoWithForeignMessage<Message> {
    public AbstractMessageMetadataDao(ConnectionSource singleConnectionSource, Class<Metadata> tableTypeClass) throws SQLException {
        super(singleConnectionSource, tableTypeClass);
    }

    protected abstract ObvQueryBuilder<Metadata> remoteDeletedQueryBuilder() throws SQLException;

    protected abstract Column.ForeignColumn<Metadata, Message> messageColumn();

    public void deleteMessagesMetadata(List<Message> messageList) {
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        this.checkThread();
        if (messageList == null) {
            this.logger.error("Invalid parameters MessageMetadataDao.deleteMessagesMetadata");
            return;
        }
        try {
            deleteBuilder.where().in(this.messageColumn(), messageList.stream().map(AbstractTableGenerated::getItemId).toList());
            deleteBuilder.delete();
        }
        catch (SQLException sqlException) {
            this.logger.error("Error while MessageMetadataDao.deleteMessagesMetadata", sqlException);
        }
    }

    public List<Metadata> getAllMessageMetadataSortedByIndex() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.orderBy(AbstractMessageMetadataGenerated.GEN_ID, true);
            return queryBuilder.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("MessageMetadataDao.getAllMessageMetadataSortedByIndex: Unable to query", sqlException);
            return null;
        }
    }

    public List<Metadata> getAllRemoteDeletedMessageMetadataForDiscussion(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
        ObvQueryBuilder messagesQB = this.messageQueryBuilder(discussionID, sortIndexMin, excludeMin, sortIndexMax, excludeMax);
        ObvQueryBuilder<Metadata> queryBuilder = this.remoteDeletedQueryBuilder();
        queryBuilder.join(this.messageColumn(), AbstractUserMessageGenerated.GEN_ID, messagesQB);
        return queryBuilder.query();
    }

    public List<Metadata> getAllMetadataForMessage(Id<Message> messageID) throws SQLException {
        ObvQueryBuilder<AbstractMessageMetadataGenerated<?>> queryBuilder = this.queryBuilder();
        queryBuilder.where().eq(this.messageColumn(), messageID);
        queryBuilder.orderBy(AbstractMessageMetadataGenerated.TIMESTAMP, true);
        return queryBuilder.query();
    }

    public void updateTimestamp(Metadata messageMetadata, long timestamp) {
        ObvUpdateBuilder<AbstractMessageMetadataGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        if (messageMetadata == null) {
            this.logger.error("Invalid parameters MessageMetadataDao.updateTimestamp");
            return;
        }
        try {
            updateBuilder.where().eq(AbstractMessageMetadataGenerated.GEN_ID, ((AbstractTableGenerated)messageMetadata).getItemId());
            updateBuilder.updateColumnValue(AbstractMessageMetadataGenerated.TIMESTAMP, timestamp);
            updateBuilder.update();
        }
        catch (SQLException sqlException) {
            this.logger.error("Error in MessageMetadataDao.updateTimestamp", sqlException);
        }
    }
}

