/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class PendingMessageDao
extends OlvidDao<PendingMessage> {
    public PendingMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, PendingMessage.class);
    }

    public List<PendingMessage> getAllByMessage(Id<OutboundMessage> outboundMessageId) {
        this.checkThread();
        if (outboundMessageId == null) {
            return Collections.emptyList();
        }
        try {
            ObvQueryBuilder pendingMessageQb = this.queryBuilder();
            pendingMessageQb.where().eq(PendingMessage.FK_MESSAGE, outboundMessageId);
            return pendingMessageQb.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("PendingMessageDao::getAllByMessage couldn't execute request");
            return Collections.emptyList();
        }
    }

    public List<PendingMessage> getAllByDiscussionAndContact(Discussion discussion, byte[] bytesContactIdentity) {
        this.checkThread();
        if (discussion == null || bytesContactIdentity == null) {
            return Collections.emptyList();
        }
        try {
            ObvQueryBuilder pendingMessageQb = this.queryBuilder();
            ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
            contactRefQB.where().eq(ContactRef.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            pendingMessageQb.join(PendingMessage.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
            pendingMessageQb.where().eq(PendingMessage.FK_DISCUSSION, discussion.getItemId());
            return pendingMessageQb.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("PendingMessageDao::getAllByMessage couldn't execute request");
            return Collections.emptyList();
        }
    }

    public List<PendingMessage> getAllByContact(Contact contact) {
        this.checkThread();
        if (contact == null) {
            return Collections.emptyList();
        }
        try {
            ObvQueryBuilder pendingMessageQb = this.queryBuilder();
            ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
            contactRefQB.where().eq(ContactRef.FK_CONTACT, contact);
            pendingMessageQb.join(PendingMessage.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQB);
            return pendingMessageQb.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("PendingMessageDao::getAllByMessage couldn't execute request");
            return Collections.emptyList();
        }
    }
}

