/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.message.AbstractMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessageSequenceInterval;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class OwnedMessageSequenceIntervalDao
extends AbstractMessageSequenceIntervalDao<OwnedMessageSequenceInterval, OwnedMessage> {
    public OwnedMessageSequenceIntervalDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OwnedMessageSequenceInterval.class);
    }

    public Optional<OwnedMessageSequenceInterval> foundInterval(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.foundQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            return Optional.ofNullable((OwnedMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getNextInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    public Optional<OwnedMessageSequenceInterval> getNextInterval(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.nextQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            return Optional.ofNullable((OwnedMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getNextInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    public Optional<OwnedMessageSequenceInterval> getPreviousInterval(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.previousQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            return Optional.ofNullable((OwnedMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getPreviousInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<OwnedMessage> getFirstMessage(OwnedMessageSequenceInterval interval) {
        return DbManager.getInstance().getOwnedMessageDao().get(interval.getDiscussionId(), interval.getStartSequenceNumber(), interval.getSenderThreadIdentifier(), Optional.empty(), Optional.empty());
    }
}

