/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.AbstractUserMessageDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.engine.helpers.message.LinkPreviewInfo;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class OutboundMessageDao
extends AbstractUserMessageDao<OutboundMessage, OutboundMessageEphemeralInfo, OutboundMessageGenerated.Interface> {
    public OutboundMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OutboundMessage.class, "outbound_message_table");
    }

    @Override
    protected Column.ForeignColumn<OutboundMessage, OutboundMessageEphemeralInfo> getEphemeralInfoColumn() {
        return OutboundMessage.FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected AbstractMessageEphemeralInfoDao<OutboundMessage, OutboundMessageEphemeralInfo> getEphemeralInfoDao() {
        return DbManager.getInstance().getOutboundMessageEphemeralInfoDao();
    }

    public boolean updateStatus(Id<OutboundMessage> genId, OutboundMessageGenerated.Status status) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(OutboundMessage.STATUS, status);
            updateBuilder.where().eq(OutboundMessage.GEN_ID, genId);
            return updateBuilder.update() == 1;
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to update message status", throwables);
            return false;
        }
    }

    public void updateContentBody(OutboundMessage message, String contentBody) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.updateColumnValue(OutboundMessage.BODY, contentBody);
            updateBuilder.where().eq(OutboundMessage.GEN_ID, message.getItemId());
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to update message content body", throwables);
        }
    }

    public void updateTimestampAndSortIndex(OutboundMessage message, long timestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        if (message.getStatus() != OutboundMessageGenerated.Status.DRAFT) {
            AppLogger.e("OutboundMessageDao.updateTimestampAndSortIndex: invalid params");
            return;
        }
        this.checkThread();
        try {
            updateBuilder.where().eq(OutboundMessage.GEN_ID, message.getItemId());
            updateBuilder.updateColumnValue(OutboundMessage.TIMESTAMP, timestamp);
            updateBuilder.updateColumnValue(OutboundMessage.SORT_INDEX, (double)timestamp);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("OutboundMessageDao.updateTimestampAndSortIndex: unable to update", e);
        }
    }

    public void updateBodyAndMarkAsEdited(Id<OutboundMessage> genId, Optional<String> newBody) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OutboundMessage.GEN_ID, genId);
            updateBuilder.updateColumnValue(OutboundMessage.BODY, newBody.orElse(null));
            updateBuilder.updateColumnValue(OutboundMessage.EDITION_STATUS, AbstractUserMessageGenerated.EditionStatus.UNSEEN);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateBodyAndMarkAsEdited: Unable to update", throwables);
        }
    }

    public void updateDraftToUnprocessed(Id<OutboundMessage> genId, Optional<String> body, long senderSequenceNumber, long timestamp, int totalAttachmentCount, int imageCount, Optional<LinkPreviewInfo> linkPreviewInfo) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OutboundMessage.GEN_ID, genId);
            updateBuilder.updateColumnValue(OutboundMessage.SENDER_SEQUENCE_NUMBER, senderSequenceNumber);
            updateBuilder.updateColumnValue(OutboundMessage.BODY, body.orElse(null));
            updateBuilder.updateColumnValue(OutboundMessage.TIMESTAMP, timestamp);
            updateBuilder.updateColumnValue(OutboundMessage.SORT_INDEX, (double)timestamp);
            updateBuilder.updateColumnValue(OutboundMessage.STATUS, OutboundMessageGenerated.Status.UNPROCESSED);
            updateBuilder.updateColumnValue(OutboundMessage.TOTAL_ATTACHMENT_COUNT, totalAttachmentCount);
            updateBuilder.updateColumnValue(OutboundMessage.IMAGE_COUNT, imageCount);
            this.updateLinkPreviewInfo(updateBuilder, linkPreviewInfo);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateBodyAndMarkAsEdited: Unable to update", throwables);
        }
    }

    @Override
    public Optional<OutboundMessageEphemeralInfo> getEphemeralInfo(OutboundMessage message) {
        if (message.getOutboundMessageEphemeralInfoId().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(DbManager.getInstance().getOutboundMessageEphemeralInfoDao().get(message.getOutboundMessageEphemeralInfoId().get()));
    }

    public byte[] getSenderIdentifier(OutboundMessage message) {
        this.checkThread();
        ObvQueryBuilder discussionQb = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder ownedIdentityQb = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        try {
            discussionQb.where().eq(Discussion.GEN_ID, message.getDiscussionId());
            ownedIdentityQb.join(OwnedIdentity.GEN_ID, Discussion.FK_OWNED_IDENTITY, discussionQb);
            return ((OwnedIdentity)ownedIdentityQb.queryForFirst()).getBytesOwnedIdentity();
        }
        catch (SQLException throwables) {
            AppLogger.e("getSenderIdentifier: Unable to query", throwables);
            return null;
        }
    }

    @Override
    public Optional<Double> getNextSortIndex(double minSortIndex, Discussion discussion) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getNextSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(OutboundMessage.FK_DISCUSSION, discussion).and().gt(OutboundMessage.SORT_INDEX, minSortIndex).and().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT);
            messageQB.selectColumns(OutboundMessage.SORT_INDEX);
            messageQB.orderBy(OutboundMessage.SORT_INDEX, true);
            OutboundMessage message = (OutboundMessage)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getNextSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Double> getPreviousSortIndex(double maxSortIndex, Discussion discussion) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getPreviousSortIndex");
            return Optional.empty();
        }
        try {
            messageQB.where().eq(OutboundMessage.FK_DISCUSSION, discussion).and().lt(OutboundMessage.SORT_INDEX, maxSortIndex).and().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT);
            messageQB.selectColumns(OutboundMessage.SORT_INDEX);
            messageQB.orderBy(OutboundMessage.SORT_INDEX, false);
            OutboundMessage message = (OutboundMessage)messageQB.queryForFirst();
            if (message == null) {
                return Optional.empty();
            }
            return Optional.of(message.getSortIndex());
        }
        catch (SQLException throwables) {
            AppLogger.e("getPreviousSortIndex: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    public Optional<OutboundMessage> get(Id<Discussion> discussionId, JsonMessageReference reference) {
        return super.get(discussionId, reference.getSenderSequenceNumber(), reference.getSenderThreadIdentifier(), Optional.empty(), Optional.empty());
    }

    public Optional<OutboundMessage> getDiscussionDraftMessage(Id<Discussion> discussion) {
        this.checkThread();
        ObvQueryBuilder messageQB = this.queryBuilder();
        try {
            messageQB.where().eq(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT).and().eq(OutboundMessage.FK_DISCUSSION, discussion);
            messageQB.orderBy(OutboundMessage.TIMESTAMP, false);
            messageQB.limit(1L);
            return Optional.ofNullable((OutboundMessage)messageQB.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("getDiscussionDraftMessage: Unable to query", throwables);
            return Optional.empty();
        }
    }

    public void updateDraftReplyTo(Id<OutboundMessage> draftId, Optional<MessageRef> toReplyMessage) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(OutboundMessage.GEN_ID, draftId);
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(OutboundMessage.FK_REPLY_TO, toReplyMessage.orElse(null));
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateDraftReplyTo: Unable to update", throwables);
        }
    }

    public OutboundMessage getMessage(Id<OutboundMessageEphemeralInfo> ephemeralInfoId) {
        ObvQueryBuilder messageQB = this.queryBuilder();
        this.checkThread();
        try {
            messageQB.where().eq(OutboundMessage.FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO, ephemeralInfoId);
            return (OutboundMessage)messageQB.queryForFirst();
        }
        catch (SQLException e) {
            AppLogger.e("OutboundMessageDao.getMessage: unable to query", e);
            return null;
        }
    }

    public Optional<OutboundMessage> getLastMessageForDiscussionWithoutDraft(Discussion discussion) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getLastMessageForDiscussion");
            return Optional.empty();
        }
        try {
            queryBuilder.where().eq(AbstractMessageGenerated.FK_DISCUSSION, discussion).and().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT);
            queryBuilder.orderBy(OutboundMessage.SORT_INDEX, false);
            return Optional.ofNullable((OutboundMessage)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getLastMessageForDiscussion: Unable to query: ", e);
            return Optional.empty();
        }
    }

    @Override
    protected List<SortableItemId> computeSortedMessagesItemIdByDiscussion(ObvQueryBuilder<OutboundMessage> queryBuilder) throws SQLException {
        queryBuilder.where().and().ne(OutboundMessage.STATUS, OutboundMessageGenerated.Status.DRAFT);
        return super.computeSortedMessagesItemIdByDiscussion(queryBuilder);
    }

    @Override
    protected SortableItemId getItemId(Id<OutboundMessage> messageId, double sortIndex) {
        return SortableItemId.ofOutbound(messageId, sortIndex);
    }

    @Override
    protected List<Column<? super OutboundMessage>> getMapRowColumns() {
        return OutboundMessage.MAP_ROW_COLUMNS;
    }

    @Override
    protected OutboundMessageGenerated.Interface make(OutboundMessage outboundMessage) {
        return outboundMessage;
    }

    @Override
    protected SortableItemId ofSpecificItemIdWithSortIndex(long id, double sortIndex) {
        return SortableItemId.ofOutbound(new Id<OutboundMessage>(OutboundMessage.class, id), sortIndex);
    }
}

