/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public class MessageRecipientInfoDao
extends OlvidDao<MessageRecipientInfo> {
    public MessageRecipientInfoDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, MessageRecipientInfo.class);
    }

    public List<MessageRecipientInfo> getAllByMessage(Id<OutboundMessage> message) {
        try {
            ObvQueryBuilder queryBuilder = this.queryBuilder();
            queryBuilder.where().eq(MessageRecipientInfo.FK_MESSAGE, message);
            queryBuilder.selectColumns(MessageRecipientInfo.FK_RECIPIENT_REF, MessageRecipientInfo.TIMESTAMP_SENT, MessageRecipientInfo.TIMESTAMP_DELIVERED, MessageRecipientInfo.TIMESTAMP_READ);
            return queryBuilder.query();
        }
        catch (SQLException e) {
            AppLogger.e("Unable to get all recipient info by message", e);
            return null;
        }
    }

    public List<MessageRecipientInfo> getUnprocessedFromMessage(OutboundMessage message) {
        try {
            ObvQueryBuilder messageRecipientInfoQB = this.queryBuilder();
            messageRecipientInfoQB.where().eq(MessageRecipientInfo.FK_MESSAGE, message);
            return messageRecipientInfoQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to get all recipient info by message");
            return null;
        }
    }

    public List<MessageRecipientInfo> getAllByEngineMessageIdentifier(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier) {
        ObvQueryBuilder identityQueryBuilder = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        ObvQueryBuilder discussionQueryBuilder = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder messageQueryBuilder = DbManager.getInstance().getOutboundMessageDao().queryBuilder();
        ObvQueryBuilder messageRecipientInfoQueryBuilder = this.queryBuilder();
        try {
            identityQueryBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            discussionQueryBuilder.join(Discussion.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, identityQueryBuilder);
            messageQueryBuilder.join(OwnedMessage.FK_DISCUSSION, Discussion.GEN_ID, discussionQueryBuilder);
            messageRecipientInfoQueryBuilder.where().eq(MessageRecipientInfo.ENGINE_MESSAGE_IDENTIFIER, engineMessageIdentifier);
            messageRecipientInfoQueryBuilder.join(MessageRecipientInfo.FK_MESSAGE, OutboundMessage.GEN_ID, messageQueryBuilder);
            return messageRecipientInfoQueryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllByEngineMessageIdentifier: exception raised", throwables);
            return null;
        }
    }

    public byte[][] getReturnReceiptKeysForNonce(byte[] returnReceiptNonce) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.selectColumns(MessageRecipientInfo.RETURN_RECEIPT_KEY).distinct().where().eq(MessageRecipientInfo.RETURN_RECEIPT_NONCE, returnReceiptNonce);
            List queryResult = queryBuilder.query();
            if (queryResult.isEmpty()) {
                AppLogger.t("No return receipt keys from nonce found");
                return new byte[0][];
            }
            byte[][] returnReceiptKeys = new byte[queryResult.size()][];
            for (int i = 0; i < returnReceiptKeys.length; ++i) {
                returnReceiptKeys[i] = ((MessageRecipientInfo)queryResult.get(i)).getReturnReceiptKey();
            }
            return returnReceiptKeys;
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to getReturnReceiptKeysForNonce", throwables);
            return null;
        }
    }

    public List<MessageRecipientInfo> getFromReturnReceipt(IdentityRef identityRef, byte[] returnReceiptNonce, byte[] goodReturnReceiptKey) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(MessageRecipientInfo.FK_RECIPIENT_REF, identityRef).and().eq(MessageRecipientInfo.RETURN_RECEIPT_NONCE, returnReceiptNonce).and().eq(MessageRecipientInfo.RETURN_RECEIPT_KEY, goodReturnReceiptKey);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to getFromReturnReceipt", throwables);
            return null;
        }
    }

    public List<MessageRecipientInfo> getUnsentForContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        ObvQueryBuilder identityQueryBuilder = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        ObvQueryBuilder discussionQueryBuilder = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder messageQueryBuilder = DbManager.getInstance().getOutboundMessageDao().queryBuilder();
        ObvQueryBuilder messageRecipientInfoQueryBuilder = this.queryBuilder();
        ObvQueryBuilder contactRefQueryBuilder = DbManager.getInstance().getContactRefDao().queryBuilder();
        ObvQueryBuilder identityRefQueryBuilder = DbManager.getInstance().getIdentityRefDao().queryBuilder();
        try {
            contactRefQueryBuilder.where().eq(ContactRef.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            identityRefQueryBuilder.join(IdentityRef.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQueryBuilder);
            messageRecipientInfoQueryBuilder.join(MessageRecipientInfo.FK_RECIPIENT_REF, IdentityRef.GEN_ID, identityRefQueryBuilder);
            identityQueryBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            discussionQueryBuilder.join(Discussion.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, identityQueryBuilder);
            messageQueryBuilder.join(OutboundMessage.FK_DISCUSSION, Discussion.GEN_ID, discussionQueryBuilder);
            messageRecipientInfoQueryBuilder.join(MessageRecipientInfo.FK_MESSAGE, OutboundMessage.GEN_ID, messageQueryBuilder);
            return messageRecipientInfoQueryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query for getUnsentForContact", throwables);
            return null;
        }
    }

    public List<MessageRecipientInfo> getUnsentForContactInDiscussion(Discussion discussion, Id<Contact> contactId) {
        ObvQueryBuilder messageQueryBuilder = DbManager.getInstance().getOutboundMessageDao().queryBuilder();
        ObvQueryBuilder messageRecipientInfoQueryBuilder = this.queryBuilder();
        ObvQueryBuilder contactRefQueryBuilder = DbManager.getInstance().getContactRefDao().queryBuilder();
        ObvQueryBuilder identityRefQueryBuilder = DbManager.getInstance().getIdentityRefDao().queryBuilder();
        try {
            contactRefQueryBuilder.where().eq(ContactRef.FK_CONTACT, contactId);
            identityRefQueryBuilder.join(IdentityRef.FK_CONTACT_REF, ContactRef.GEN_ID, contactRefQueryBuilder);
            messageRecipientInfoQueryBuilder.join(MessageRecipientInfo.FK_RECIPIENT_REF, IdentityRef.GEN_ID, identityRefQueryBuilder);
            messageQueryBuilder.where().eq(OutboundMessage.FK_DISCUSSION, discussion);
            messageRecipientInfoQueryBuilder.join(MessageRecipientInfo.FK_MESSAGE, OutboundMessage.GEN_ID, messageQueryBuilder);
            return messageRecipientInfoQueryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query for getUnsentForContact", throwables);
            return null;
        }
    }

    public List<MessageRecipientInfo> getAllMessageRecipientInfoSortedByIndex() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.orderBy(MessageRecipientInfo.GEN_ID, true);
            return queryBuilder.query();
        }
        catch (SQLException sqlException) {
            this.logger.error("getAllMessageRecipientInfoSortedByIndex: Unable to query", sqlException);
            return null;
        }
    }

    public Long getOriginalServerTimestampForMessage(OutboundMessage message) {
        ObvQueryBuilder messageRecipientInfoQueryBuilder = this.queryBuilder();
        try {
            messageRecipientInfoQueryBuilder.where().eq(MessageRecipientInfo.FK_MESSAGE, message);
            String query = "SELECT MIN(" + String.valueOf(MessageRecipientInfo.TIMESTAMP_SENT) + ") as " + String.valueOf(MessageRecipientInfo.TIMESTAMP_SENT) + " FROM message_recipient_info_table WHERE " + String.valueOf(MessageRecipientInfo.FK_MESSAGE) + " = " + ((Id)message.getItemId()).getId() + " AND " + String.valueOf(MessageRecipientInfo.TIMESTAMP_SENT) + " IS NOT NULL";
            GenericRawResults genericRawResults = this.queryRaw(query, MessageRecipientInfoDao::mapOriginalTimestampResult);
            return (Long)genericRawResults.getFirstResult();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query for getUnsentForContact", throwables);
            return null;
        }
    }

    public static Long mapOriginalTimestampResult(DatabaseResults databaseResults) {
        try {
            return MessageRecipientInfo.getLongObj(databaseResults, MessageRecipientInfo.TIMESTAMP_SENT, "");
        }
        catch (SQLException sqlException) {
            AppLogger.e("MessageRecipientInfoDao mapOriginalTimestampResult() Failed", sqlException);
            return null;
        }
    }
}

