/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.message.AbstractMessageSequenceIntervalDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.InboundMessageSequenceInterval;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class InboundMessageSequenceIntervalDao
extends AbstractMessageSequenceIntervalDao<InboundMessageSequenceInterval, InboundMessage> {
    public InboundMessageSequenceIntervalDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, InboundMessageSequenceInterval.class);
    }

    public Optional<InboundMessageSequenceInterval> foundInterval(Id<Discussion> discussionId, ContactRef contactRef, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.foundQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            ObvWhere where = queryBuilder.where();
            where.and().eq(InboundMessageSequenceInterval.FK_SENDER, contactRef);
            return Optional.ofNullable((InboundMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("foundInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    public Optional<InboundMessageSequenceInterval> getNextInterval(Id<Discussion> discussionId, ContactRef contactRef, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.nextQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            ObvWhere where = queryBuilder.where();
            where.and().eq(InboundMessageSequenceInterval.FK_SENDER, contactRef);
            return Optional.ofNullable((InboundMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getNextInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    public Optional<InboundMessageSequenceInterval> getPreviousInterval(Id<Discussion> discussionId, ContactRef contactRef, UUID senderThreadIdentifier, long senderSequenceNumber) {
        try {
            ObvQueryBuilder queryBuilder = this.previousQueryBuilder(discussionId, senderThreadIdentifier, senderSequenceNumber);
            ObvWhere where = queryBuilder.where();
            where.and().eq(InboundMessageSequenceInterval.FK_SENDER, contactRef);
            return Optional.ofNullable((InboundMessageSequenceInterval)queryBuilder.queryForFirst());
        }
        catch (SQLException e) {
            AppLogger.e("getPreviousInterval: Unable to query", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<InboundMessage> getFirstMessage(InboundMessageSequenceInterval interval) {
        try {
            ObvQueryBuilder contactRefQueryBuilder = DbManager.getInstance().getContactRefDao().queryBuilder();
            contactRefQueryBuilder.where().eq(ContactRef.GEN_ID, interval.getSenderId());
            return DbManager.getInstance().getInboundMessageDao().get(interval.getDiscussionId(), interval.getStartSequenceNumber(), interval.getSenderThreadIdentifier(), Optional.of(InboundMessage.FK_SENDER), Optional.of(contactRefQueryBuilder));
        }
        catch (SQLException e) {
            AppLogger.e("getFirstMessage: Unable to query", e);
            return Optional.empty();
        }
    }
}

