/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.dao.message.ReceivedMessageDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonMessageReference;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class InboundMessageDao
extends ReceivedMessageDao<InboundMessage, InboundMessageEphemeralInfo, InboundMessageGenerated.Interface> {
    public InboundMessageDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, InboundMessage.class, "inbound_message_table");
    }

    @Override
    protected Column.ForeignColumn<InboundMessage, InboundMessageEphemeralInfo> getEphemeralInfoColumn() {
        return InboundMessage.FK_INBOUND_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected AbstractMessageEphemeralInfoDao<InboundMessage, InboundMessageEphemeralInfo> getEphemeralInfoDao() {
        return DbManager.getInstance().getInboundMessageEphemeralInfoDao();
    }

    public void updateBoxed(Id<InboundMessage> inboundMessageId, boolean boxed) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(InboundMessage.GEN_ID, inboundMessageId);
            updateBuilder.updateColumnValue(InboundMessage.BOXED, boxed);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateBoxed: Unable to updateBoxed", throwables);
        }
    }

    private void configureUnreadMessagesWhere(ObvWhere<InboundMessage> where, Id<Discussion> discussionId, Optional<Long> maxTimestamp) throws SQLException {
        where.eq(InboundMessage.FK_DISCUSSION, discussionId).and().eq(InboundMessage.STATUS, InboundMessageGenerated.Status.UNREAD);
        if (maxTimestamp.isPresent()) {
            where.and().le(InboundMessage.TIMESTAMP, (long)maxTimestamp.get());
        }
    }

    private ObvQueryBuilder<InboundMessage> getAllUnreadDiscussionMessagesQuery(Id<Discussion> discussionId, Optional<Long> maxTimestamp) throws SQLException {
        ObvQueryBuilder<InboundMessage> messageQB = this.queryBuilder();
        this.configureUnreadMessagesWhere(messageQB.where(), discussionId, maxTimestamp);
        return messageQB;
    }

    public int getAllUnreadDiscussionCount(Id<Discussion> discussionId) {
        this.checkThread();
        try {
            ObvQueryBuilder<InboundMessage> query = this.getAllUnreadDiscussionMessagesQuery(discussionId, Optional.empty());
            query.selectColumns(InboundMessage.GEN_ID);
            query.limit(100L);
            return Math.toIntExact(query.countOf());
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllUnreadDiscussionCount: Unable to query", throwables);
            return 0;
        }
    }

    public List<InboundMessage> getAllUnreadDiscussionMessagesUpTo(Id<Discussion> discussionId, Optional<Long> timestamp) {
        this.checkThread();
        try {
            ObvQueryBuilder<InboundMessage> query = this.getAllUnreadDiscussionMessagesQuery(discussionId, timestamp);
            return query.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllUnreadDiscussionMessagesUpTo: Unable to query", throwables);
            return null;
        }
    }

    public byte[] getSenderIdentifier(InboundMessage message) {
        this.checkThread();
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(message.getSenderId());
        return contactRef.getBytesContactIdentity();
    }

    @Override
    public Optional<InboundMessageEphemeralInfo> getEphemeralInfo(InboundMessage message) {
        if (message.getInboundMessageEphemeralInfoId().isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(DbManager.getInstance().getInboundMessageEphemeralInfoDao().get(message.getInboundMessageEphemeralInfoId().get()));
    }

    @Override
    public Optional<InboundMessage> get(Id<Discussion> discussionId, JsonMessageReference reference) {
        if (discussionId == null || reference == null) {
            AppLogger.e("InboundMessageDao.get(Discussion, JsonMessageReference): invalid params");
            return Optional.empty();
        }
        ObvQueryBuilder contactRefQueryBuilder = DbManager.getInstance().getContactRefDao().queryBuilder();
        byte[] senderIdentifier = reference.getSenderIdentifier();
        if (senderIdentifier == null) {
            AppLogger.e("InboundMessageDao.get(Discussion, JsonMessageReference): invalid params");
            return Optional.empty();
        }
        try {
            contactRefQueryBuilder.where().eq(ContactRef.BYTES_CONTACT_IDENTITY, senderIdentifier);
        }
        catch (SQLException e) {
            AppLogger.e("InboundMessageDao.get(Discussion, JsonMessageReference): Unable to update", e);
            return Optional.empty();
        }
        return super.get(discussionId, reference.getSenderSequenceNumber(), reference.getSenderThreadIdentifier(), Optional.of(InboundMessage.FK_SENDER), Optional.of(contactRefQueryBuilder));
    }

    public int markDiscussionMessagesReadUpTo(Id<Discussion> discussionId, Optional<Long> maxTimestamp) {
        this.checkThread();
        ObvUpdateBuilder messageUpdate = this.updateBuilder();
        try {
            this.configureUnreadMessagesWhere(messageUpdate.where(), discussionId, maxTimestamp);
            messageUpdate.updateColumnValue(InboundMessage.STATUS, InboundMessageGenerated.Status.READ);
            return messageUpdate.update();
        }
        catch (SQLException e) {
            AppLogger.e("markDiscussionMessagesReadUpTo: Unable to update", e);
            return 0;
        }
    }

    public Optional<Long> getLastReadMessageTimestamp(Id<Discussion> discussionId) {
        this.checkThread();
        try {
            ObvQueryBuilder query = this.queryBuilder();
            query.selectColumns(InboundMessage.TIMESTAMP);
            query.where().eq(InboundMessage.FK_DISCUSSION, discussionId).and().eq(InboundMessage.STATUS, InboundMessageGenerated.Status.READ);
            query.orderBy(InboundMessage.TIMESTAMP, false);
            query.limit(1L);
            return Optional.ofNullable((InboundMessage)query.queryForFirst()).map(AbstractMessageGenerated::getTimestamp);
        }
        catch (SQLException throwables) {
            AppLogger.e("getLastReadMessageTimestamp: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    protected SortableItemId getItemId(Id<InboundMessage> inboundMessageId, double sortIndex) {
        return SortableItemId.ofInbound(inboundMessageId, sortIndex);
    }

    @Override
    public List<SortableItemId> ftsInDiscussion(Id<Discussion> discussionId, List<String> tokenizedStrings) {
        block10: {
            List list;
            block9: {
                this.checkThread();
                String preformattedString = "SELECT %s.`%s` AS a_%s, %s.`%s` AS a_%s from %s JOIN %s ON %s.`%s` = %s.`%s` LEFT JOIN %s ON %s.`%s` = %s.`%s` WHERE (%s.`%s`IS NULL OR (%s.`%s` = \"%s\" OR %s.`%s` IS NOT NULL OR %s.`%s` IS NOT NULL)) AND %s.`%s` = %s AND %s.`%s` MATCH '%s' ORDER BY %s.`%s`";
                String query = String.format("SELECT %s.`%s` AS a_%s, %s.`%s` AS a_%s from %s JOIN %s ON %s.`%s` = %s.`%s` LEFT JOIN %s ON %s.`%s` = %s.`%s` WHERE (%s.`%s`IS NULL OR (%s.`%s` = \"%s\" OR %s.`%s` IS NOT NULL OR %s.`%s` IS NOT NULL)) AND %s.`%s` = %s AND %s.`%s` MATCH '%s' ORDER BY %s.`%s`", this.tableName, AbstractUserMessageGenerated.GEN_ID, AbstractUserMessageGenerated.GEN_ID, this.tableName, AbstractUserMessageGenerated.SORT_INDEX, AbstractUserMessageGenerated.SORT_INDEX, this.tableName, this.tableName + "_fts", this.tableName, AbstractUserMessageGenerated.GEN_ID, this.tableName + "_fts", "rowid", "inbound_message_ephemeral_info_table", this.tableName, InboundMessage.FK_INBOUND_MESSAGE_EPHEMERAL_INFO, "inbound_message_ephemeral_info_table", InboundMessageEphemeralInfo.GEN_ID, this.tableName, InboundMessage.FK_INBOUND_MESSAGE_EPHEMERAL_INFO, this.tableName, InboundMessage.WIPE_STATUS, AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ, "inbound_message_ephemeral_info_table", InboundMessageEphemeralInfo.EXISTENCE_TIMESTAMP, "inbound_message_ephemeral_info_table", InboundMessageEphemeralInfo.VISIBILITY_TIMESTAMP, this.tableName, AbstractUserMessageGenerated.FK_DISCUSSION, discussionId.getId(), this.tableName + "_fts", AbstractUserMessageGenerated.BODY, InboundMessageDao.tokenize(tokenizedStrings), this.tableName, AbstractUserMessageGenerated.SORT_INDEX);
                GenericRawResults results = this.queryRaw(query, databaseResults -> this.mapFtsRawQuery(databaseResults, "a_"));
                try {
                    list = results.getResults();
                    if (results == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (results != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        AppLogger.e("ftsInDiscussion: couldn't execute raw query", e);
                        break block10;
                    }
                    catch (Exception e) {
                        AppLogger.e("ftsInDiscussion: General error", e);
                    }
                }
                results.close();
            }
            return list;
        }
        return List.of();
    }

    public final InboundMessageInfo getSortedMessagesItemIdByDiscussionWithUnreadInfo(Id<Discussion> discussionId) {
        List<SortableItemId> sortedMessagesItemIdByDiscussion = this.getSortedMessagesItemIdByDiscussion(discussionId);
        Optional<Id<InboundMessage>> firstUnread = this.getFirstUnread(discussionId);
        return new InboundMessageInfo(sortedMessagesItemIdByDiscussion, firstUnread);
    }

    public Optional<Id<InboundMessage>> getFirstUnread(Id<Discussion> discussionId) {
        this.checkThread();
        try {
            ObvQueryBuilder<InboundMessage> query = this.getAllUnreadDiscussionMessagesQuery(discussionId, Optional.empty());
            query.orderBy(InboundMessage.SORT_INDEX, true);
            query.selectColumns(InboundMessage.GEN_ID);
            query.limit(1L);
            return Optional.ofNullable(query.queryForFirst()).map(AbstractTableGenerated::getItemId);
        }
        catch (SQLException throwables) {
            AppLogger.e("getFirstUnread: Unable to query", throwables);
            return Optional.empty();
        }
    }

    @Override
    protected SortableItemId ofSpecificItemIdWithSortIndex(long id, double sortIndex) {
        return SortableItemId.ofInbound(new Id<InboundMessage>(InboundMessage.class, id), sortIndex);
    }

    @Override
    protected List<Column<? super InboundMessage>> getMapRowColumns() {
        return InboundMessage.MAP_ROW_COLUMNS;
    }

    @Override
    protected InboundMessageGenerated.Interface make(InboundMessage inboundMessage) {
        return inboundMessage;
    }

    public record InboundMessageInfo(List<SortableItemId> inboundMessageIds, Optional<Id<InboundMessage>> firstUnreadMessage) {
    }
}

