/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.message;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvWhere;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageSequenceIntervalGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractMessageSequenceIntervalDao<Interval extends AbstractMessageSequenceIntervalGenerated<Interval>, Message extends ReceivedMessageGenerated<Message>>
extends OlvidDao<Interval> {
    public AbstractMessageSequenceIntervalDao(ConnectionSource singleConnectionSource, Class<Interval> intervalClass) throws SQLException {
        super(singleConnectionSource, intervalClass);
    }

    protected ObvQueryBuilder<Interval> foundQueryBuilder(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) throws SQLException {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        ObvWhere<AbstractMessageSequenceIntervalGenerated<?>> where = queryBuilder.where();
        where.eq(AbstractMessageSequenceIntervalGenerated.FK_DISCUSSION, discussionId).and().eq(AbstractMessageSequenceIntervalGenerated.SENDER_THREAD_IDENTIFIER, senderThreadIdentifier).and().le(AbstractMessageSequenceIntervalGenerated.START_SEQUENCE_NUMBER, senderSequenceNumber).and().ge(AbstractMessageSequenceIntervalGenerated.END_SEQUENCE_NUMBER, senderSequenceNumber);
        return queryBuilder;
    }

    protected ObvQueryBuilder<Interval> previousQueryBuilder(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) throws SQLException {
        ObvQueryBuilder<AbstractMessageSequenceIntervalGenerated<?>> queryBuilder = this.queryBuilder();
        ObvWhere<AbstractMessageSequenceIntervalGenerated<?>> where = queryBuilder.where();
        where.eq(AbstractMessageSequenceIntervalGenerated.FK_DISCUSSION, discussionId).and().eq(AbstractMessageSequenceIntervalGenerated.SENDER_THREAD_IDENTIFIER, senderThreadIdentifier).and().lt(AbstractMessageSequenceIntervalGenerated.END_SEQUENCE_NUMBER, senderSequenceNumber);
        queryBuilder.orderBy(AbstractMessageSequenceIntervalGenerated.START_SEQUENCE_NUMBER, false);
        return queryBuilder;
    }

    protected ObvQueryBuilder<Interval> nextQueryBuilder(Id<Discussion> discussionId, UUID senderThreadIdentifier, long senderSequenceNumber) throws SQLException {
        ObvQueryBuilder<AbstractMessageSequenceIntervalGenerated<?>> queryBuilder = this.queryBuilder();
        ObvWhere<AbstractMessageSequenceIntervalGenerated<?>> where = queryBuilder.where();
        where.eq(AbstractMessageSequenceIntervalGenerated.FK_DISCUSSION, discussionId).and().eq(AbstractMessageSequenceIntervalGenerated.SENDER_THREAD_IDENTIFIER, senderThreadIdentifier).and().gt(AbstractMessageSequenceIntervalGenerated.START_SEQUENCE_NUMBER, senderSequenceNumber);
        queryBuilder.orderBy(AbstractMessageSequenceIntervalGenerated.START_SEQUENCE_NUMBER, true);
        return queryBuilder;
    }

    public void deleteAllIntervalsForDiscussion(Id<Discussion> discussionId) throws SQLException {
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        ObvWhere<AbstractMessageSequenceIntervalGenerated<?>> where = deleteBuilder.where();
        where.eq(AbstractMessageSequenceIntervalGenerated.FK_DISCUSSION, discussionId);
        deleteBuilder.delete();
    }

    public abstract Optional<Message> getFirstMessage(Interval var1);
}

