/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.ephemerality;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.ephemerality.AbstractMessageEphemeralInfoDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import java.sql.SQLException;
import java.util.Optional;

public class OwnedMessageEphemeralInfoDao
extends AbstractMessageEphemeralInfoDao<OwnedMessage, OwnedMessageEphemeralInfo> {
    public OwnedMessageEphemeralInfoDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, OwnedMessageEphemeralInfo.class, "owned_message_ephemeral_info_table");
    }

    @Override
    protected ObvQueryBuilder<OwnedMessage> messageQueryBuilder(Id<Discussion> discussionId) throws SQLException {
        ObvQueryBuilder<OwnedMessage> queryBuilder = DbManager.getInstance().getOwnedMessageDao().queryBuilder();
        queryBuilder.where().eq(InboundMessage.FK_DISCUSSION, discussionId);
        return queryBuilder;
    }

    @Override
    protected Column.ForeignColumn<OwnedMessage, OwnedMessageEphemeralInfo> getEphemeralInfoColumn() {
        return OwnedMessage.FK_OWNED_MESSAGE_EPHEMERAL_INFO;
    }

    @Override
    protected Optional<Id<OwnedMessageEphemeralInfo>> getInfoId(OwnedMessage ownedMessage) {
        return ownedMessage.getOwnedMessageEphemeralInfoId();
    }

    @Override
    protected void clearVisibilityExpirationInfoAux(ObvUpdateBuilder<OwnedMessageEphemeralInfo> updateBuilder) throws SQLException {
        updateBuilder.updateColumnValue(OwnedMessageEphemeralInfo.RETAIN_WIPED_MESSAGE, false);
    }
}

