/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.ephemerality;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMessageEphemeralInfoDao<Message extends AbstractUserMessageGenerated<Message>, Info extends AbstractMessageEphemeralInfoGenerated<Info>>
extends OlvidDao<Info> {
    private final String tableName;

    protected abstract ObvQueryBuilder<Message> messageQueryBuilder(Id<Discussion> var1) throws SQLException;

    protected abstract Column.ForeignColumn<Message, Info> getEphemeralInfoColumn();

    protected AbstractMessageEphemeralInfoDao(ConnectionSource singleConnectionSource, Class<Info> tableTypeClass, String tableName) throws SQLException {
        super(singleConnectionSource, tableTypeClass);
        this.tableName = tableName;
    }

    public void updateExistenceExpiration(Id<Info> id, long timestamp) {
        ObvUpdateBuilder<AbstractMessageEphemeralInfoGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractMessageEphemeralInfoGenerated.GEN_ID, id);
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.EXISTENCE_TIMESTAMP, Long.valueOf(timestamp));
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("MessageEphemeralInfoDao.updateVisibilityExpiration: unable to update", e);
        }
    }

    public List<Info> getAllExpired(long currentTimeMillis) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            return queryBuilder.where().le(AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP, (Long)currentTimeMillis).or().le(AbstractMessageEphemeralInfoGenerated.EXISTENCE_TIMESTAMP, (Long)currentTimeMillis).query();
        }
        catch (SQLException e) {
            AppLogger.e("getAllExpired : unable to get all expired messages", e);
            return null;
        }
    }

    public Optional<Long> getNextExpiration() {
        Optional<Long> optional;
        block8: {
            this.checkThread();
            String query = "SELECT MIN(%s) AS min_%s, MIN(%s) AS min_%s FROM %s".formatted(AbstractMessageEphemeralInfoGenerated.EXISTENCE_TIMESTAMP.name, AbstractMessageEphemeralInfoGenerated.EXISTENCE_TIMESTAMP.name, AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP.name, AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP.name, this.tableName);
            GenericRawResults results = this.queryRaw(query, result -> this.mapMin(result, AbstractMessageEphemeralInfoGenerated.EXISTENCE_TIMESTAMP, AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP, "min_"));
            try {
                optional = Optional.ofNullable((Long)results.getFirstResult());
                if (results == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AppLogger.e("getNextExpiration: unable to get next expiring message", e);
                    return Optional.empty();
                }
            }
            results.close();
        }
        return optional;
    }

    private Long mapMin(DatabaseResults databaseResults, Column.ObjectColumn<AbstractMessageEphemeralInfoGenerated<?>, Long> col1, Column.ObjectColumn<AbstractMessageEphemeralInfoGenerated<?>, Long> col2, String prefix) {
        try {
            Long val1 = AbstractTableGenerated.getLongObj(databaseResults, col1, prefix);
            Long val2 = AbstractTableGenerated.getLongObj(databaseResults, col2, prefix);
            if (val1 == null) {
                return val2;
            }
            if (val2 == null) {
                return val1;
            }
            return Math.min(val1, val2);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public List<Info> getAllMessageEphemeralInfoForDiscussion(Id<Discussion> discussionID) throws SQLException {
        ObvQueryBuilder<Message> messagesQB = this.messageQueryBuilder(discussionID);
        ObvQueryBuilder<Info> messageEphemeralInfoQB = this.queryBuilder();
        messageEphemeralInfoQB.join(AbstractMessageEphemeralInfoGenerated.GEN_ID, this.getEphemeralInfoColumn(), messagesQB);
        return messageEphemeralInfoQB.query();
    }

    protected abstract Optional<Id<Info>> getInfoId(Message var1);

    public final void clearVisibilityExpirationInfo(Message message) {
        Optional<Id<Info>> infoId = this.getInfoId(message);
        if (infoId.isEmpty()) {
            return;
        }
        ObvUpdateBuilder<AbstractMessageEphemeralInfoGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractMessageEphemeralInfoGenerated.GEN_ID, infoId.get());
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP, null);
            this.clearVisibilityExpirationInfoAux(updateBuilder);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("clearVisibilityExpirationInfo: cannot perform operation", e);
        }
    }

    protected abstract void clearVisibilityExpirationInfoAux(ObvUpdateBuilder<Info> var1) throws SQLException;

    public void clearReadOnceInfo(Message message) {
        Optional<Id<Info>> infoId = this.getInfoId(message);
        if (infoId.isEmpty()) {
            return;
        }
        ObvUpdateBuilder<AbstractMessageEphemeralInfoGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractMessageEphemeralInfoGenerated.GEN_ID, infoId.get());
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.READ_ONCE, false);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("clearReadOnceInfo: cannot perform operation", e);
        }
    }

    public void deleteInfoIfIrrelevant(Message message) {
        Optional<Id<Info>> ephemeralInfoId = this.getInfoId(message);
        if (ephemeralInfoId.isEmpty()) {
            return;
        }
        ObvDeleteBuilder deleteBuilder = this.deleteBuilder();
        this.checkThread();
        try {
            deleteBuilder.where().eq(AbstractMessageEphemeralInfoGenerated.GEN_ID, ephemeralInfoId.get()).and().eq(AbstractMessageEphemeralInfoGenerated.READ_ONCE, false).and().isNull(AbstractMessageEphemeralInfoGenerated.VISIBILITY_TIMESTAMP);
            deleteBuilder.delete();
        }
        catch (SQLException e) {
            AppLogger.e("deleteInfoIfIrrelevant: cannot perform operation", e);
        }
    }

    public void update(Id<Info> id, boolean readOnce, Long visibilityDuration, Long existenceDuration) {
        ObvUpdateBuilder<AbstractMessageEphemeralInfoGenerated<?>> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(AbstractMessageEphemeralInfoGenerated.GEN_ID, id);
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.READ_ONCE, readOnce);
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.VISIBILITY_DURATION, visibilityDuration);
            updateBuilder.updateColumnValue(AbstractMessageEphemeralInfoGenerated.EXISTENCE_DURATION, existenceDuration);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("AbstractMessageEphemeralInfoDao.update: unable to update", e);
        }
    }
}

