/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.common;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DatabaseResultsMapper;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidBaseDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class OlvidAbstractDao<T> {
    protected final OlvidBaseDao<T, Long> dao;
    public final AppLogger logger;

    protected OlvidAbstractDao(ConnectionSource singleConnectionSource, Class<T> tableTypeClass) throws SQLException {
        this.dao = new OlvidBaseDao(singleConnectionSource, tableTypeClass);
        this.logger = new AppLogger(this.getClass());
    }

    public Class<T> getDataClass() {
        return this.dao.getDataClass();
    }

    public ObvQueryBuilder<T> queryBuilder() {
        return new ObvQueryBuilder(this.dao.queryBuilder());
    }

    public ObvUpdateBuilder<T> updateBuilder() {
        return new ObvUpdateBuilder(this.dao.updateBuilder());
    }

    public ObvDeleteBuilder<T> deleteBuilder() {
        return new ObvDeleteBuilder(this.dao.deleteBuilder());
    }

    public <CT> CT callBatchTasks(Callable<CT> callable) throws SQLException {
        return (CT)this.dao.callBatchTasks(callable);
    }

    public T createIfNotExists(T entity) {
        return this.dao.createIfNotExists(entity);
    }

    public int create(T data) throws SQLException {
        return this.dao.create(data);
    }

    public int create(Collection<T> datas) throws SQLException {
        return this.dao.create(datas);
    }

    public T queryForFirst(PreparedQuery<T> preparedQuery) throws SQLException {
        return (T)this.dao.queryForFirst(preparedQuery);
    }

    @SafeVarargs
    public final void insert(T ... instancesToInsert) {
        this.checkThread();
        try {
            this.insertOrThrow(instancesToInsert);
        }
        catch (SQLException throwables) {
            AppLogger.e("Failed insert...", throwables);
        }
    }

    public final int refresh(T data) throws SQLException {
        return this.dao.refresh(data);
    }

    @SafeVarargs
    public final void insertOrThrow(T ... instancesToInsert) throws SQLException {
        this.checkThread();
        List<T> instancesToAdd = Arrays.asList(instancesToInsert);
        int ret = this.dao.create(instancesToAdd);
        if (ret != instancesToInsert.length) {
            throw new SQLException("Uncomplete insert : " + ret + "/" + instancesToInsert.length);
        }
    }

    public int update(T instancesToInsert) {
        this.checkThread();
        return this.dao.update(instancesToInsert);
    }

    public int updateOrThrow(T instancesToInsert) throws SQLException {
        this.checkThread();
        return this.dao.updateOrThrow(instancesToInsert);
    }

    public int upsert(T instancesToInsert) {
        this.checkThread();
        return this.dao.upsert(instancesToInsert);
    }

    public void customDelete(List<T> instancesToDelete) {
        this.checkThread();
        this.dao.customDelete(instancesToDelete);
    }

    public void customDelete(T instanceToDelete) {
        this.checkThread();
        this.dao.customDelete(instanceToDelete);
    }

    public int delete(T data) throws SQLException {
        this.checkThread();
        return this.dao.delete(data);
    }

    public int delete(Collection<T> datas) throws SQLException {
        this.checkThread();
        return this.dao.delete(datas);
    }

    public void customDeleteById(Id<T> id) {
        this.checkThread();
        this.dao.customDeleteById(id.getId());
    }

    public int deleteById(Id<T> id) throws SQLException {
        this.checkThread();
        return this.dao.deleteById(id.getId());
    }

    public int update(String idColumnName, Id<T> id, Map<String, Object> keyAndValuesToUpdate) {
        this.checkThread();
        return this.dao.update(idColumnName, id.getId(), keyAndValuesToUpdate);
    }

    public List<T> getAll() {
        this.checkThread();
        return this.dao.getAll();
    }

    public long countOf() throws SQLException {
        this.checkThread();
        return this.dao.countOf();
    }

    public int deleteIds(Collection<Id<T>> ids) throws SQLException {
        return this.dao.deleteIds(ids.stream().map(Id::getId).toList());
    }

    public boolean registerObserverWithRet(Dao.DaoObserver observer) {
        return this.dao.registerObserverWithRet(observer);
    }

    public void registerObserver(Dao.DaoObserver observer) {
        this.dao.registerObserver(observer);
    }

    public void unregisterObserver(Dao.DaoObserver observer) {
        this.dao.unregisterObserver(observer);
    }

    public void notifyChanges() {
        this.dao.notifyChanges();
    }

    public <UO> UO queryRaw(String query, DatabaseResultsMapper<UO> mapper, List<Pair<FieldType, Object>> arguments, Long limit, boolean cacheStore) {
        return this.dao.queryRaw(query, mapper, arguments, limit, cacheStore);
    }

    public <UO> GenericRawResults<UO> queryRaw(String query, DatabaseResultsMapper<UO> mapper) throws SQLException {
        return this.dao.queryRaw(query, mapper, new String[0]);
    }

    protected void checkThread() {
        this.dao.checkThread();
    }

    public int executeRaw(String statement, String ... arguments) throws SQLException {
        return this.dao.executeRaw(statement, arguments);
    }

    public <Ref> boolean hasReference(Column.ForeignColumn<T, Ref> column, Ref ref) {
        this.checkThread();
        ObvQueryBuilder<T> queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(column, ref);
            return queryBuilder.queryForFirst() != null;
        }
        catch (SQLException e) {
            AppLogger.e("hasReference: Unable to update", e);
            return false;
        }
    }
}

