/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.attachment;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public abstract class ReceivedAttachmentDao<Message extends ReceivedMessageGenerated<Message>, Attachment extends ReceivedAttachmentGenerated<Attachment>>
extends AbstractAttachmentDao<Message, Attachment> {
    protected ReceivedAttachmentDao(ConnectionSource singleConnectionSource, Class<Attachment> clazz) throws SQLException {
        super(singleConnectionSource, clazz);
    }

    @Override
    public abstract Column.ForeignColumn<Attachment, Message> getMessageColumn();

    public void updateAttachmentStatus(Attachment attachment, ReceivedAttachmentGenerated.Status status) {
        this.checkThread();
        ObvUpdateBuilder<ReceivedAttachmentGenerated<?>> updateBuilder = this.updateBuilder();
        if (attachment == null) {
            this.logger.error("Invalid parameters: updateAttachmentStatus");
            return;
        }
        try {
            updateBuilder.where().eq(ReceivedAttachmentGenerated.FK_OWNED_IDENTITY, ((AbstractAttachmentGenerated)attachment).getOwnedIdentityId()).and().eq(ReceivedAttachmentGenerated.GEN_ID, ((AbstractTableGenerated)attachment).getItemId()).and().eq(ReceivedAttachmentGenerated.ENGINE_MESSAGE_IDENTIFIER, ((ReceivedAttachmentGenerated)attachment).getEngineMessageIdentifier()).and().eq(ReceivedAttachmentGenerated.IDX, ((AbstractAttachmentGenerated)attachment).getIdx());
            updateBuilder.updateColumnValue(ReceivedAttachmentGenerated.STATUS, status);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateAttachmentStatus: Unable to update", throwables);
        }
    }

    public void updateAttachmentThumbnailComputationParams(Id<Attachment> attachmentId, String thumbnailPath, boolean thumbnailComputationFailed) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(ReceivedAttachmentGenerated.GEN_ID, attachmentId);
            updateBuilder.updateColumnValue(ReceivedAttachmentGenerated.THUMBNAIL_PATH, thumbnailPath);
            updateBuilder.updateColumnValue(ReceivedAttachmentGenerated.THUMBNAIL_COMPUTATION_FAILED, thumbnailComputationFailed);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateAttachmentThumbnailComputationParams: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateAttachmentThumbnailComputationParams: Unable to update");
        }
    }

    public void updateAttachmentThumbnailComputationFailed(Id<Attachment> attachmentId, boolean thumbnailComputationFailed) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(ReceivedAttachmentGenerated.GEN_ID, attachmentId);
            updateBuilder.updateColumnValue(ReceivedAttachmentGenerated.THUMBNAIL_COMPUTATION_FAILED, thumbnailComputationFailed);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateAttachmentThumbnailComputationFailed: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateAttachmentThumbnailComputationFailed: Unable to update");
        }
    }

    public boolean updateAttachmentStatus(Id<Attachment> attachmentId, ReceivedAttachmentGenerated.Status status) {
        ObvUpdateBuilder<ReceivedAttachmentGenerated<?>> updateBuilder = this.updateBuilder();
        try {
            updateBuilder.where().eq(ReceivedAttachmentGenerated.GEN_ID, attachmentId);
            updateBuilder.updateColumnValue(ReceivedAttachmentGenerated.STATUS, status);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateAttachmentStatus: Unable to update");
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            AppLogger.e("updateAttachmentStatus: Unable to update");
            return false;
        }
    }

    public Attachment getByEngineIdentifierAndNumber(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        this.checkThread();
        ObvQueryBuilder attachmentQB = this.queryBuilder();
        ObvQueryBuilder ownedIdentityQB = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        if (bytesOwnedIdentity == null || messageIdentifier == null) {
            AppLogger.e("Invalid parameters: getByEngineIdentifierAndNumber");
            return null;
        }
        try {
            ownedIdentityQB.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            attachmentQB.where().eq(ReceivedAttachmentGenerated.ENGINE_MESSAGE_IDENTIFIER, messageIdentifier).and().eq(ReceivedAttachmentGenerated.IDX, attachmentNumber);
            attachmentQB.join(ReceivedAttachmentGenerated.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, ownedIdentityQB);
            return (Attachment)((ReceivedAttachmentGenerated)attachmentQB.queryForFirst());
        }
        catch (SQLException throwables) {
            AppLogger.e("getByEngineIdentifierAndNumber: Unable to query", throwables);
            return null;
        }
    }

    public List<Attachment> getMessageIdsForFyle(Fyle fyle) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (fyle == null) {
            AppLogger.e("Invalid parameters: getMessageIdsForFyle");
            return null;
        }
        try {
            queryBuilder.where().eq(ReceivedAttachmentGenerated.FK_FYLE, fyle);
            queryBuilder.selectColumns(this.getMessageColumn());
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getMessageIdsForFyle: Unable to query", throwables);
            return null;
        }
    }

    public List<Attachment> getForFyleId(Fyle fyle) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (fyle == null) {
            AppLogger.e("Invalid parameters: getForFyleId");
            return null;
        }
        try {
            queryBuilder.where().eq(ReceivedAttachmentGenerated.FK_FYLE, fyle);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getForFyleId: Unable to query", throwables);
            return null;
        }
    }

    public long countAttachmentsForThumbnail(String thumbnailPath) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(ReceivedAttachmentGenerated.THUMBNAIL_PATH, thumbnailPath);
            return queryBuilder.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("countAttachmentsForThumbnail: Unable to query", throwables);
            return -1L;
        }
    }

    public List<Attachment> getAttachmentsForMessages(List<Message> messages) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (messages == null || messages.isEmpty()) {
            AppLogger.e("Invalid parameters: getAttachmentsForMessages");
            return null;
        }
        try {
            queryBuilder.where().in(this.getMessageColumn(), messages.stream().map(AbstractTableGenerated::getItemId).toList());
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAttachmentsForMessages: Unable to query", throwables);
            return null;
        }
    }

    public void setAttachmentCompleted(Attachment attachment) {
        this.updateAttachmentStatus(attachment, ReceivedAttachmentGenerated.Status.COMPLETE);
    }
}

