/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.attachment;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AttachmentRecipientInfoDao
extends OlvidDao<AttachmentRecipientInfo> {
    public AttachmentRecipientInfoDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, AttachmentRecipientInfo.class);
    }

    public long getCountFromMessageRecipientInfo(MessageRecipientInfo messageRecipientInfo) {
        this.checkThread();
        if (messageRecipientInfo == null) {
            AppLogger.e("Invalid parameters: getAttachmentRecipientInfoAssociatedToMessageRecipientInfo");
            return 0L;
        }
        try {
            ObvQueryBuilder AttachmentRecipientInfoQB = this.queryBuilder();
            AttachmentRecipientInfoQB.where().eq(AttachmentRecipientInfo.FK_MESSAGE_RECIPIENT_INFO, messageRecipientInfo.getItemId());
            return AttachmentRecipientInfoQB.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDraftByHashAndDiscussion: Unable to query", throwables);
            return 0L;
        }
    }

    public AttachmentRecipientInfo getFromMessageRecipientInfo(MessageRecipientInfo messageRecipientInfo, int index) {
        this.checkThread();
        if (messageRecipientInfo == null) {
            AppLogger.e("Invalid parameters: getAttachmentRecipientInfoAssociatedToMessageRecipientInfo");
            return null;
        }
        try {
            ObvQueryBuilder attachmentRecipientInfoQB = this.queryBuilder();
            ObvQueryBuilder outboundAttachmentQB = DbManager.getInstance().getOutboundAttachmentDao().queryBuilder();
            outboundAttachmentQB.where().eq(OutboundAttachment.FK_MESSAGE, messageRecipientInfo.getMessageId()).and().eq(OutboundAttachment.IDX, index);
            attachmentRecipientInfoQB.join(AttachmentRecipientInfo.FK_ATTACHMENT, OutboundAttachment.GEN_ID, outboundAttachmentQB);
            attachmentRecipientInfoQB.where().eq(AttachmentRecipientInfo.FK_MESSAGE_RECIPIENT_INFO, messageRecipientInfo.getItemId());
            return (AttachmentRecipientInfo)attachmentRecipientInfoQB.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("getFromMessageRecipientInfo: Unable to query", throwables);
            return null;
        }
    }

    public int updateRecipientInfoForCancelledAttachment(Collection<Id<AttachmentRecipientInfo>> attachmentRecipientInfoIds, long timestampCancelled) {
        this.checkThread();
        try {
            ObvUpdateBuilder attachmentRecipientInfoUB = this.updateBuilder();
            attachmentRecipientInfoUB.updateColumnValue(AttachmentRecipientInfo.TIMESTAMP_CANCELLED, Long.valueOf(timestampCancelled)).where().in(AttachmentRecipientInfo.GEN_ID, attachmentRecipientInfoIds);
            return attachmentRecipientInfoUB.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateRecipientInfoForAttachment: Unable to query", throwables);
            return 0;
        }
    }

    public List<AttachmentRecipientInfo> getFromIndexAndMessageIdentifier(byte[] ownedIdentityBytes, byte[] engineMessageIdentifier, int index) {
        this.checkThread();
        try {
            ObvQueryBuilder attachmentRecipientInfoQB = this.queryBuilder();
            ObvQueryBuilder outboundAttachmentQB = DbManager.getInstance().getOutboundAttachmentDao().queryBuilder();
            ObvQueryBuilder ownedIdentityQB = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
            ownedIdentityQB.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, ownedIdentityBytes);
            outboundAttachmentQB.where().eq(OutboundAttachment.IDX, index);
            outboundAttachmentQB.join(OutboundAttachment.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, ownedIdentityQB);
            attachmentRecipientInfoQB.where().eq(AttachmentRecipientInfo.ENGINE_MESSAGE_IDENTIFIER, engineMessageIdentifier);
            attachmentRecipientInfoQB.join(AttachmentRecipientInfo.FK_ATTACHMENT, OutboundAttachment.GEN_ID, outboundAttachmentQB);
            return attachmentRecipientInfoQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDraftByHashAndDiscussion: Unable to query", throwables);
            return null;
        }
    }

    public List<AttachmentRecipientInfo> getAllForAttachment(Id<OutboundAttachment> attachmentGenId) {
        this.checkThread();
        try {
            ObvQueryBuilder attachmentRecipientInfoQB = this.queryBuilder();
            attachmentRecipientInfoQB.where().eq(AttachmentRecipientInfo.FK_ATTACHMENT, attachmentGenId);
            return attachmentRecipientInfoQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDraftByHashAndDiscussion: Unable to query", throwables);
            return Collections.emptyList();
        }
    }

    public List<AttachmentRecipientInfo> getDistinctEngineMessageIdentifierForAttachment(Id<OutboundAttachment> attachmentGenId) {
        this.checkThread();
        try {
            ObvQueryBuilder attachmentRecipientInfoQB = this.queryBuilder();
            attachmentRecipientInfoQB.distinct().selectColumns(AttachmentRecipientInfo.ENGINE_MESSAGE_IDENTIFIER).where().eq(AttachmentRecipientInfo.FK_ATTACHMENT, attachmentGenId);
            return attachmentRecipientInfoQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDistinctEngineMessageIdentifierForAttachment: Unable to query", throwables);
            return Collections.emptyList();
        }
    }
}

