/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao.attachment;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.dao.interfaces.DaoWithForeignMessage;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.AttachmentInfos;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractAttachmentDao<Message extends AbstractUserMessageGenerated<Message>, Attachment extends AbstractAttachmentGenerated<Attachment>>
extends OlvidDao<Attachment>
implements DaoWithForeignMessage<Message> {
    private static final List<String> ALL_FIELDS;
    private static final Set<String> INBOUND_ATTACHMENT_FIELDS;
    private static final Set<String> OUTBOUND_ATTACHMENT_FIELDS;
    private static final Set<String> OWNED_ATTACHMENT_FIELDS;
    public static final String ALIAS_PREFIX = "att_";
    public static final String ALIAS_IS_ATTACHMENT = "is_attachment";

    protected AbstractAttachmentDao(ConnectionSource singleConnectionSource, Class<Attachment> attachmentClass) throws SQLException {
        super(singleConnectionSource, attachmentClass);
    }

    public List<Attachment> getDiscussionAttachments(Discussion discussion) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        if (discussion == null) {
            AppLogger.e("Invalid parameters: getAttachmentsForDiscussionWithoutDrafts");
            return Collections.emptyList();
        }
        try {
            queryBuilder.where().eq(AbstractAttachmentGenerated.FK_DISCUSSION, discussion);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAttachmentsForDiscussionWithoutDrafts: Unable to query", throwables);
            return Collections.emptyList();
        }
    }

    public List<Attachment> getAttachmentsForMessage(Id<Message> message) {
        this.checkThread();
        ObvQueryBuilder<AbstractAttachmentGenerated<?>> attachmentQB = this.queryBuilder();
        if (message == null) {
            AppLogger.e("Invalid parameters: getAttachmentsForMessage");
            return Collections.emptyList();
        }
        try {
            attachmentQB.where().eq(this.getMessageColumn(), message);
            attachmentQB.orderBy(AbstractAttachmentGenerated.IDX, true);
            return attachmentQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAttachmentsForMessage: Unable to query", throwables);
            return Collections.emptyList();
        }
    }

    public List<Attachment> getAttachmentsForDiscussion(Id<Discussion> discussionID, double sortIndexMin, boolean excludeMin, double sortIndexMax, boolean excludeMax) throws SQLException {
        ObvQueryBuilder messagesQB = this.messageQueryBuilder(discussionID, sortIndexMin, excludeMin, sortIndexMax, excludeMax);
        messagesQB.where().and().ne(AbstractUserMessageGenerated.TOTAL_ATTACHMENT_COUNT, 0);
        ObvQueryBuilder<Attachment> queryBuilder = this.queryBuilder();
        queryBuilder.join(this.getMessageColumn(), AbstractUserMessageGenerated.GEN_ID, messagesQB);
        return queryBuilder.query();
    }

    public List<Attachment> getAttachmentsForOwnedIdentity(OwnedIdentity ownedIdentity) throws SQLException {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        Objects.requireNonNull(ownedIdentity);
        queryBuilder.where().eq(AbstractAttachmentGenerated.FK_OWNED_IDENTITY, ownedIdentity);
        return queryBuilder.query();
    }

    public abstract Id<Message> getMessageId(Attachment var1);

    public abstract Column.ForeignColumn<Attachment, Message> getMessageColumn();

    private void select(StringBuilder builder, Id<Discussion> discussionId, String selectKind, String tableName, String joinTableName, Set<String> currentFields) {
        String prefix = ALIAS_PREFIX;
        builder.append("SELECT ").append(selectKind).append(" AS ").append(ALIAS_IS_ATTACHMENT).append(",").append(System.lineSeparator());
        Iterator<String> fieldIterator = ALL_FIELDS.iterator();
        while (fieldIterator.hasNext()) {
            String field = fieldIterator.next();
            if (currentFields.contains(field)) {
                builder.append(tableName).append(".").append(field).append(" AS ").append(ALIAS_PREFIX).append(field);
            } else {
                builder.append("NULL AS ").append(ALIAS_PREFIX).append(field);
            }
            if (fieldIterator.hasNext()) {
                builder.append(",");
            }
            builder.append(System.lineSeparator());
        }
        builder.append(",");
        builder.append(joinTableName).append(".").append(InboundMessage.SORT_INDEX);
        builder.append(System.lineSeparator());
        builder.append("FROM ").append(tableName).append(System.lineSeparator());
        builder.append(" JOIN ").append(joinTableName).append(" ON ").append(InboundAttachment.FK_MESSAGE).append("=").append(joinTableName).append(".").append(AbstractUserMessageGenerated.GEN_ID);
        builder.append(" WHERE ").append(tableName).append(".").append(AbstractMessageGenerated.FK_DISCUSSION).append(" = ").append(discussionId.getId()).append(System.lineSeparator());
        if (Objects.equals(tableName, "outbound_attachment_table")) {
            builder.append(" AND ").append(tableName).append(".").append(OutboundAttachment.STATUS).append(" != ").append("\"").append(OutboundAttachmentGenerated.Status.COPYING.name()).append("\"").append(System.lineSeparator());
        }
    }

    public List<AttachmentInfos> getDiscussionAllAttachments(Id<Discussion> discussionId) {
        List list;
        block9: {
            StringBuilder builder = new StringBuilder();
            this.select(builder, discussionId, "1", "inbound_attachment_table", "inbound_message_table", INBOUND_ATTACHMENT_FIELDS);
            builder.append(System.lineSeparator());
            builder.append("UNION").append(System.lineSeparator());
            this.select(builder, discussionId, "0", "outbound_attachment_table", "outbound_message_table", OUTBOUND_ATTACHMENT_FIELDS);
            builder.append("UNION").append(System.lineSeparator());
            this.select(builder, discussionId, "2", "owned_attachment_table", "owned_message_table", OWNED_ATTACHMENT_FIELDS);
            builder.append("ORDER BY ").append("outbound_message_table").append(".").append(AbstractMessageGenerated.SORT_INDEX).append(" ASC;");
            String query = builder.toString();
            GenericRawResults items = this.queryRaw(query, result -> AttachmentInfos.mapRow(result, ALIAS_PREFIX));
            try {
                list = items.getResults();
                if (items == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (items != null) {
                        try {
                            items.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    AppLogger.e("getDiscussionAllAttachments: Unable to query", e);
                    return Collections.emptyList();
                }
                catch (Exception e) {
                    AppLogger.e("getDiscussionAllAttachments: General exception", e);
                    return Collections.emptyList();
                }
            }
            items.close();
        }
        return list;
    }

    public long countAttachmentsForFyle(Id<Fyle> fyle_id) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(AbstractAttachmentGenerated.FK_FYLE, fyle_id);
            return queryBuilder.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("countMessageForFyle: Unable to query", throwables);
            return -1L;
        }
    }

    static {
        LinkedHashSet fields = new LinkedHashSet();
        fields.addAll(InboundAttachment.ALL_FIELDS);
        fields.addAll(OutboundAttachment.ALL_FIELDS);
        fields.addAll(OwnedAttachment.ALL_FIELDS);
        ALL_FIELDS = List.copyOf(fields);
        INBOUND_ATTACHMENT_FIELDS = Set.copyOf(InboundAttachment.ALL_FIELDS);
        OUTBOUND_ATTACHMENT_FIELDS = Set.copyOf(OutboundAttachment.ALL_FIELDS);
        OWNED_ATTACHMENT_FIELDS = Set.copyOf(OwnedAttachment.ALL_FIELDS);
    }
}

