/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public class OwnedIdentityDao
extends OlvidDao<OwnedIdentity> {
    public OwnedIdentityDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, OwnedIdentity.class);
    }

    public void customRefresh(OwnedIdentity ownedIdentity) {
        try {
            this.refresh(ownedIdentity);
        }
        catch (SQLException throwables) {
            AppLogger.e("OwnedIdentity: unable to refresh", throwables);
        }
    }

    public void updateApiKey(byte[] bytesOwnedIdentity, OwnedIdentityGenerated.ApiKeyStatus apiKeyStatus, EnumSet<OwnedIdentity.ApiKeyPermission> apiKeyPermissions, Optional<Long> apiKeyExpirationTimestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        if (bytesOwnedIdentity == null) {
            this.logger.error("Invalid parameters: updateApiKey");
        }
        try {
            updateBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            updateBuilder.updateColumnValue(OwnedIdentity.API_KEY_STATUS, apiKeyStatus);
            updateBuilder.updateColumnValue(OwnedIdentity.API_KEY_PERMISSIONS, OwnedIdentity.ApiKeyPermission.of(apiKeyPermissions));
            updateBuilder.updateColumnValue(OwnedIdentity.API_KEY_EXPIRATION_TIMESTAMP, apiKeyExpirationTimestamp.orElse(null));
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateApiKey: Unable to update", throwables);
        }
    }

    public void updateKeycloakManaged(byte[] bytesOwnedIdentity, boolean isKeycloakManaged) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        if (bytesOwnedIdentity == null) {
            this.logger.error("Invalid parameters: updateKeycloakManaged");
        }
        try {
            updateBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            updateBuilder.updateColumnValue(OwnedIdentity.KEYCLOAK_MANAGED, isKeycloakManaged);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateKeycloakManaged: Unable to update", throwables);
        }
    }

    public void updateKeycloakManagedAndNickname(byte[] bytesOwnedIdentity, boolean isKeycloakManaged, String nickname) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        if (bytesOwnedIdentity == null) {
            this.logger.error("Invalid parameters: updateKeycloakManagedAndNickname");
        }
        try {
            updateBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            updateBuilder.updateColumnValue(OwnedIdentity.KEYCLOAK_MANAGED, isKeycloakManaged);
            updateBuilder.updateColumnValue(OwnedIdentity.NICKNAME, nickname);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateKeycloakManagedAndNickname: Unable to update", throwables);
        }
    }

    public void updateActive(OwnedIdentity ownedIdentity, boolean active) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        if (ownedIdentity == null) {
            this.logger.error("Invalid parameters: updateActive");
            return;
        }
        try {
            updateBuilder.where().eq(OwnedIdentity.GEN_ID, ownedIdentity.getItemId());
            updateBuilder.updateColumnValue(OwnedIdentity.ACTIVE, active);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateActive: Unable to update", throwables);
        }
    }

    public void updateNickname(Id<OwnedIdentity> ownedIdentityId, Optional<String> nickname) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(OwnedIdentity.GEN_ID, ownedIdentityId);
            updateBuilder.updateColumnValue(OwnedIdentity.NICKNAME, nickname.orElse(null));
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateActive: Unable to update", throwables);
        }
    }

    public OwnedIdentity get(byte[] bytesOwnedIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (bytesOwnedIdentity == null) {
            this.logger.error("Invalid parameters: get(byte[] fkaOwnedIdentity)");
        }
        try {
            queryBuilder.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            return (OwnedIdentity)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("get(byte[] fkaOwnedIdentity): Unable to query", throwables);
            return null;
        }
    }

    public List<OwnedIdentity> getManagedOwnedIdentities() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().eq(OwnedIdentity.KEYCLOAK_MANAGED, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getManagedOwnedIdentities: Unable to query", throwables);
            return null;
        }
    }

    public List<OwnedIdentity> getAllSortedByIndex() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.orderBy(OwnedIdentity.GEN_ID, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllSortedByIndex: Unable to query", throwables);
            return null;
        }
    }

    public List<OwnedIdentity> getAllSortedByIndexWithoutThisIdentity(Id<OwnedIdentity> ownedIdentityId) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().not().idEq(ownedIdentityId.getId());
            queryBuilder.orderBy(OwnedIdentity.GEN_ID, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllSortedByIndex: Unable to query", throwables);
            return null;
        }
    }

    public OwnedIdentity getDefaultCurrentIdentity(byte[] lastSelectedIdentity) {
        OwnedIdentity ownedIdentity;
        if (lastSelectedIdentity != null && lastSelectedIdentity.length > 0 && (ownedIdentity = this.get(lastSelectedIdentity)) != null) {
            return ownedIdentity;
        }
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.orderBy(OwnedIdentity.GEN_ID, true);
            return (OwnedIdentity)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("getDefaultCurrentIdentity: Unable to query", throwables);
            return null;
        }
    }
}

