/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.gen.LocationGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public class LocationDao
extends OlvidDao<Location> {
    public LocationDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Location.class);
    }

    public void updateLocationType(Id<Location> locationId, LocationGenerated.Type locationType) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(Location.GEN_ID, locationId);
            updateBuilder.updateColumnValue(Location.TYPE, locationType);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("LocationDao.updateLocationType: unable to update", throwables);
        }
    }

    public void updateLocation(Id<Location> locationId, JsonLocation jsonLocation) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(Location.GEN_ID, locationId);
            Optional<LocationGenerated.Type> typeOpt = Location.typeFromId(jsonLocation.getType());
            if (typeOpt.isEmpty()) {
                AppLogger.e("LocationDao.updateLocation: unknown Location.Type id to update:" + jsonLocation.getType());
                return;
            }
            updateBuilder.updateColumnValue(Location.TYPE, Location.typeFromId(jsonLocation.getType()).orElse(null));
            updateBuilder.updateColumnValue(Location.TIMESTAMP, jsonLocation.getTimestamp());
            updateBuilder.updateColumnValue(Location.COUNT, jsonLocation.getCount());
            updateBuilder.updateColumnValue(Location.SHARING_INTERVAL, jsonLocation.getSharingInterval());
            updateBuilder.updateColumnValue(Location.SHARING_EXPIRATION, jsonLocation.getSharingExpiration());
            updateBuilder.updateColumnValue(Location.LATITUDE, jsonLocation.getLatitude());
            updateBuilder.updateColumnValue(Location.LONGITUDE, jsonLocation.getLongitude());
            updateBuilder.updateColumnValue(Location.ALTITUDE, jsonLocation.getAltitude());
            updateBuilder.updateColumnValue(Location.PRECISION, jsonLocation.getPrecision());
            updateBuilder.updateColumnValue(Location.ADDRESS, jsonLocation.getAddress());
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("LocationDao.updateLocation: unable to update", throwables);
        }
    }
}

