/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class InvitationsDao
extends OlvidDao<Invitation> {
    public InvitationsDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Invitation.class);
    }

    public List<Invitation> getAllSortedByIndex() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.orderBy(Invitation.GEN_ID, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllSortedByIndex: Unable to query", throwables);
            return null;
        }
    }

    public ArrayList<Invitation> getInvitationsByIdentity(Id<OwnedIdentity> ownedIdentityId) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().eq(Invitation.FK_OWNED_IDENTITY, ownedIdentityId);
            queryBuilder.orderBy(Invitation.TIMESTAMP, false);
            return new ArrayList<Invitation>(queryBuilder.query());
        }
        catch (SQLException throwables) {
            AppLogger.e("getInvitationsByIdentity: Unable to query: " + String.valueOf(ownedIdentityId), throwables);
            return null;
        }
    }

    public Invitation getInvitationByDialogUUID(UUID dialogUUID) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(Invitation.DIALOG_UUID, dialogUUID);
            return (Invitation)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("getInvitationByDialogUUID: exception" + dialogUUID.toString(), throwables);
            return null;
        }
    }

    public List<Invitation> getSortedInvitationForDiscussion(Id<Discussion> discussionId) {
        this.checkThread();
        try {
            ObvQueryBuilder queryBuilder = this.queryBuilder();
            queryBuilder.where().eq(Invitation.FK_DISCUSSION, discussionId);
            queryBuilder.orderBy(Invitation.TIMESTAMP, false);
            return queryBuilder.query();
        }
        catch (SQLException e) {
            AppLogger.e("getSortedInvitationForDiscussion: exception", e);
            return List.of();
        }
    }

    public long getInvitationCountForDiscussion(Discussion discussion) {
        this.checkThread();
        try {
            ObvQueryBuilder queryBuilder = this.queryBuilder();
            queryBuilder.where().eq(Invitation.FK_DISCUSSION, discussion);
            queryBuilder.orderBy(Invitation.TIMESTAMP, false);
            return queryBuilder.countOf();
        }
        catch (SQLException e) {
            AppLogger.e("getInvitationCountForDiscussion: exception", e);
            return 0L;
        }
    }

    public int updateStateDataTimestampAndSas(Id<Invitation> genId, InvitationGenerated.State newState, byte[] newEncodedData, long newTimestamp, byte[] newSasToDisplay) throws SQLException {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        updateBuilder.updateColumnValue(Invitation.STATE, newState).updateColumnValue(Invitation.ENCODED_DATA, newEncodedData).updateColumnValue(Invitation.TIMESTAMP, newTimestamp).updateColumnValue(Invitation.SAS_TO_DISPLAY, newSasToDisplay);
        updateBuilder.where().eq(Invitation.GEN_ID, genId);
        return updateBuilder.update();
    }
}

