/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentityRefDao
extends OlvidDao<IdentityRef> {
    public IdentityRefDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, IdentityRef.class);
    }

    private IdentityRef getFromOwnedIdentity(Id<OwnedIdentity> ownedIdentity) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(IdentityRef.FK_OWNED_IDENTITY, ownedIdentity).and().isNull(IdentityRef.FK_CONTACT_REF);
            return (IdentityRef)queryBuilder.queryForFirst();
        }
        catch (SQLException e) {
            AppLogger.e("get(OwnedIdentity)", e);
            return null;
        }
    }

    private IdentityRef getFromContactRef(ContactRef contactRef) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(IdentityRef.FK_CONTACT_REF, contactRef).and().isNull(IdentityRef.FK_OWNED_IDENTITY);
            return (IdentityRef)queryBuilder.queryForFirst();
        }
        catch (SQLException e) {
            AppLogger.e("get(ContactRef)", e);
            return null;
        }
    }

    public synchronized IdentityRef getOrCreateOwnedIdentityRef(Id<OwnedIdentity> ownedIdentity) {
        IdentityRef ref = this.getFromOwnedIdentity(ownedIdentity);
        if (ref == null) {
            ref = IdentityRef.make(new OwnedIdentity(ownedIdentity.getId()));
            ref = this.createIfNotExists(ref);
        }
        return ref;
    }

    public synchronized IdentityRef getOrCreateContactRef(ContactRef contactRef) {
        IdentityRef ref = this.getFromContactRef(contactRef);
        if (ref == null && (contactRef = DbManager.getInstance().getContactRefDao().createIfNotExists(contactRef)) != null) {
            ref = IdentityRef.make(contactRef);
            ref = this.createIfNotExists(ref);
        }
        return ref;
    }

    public Set<Id<IdentityRef>> getAllOwnedIdentityRefs() {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().isNotNull(IdentityRef.FK_OWNED_IDENTITY);
            queryBuilder.selectColumns(IdentityRef.GEN_ID);
            queryBuilder.distinct();
            return queryBuilder.query().stream().map(AbstractTableGenerated::getItemId).collect(Collectors.toSet());
        }
        catch (SQLException e) {
            AppLogger.e("getAllOwnedIdentityRefs", e);
            return Set.of();
        }
    }
}

