/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;

public class IdentityDetailsDao
extends OlvidDao<IdentityDetails> {
    public IdentityDetailsDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, IdentityDetails.class);
    }

    public List<IdentityDetails> getAllIdentityDetails() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllIdentityDetails", throwables);
            return null;
        }
    }

    public boolean updateDetails(Id<IdentityDetails> identityDetailsId, JsonIdentityDetails jsonIdentityDetails) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(IdentityDetails.GEN_ID, identityDetailsId);
            updateBuilder.updateColumnValue(IdentityDetails.FIRST_NAME, jsonIdentityDetails.getFirstName());
            updateBuilder.updateColumnValue(IdentityDetails.LAST_NAME, jsonIdentityDetails.getLastName());
            updateBuilder.updateColumnValue(IdentityDetails.COMPANY, jsonIdentityDetails.getCompany());
            updateBuilder.updateColumnValue(IdentityDetails.POSITION, jsonIdentityDetails.getPosition());
            return updateBuilder.update() == 1;
        }
        catch (SQLException throwables) {
            AppLogger.e("updateDetails: Unable to update", throwables);
            return false;
        }
    }

    public void updateDetailsAndPhoto(Id<IdentityDetails> identityDetailsId, JsonIdentityDetails jsonIdentityDetails, String photoUrl) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(IdentityDetails.GEN_ID, identityDetailsId);
            updateBuilder.updateColumnValue(IdentityDetails.FIRST_NAME, jsonIdentityDetails.getFirstName());
            updateBuilder.updateColumnValue(IdentityDetails.LAST_NAME, jsonIdentityDetails.getLastName());
            updateBuilder.updateColumnValue(IdentityDetails.COMPANY, jsonIdentityDetails.getCompany());
            updateBuilder.updateColumnValue(IdentityDetails.POSITION, jsonIdentityDetails.getPosition());
            updateBuilder.updateColumnValue(IdentityDetails.PHOTO_URL, photoUrl);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateDetailsAndPhoto: Unable to update", throwables);
        }
    }
}

