/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.DiscussionCustomizationGenerated;
import java.sql.SQLException;
import java.util.Optional;

public class DiscussionCustomizationDao
extends OlvidDao<DiscussionCustomization> {
    public DiscussionCustomizationDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, DiscussionCustomization.class);
    }

    public DiscussionCustomization getDiscussionCustomization(Id<Discussion> discussionId) {
        ObvQueryBuilder discussionCustomizationQB = this.queryBuilder();
        this.checkThread();
        try {
            discussionCustomizationQB.where().eq(DiscussionCustomization.FK_DISCUSSION, discussionId);
            return (DiscussionCustomization)discussionCustomizationQB.queryForFirst();
        }
        catch (SQLException sqlException) {
            this.logger.error("DiscussionCustomizationDao: getDiscussionCustomization: error in request " + String.valueOf(discussionId), sqlException);
            return null;
        }
    }

    public void updateSendReadReceipt(Id<DiscussionCustomization> id, Boolean sendReadReceipt) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(DiscussionCustomization.GEN_ID, id);
            updateBuilder.updateColumnValue(DiscussionCustomization.PREF_SEND_READ_RECEIPT, sendReadReceipt);
            updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionCustomizationDao: updateSendReadReceipt error" + String.valueOf(e));
        }
    }

    public void updateMuteNotificationsTimestamp(Id<Discussion> id, Long timestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(DiscussionCustomization.FK_DISCUSSION, id);
            updateBuilder.updateColumnValue(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, timestamp);
            updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionCustomizationDao: updateMuteNotificationsTimestamp error" + String.valueOf(e));
        }
    }

    public int resetExpiredMuteNotificationsTimestamp(Long timestamp) {
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().isNotNull(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP).and().ne(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, Long.valueOf(-1L)).and().le(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, timestamp);
            updateBuilder.updateColumnValue(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, null);
            return updateBuilder.update();
        }
        catch (SQLException e) {
            this.logger.error("DiscussionCustomizationDao: resetExpiredMuteNotificationsTimestamp error" + String.valueOf(e));
            return 0;
        }
    }

    public Optional<Long> getNextUnmuteTimestamp() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            queryBuilder.where().isNotNull(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP).and().ge(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, (Long)0L);
            queryBuilder.selectColumns(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP);
            queryBuilder.orderBy(DiscussionCustomization.PREF_MUTE_NOTIFICATIONS_TIMESTAMP, true);
            queryBuilder.limit(1L);
            return Optional.ofNullable((DiscussionCustomization)queryBuilder.queryForFirst()).flatMap(DiscussionCustomizationGenerated::getPrefMuteNotificationsTimestamp);
        }
        catch (SQLException e) {
            this.logger.error("DiscussionCustomizationDao: getNextUnmuteTimestamp error" + String.valueOf(e));
            return Optional.empty();
        }
    }
}

