/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvDeleteBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.AbstractObvUpdateBuilder;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ContactRefDao
extends OlvidDao<ContactRef> {
    private static final String deleteErrorMessage = "Cannot delete ContactRef from dao, is must me delete from a cascade delete from " + OwnedIdentity.class.getSimpleName();

    public ContactRefDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, ContactRef.class);
    }

    private ContactRef get(Id<OwnedIdentity> ownedIdentityId, byte[] bytesContactIdentity) {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        try {
            queryBuilder.where().eq(ContactRef.FK_OWNED_IDENTITY, ownedIdentityId).and().eq(ContactRef.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            return (ContactRef)queryBuilder.queryForFirst();
        }
        catch (SQLException e) {
            AppLogger.e("get(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity)", e);
            return null;
        }
    }

    public boolean isContactRefExists(OwnedIdentity ownedIdentity, byte[] bytesContactIdentity) {
        return this.get((Id<OwnedIdentity>)ownedIdentity.getItemId(), bytesContactIdentity) != null;
    }

    public void updateContact(OwnedIdentity ownedIdentity, byte[] bytesContactIdentity, Contact contact) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            ((AbstractObvUpdateBuilder)updateBuilder).updateColumnValue(ContactRef.FK_CONTACT, contact.getItemId()).where().eq(ContactRef.FK_OWNED_IDENTITY, ownedIdentity).and().eq(ContactRef.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e("ContactRefDao: Unable to update contact", e);
        }
    }

    public synchronized ContactRef getOrCreateContactRef(OwnedIdentity ownedIdentity, byte[] bytesContactIdentity) {
        ContactRef ref;
        if (Arrays.equals(ownedIdentity.getBytesOwnedIdentity(), bytesContactIdentity)) {
            AppLogger.e("Try to create a ContactRef with ownedIdentity, this is a bug.");
        }
        if ((ref = this.get((Id<OwnedIdentity>)ownedIdentity.getItemId(), bytesContactIdentity)) == null) {
            Contact contact = DbManager.getInstance().getContactDao().get((Id<OwnedIdentity>)ownedIdentity.getItemId(), bytesContactIdentity);
            ref = new ContactRef(ownedIdentity, bytesContactIdentity, contact);
            this.insert(ref);
        }
        return ref;
    }

    public synchronized ContactRef getOrCreateContactRef(Contact contact) {
        ContactRef ref = this.get(contact.getOwnedIdentityId(), contact.getBytesContactIdentity());
        if (ref == null) {
            ref = new ContactRef(new OwnedIdentity(contact.getOwnedIdentityId().getId()), contact.getBytesContactIdentity(), contact);
            this.insert(ref);
        }
        return ref;
    }

    @Override
    @Deprecated
    public void customDelete(List<ContactRef> instancesToDelete) {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public int delete(ContactRef data) throws SQLException {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public int delete(Collection<ContactRef> datas) throws SQLException {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public void customDeleteById(Id<ContactRef> id) {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public int deleteById(Id<ContactRef> id) throws SQLException {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public int deleteIds(Collection<Id<ContactRef>> ids) throws SQLException {
        throw new IllegalStateException(deleteErrorMessage);
    }

    @Override
    @Deprecated
    public ObvDeleteBuilder<ContactRef> deleteBuilder() {
        throw new IllegalStateException(deleteErrorMessage);
    }
}

