/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ContactDao
extends OlvidDao<Contact> {
    public ContactDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, Contact.class);
    }

    public void updateContactCustomName(Id<Contact> contactId, Optional<String> customName) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Contact.CUSTOM_DISPLAY_NAME, customName.orElse(null)).where().eq(Contact.GEN_ID, contactId);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateContactCustomName: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateContactCustomName : Unable to update ", e);
        }
    }

    public void updateSortDisplayName(Id<Contact> contactId) {
        this.checkThread();
        Contact contact = this.get(contactId);
        Optional<String> customDisplayName = contact.getCustomDisplayName();
        IdentityDetails identityDetails = DbManager.getInstance().getIdentityDetailsDao().get(contact.getIdentityDetailsId());
        if (identityDetails == null) {
            AppLogger.e("updateSortDisplayName: Unable to update sortDisplayName");
            return;
        }
        byte[] sortDisplayName = identityDetails.computeSortDisplayName(customDisplayName);
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.SORT_DISPLAY_NAME, sortDisplayName).where().eq(Contact.GEN_ID, contactId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateSortDisplayName : Unable to update sortDisplayName", throwables);
        }
    }

    public void updateContactCustomUrl(Id<Contact> contactId, String customPhotoUrl) {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        try {
            updateBuilder.updateColumnValue(Contact.CUSTOM_PHOTO_URL, customPhotoUrl).where().eq(Contact.GEN_ID, contactId);
            if (updateBuilder.update() == 0) {
                AppLogger.e("updateContactCustomUrl: Unable to update");
            }
        }
        catch (SQLException e) {
            AppLogger.e("updateContactCustomUrl : Unable to update ", e);
        }
    }

    public void updateIsOneToOne(Id<Contact> genId, boolean isOneToOne) throws SQLException {
        this.checkThread();
        ObvUpdateBuilder updateBuilder = this.updateBuilder();
        updateBuilder.where().eq(Contact.GEN_ID, genId);
        updateBuilder.updateColumnValue(Contact.ONE_TO_ONE, isOneToOne);
        updateBuilder.update();
    }

    public void updateTrustLevel(Id<Contact> genId, int trustLevel) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.TRUST_LEVEL, trustLevel).where().eq(Contact.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateTrustLevel : Unable to update trust level", throwables);
        }
    }

    public void updateActive(Id<Contact> genId, boolean isActive) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.ACTIVE, isActive).where().eq(Contact.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateTrustLevel : Unable to update trust level", throwables);
        }
    }

    public void updateKeycloakManaged(Id<Contact> genId, boolean isKeycloakManaged) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.KEYCLOAK_MANAGED, isKeycloakManaged).where().eq(Contact.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateTrustLevel : Unable to update trust level", throwables);
        }
    }

    public void updateContactDeviceCount(Id<Contact> genId, int deviceCount, int establishedChannelCount, int prekeyCount) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.DEVICE_COUNT, deviceCount).where().eq(Contact.GEN_ID, genId);
            updateBuilder.updateColumnValue(Contact.ESTABLISHED_CHANNEL_COUNT, establishedChannelCount).where().eq(Contact.GEN_ID, genId);
            updateBuilder.updateColumnValue(Contact.PRE_KEY_COUNT, prekeyCount).where().eq(Contact.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateTrustLevel : Unable to update establishedChannelCount", throwables);
        }
    }

    public void updatedUnpublishedDetails(Id<Contact> genId, ContactGenerated.UnpublishedDetails unpublishedDetails) {
        this.checkThread();
        try {
            ObvUpdateBuilder updateBuilder = this.updateBuilder();
            updateBuilder.updateColumnValue(Contact.NEW_PUBLISHED_DETAILS, unpublishedDetails).where().eq(Contact.GEN_ID, genId);
            updateBuilder.update();
        }
        catch (SQLException throwables) {
            AppLogger.e("updateTrustLevel : Unable to update unpublishedDetails", throwables);
        }
    }

    public Contact get(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        this.checkThread();
        ObvQueryBuilder contactQB = this.queryBuilder();
        ObvQueryBuilder identityQB = DbManager.getInstance().getOwnedIdentityDao().queryBuilder();
        if (bytesOwnedIdentity == null || bytesContactIdentity == null) {
            AppLogger.e("Invalid parameters: get(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity)");
            return null;
        }
        try {
            identityQB.where().eq(OwnedIdentity.BYTES_OWNED_IDENTITY, bytesOwnedIdentity);
            contactQB.where().eq(Contact.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            contactQB.join(Contact.FK_OWNED_IDENTITY, OwnedIdentity.GEN_ID, identityQB);
            return (Contact)contactQB.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("get(byte []fkaOwnedIdentity, byte[] fkaContact)", throwables);
            return null;
        }
    }

    public Contact get(Id<OwnedIdentity> ownedIdentity, byte[] bytesContactIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (ownedIdentity == null || bytesContactIdentity == null) {
            AppLogger.e("Invalid parameters: Contact.get(OwnedIdentity ownedIdentity, byte[] bytesContactIdentity)");
            return null;
        }
        try {
            queryBuilder.where().eq(Contact.FK_OWNED_IDENTITY, ownedIdentity).and().eq(Contact.BYTES_CONTACT_IDENTITY, bytesContactIdentity);
            return (Contact)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("get(OwnedIdentity fkaOwnedIdentity, byte[] bytesContactIdentity)", throwables);
            return null;
        }
    }

    public List<Contact> getSortedOneToOneContactsByOwnedIdentity(OwnedIdentity ownedIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (ownedIdentity == null) {
            AppLogger.e("Invalid parameters: getContactsByOwnedIdentity");
            return null;
        }
        try {
            queryBuilder.where().eq(Contact.FK_OWNED_IDENTITY, ownedIdentity).and().eq(Contact.ONE_TO_ONE, true);
            queryBuilder.orderBy(Contact.SORT_DISPLAY_NAME, true);
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getContactsByOwnedIdentity", throwables);
            return null;
        }
    }

    public List<Contact> getSortedNonGroupMembers(Group group) {
        ObvQueryBuilder contactQb = this.queryBuilder();
        this.checkThread();
        if (group == null) {
            AppLogger.e("Invalid parameters: getSortedNonGroupMembers");
            return null;
        }
        try {
            List<Contact> groupMembers = this.getSortedGroupMembers((Id<Group>)group.getItemId());
            List<Contact> pendingGroupMembers = this.getSortedContactPendingGroupMembers((Id<Group>)group.getItemId());
            ArrayList contactIds = new ArrayList(groupMembers.size() + pendingGroupMembers.size());
            for (Contact contact : groupMembers) {
                contactIds.add(contact.getItemId());
            }
            for (Contact contact : pendingGroupMembers) {
                contactIds.add(contact.getItemId());
            }
            contactQb.where().eq(Contact.FK_OWNED_IDENTITY, group.getOwnedIdentityId()).and().notIn(Contact.GEN_ID, contactIds);
            contactQb.orderBy(Contact.SORT_DISPLAY_NAME, true);
            return contactQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getSortedNonGroupMembers", throwables);
            return null;
        }
    }

    public List<Contact> getSortedContactPendingGroupMembers(Id<Group> groupId) {
        this.checkThread();
        ObvQueryBuilder contactQb = this.queryBuilder();
        ObvQueryBuilder pendingGroupMemberQb = DbManager.getInstance().getPendingGroupMemberDao().queryBuilder();
        ObvQueryBuilder contactRefQB = DbManager.getInstance().getContactRefDao().queryBuilder();
        if (groupId == null) {
            AppLogger.e("Invalid parameters: getSortedContactPendingGroupMembers");
            return null;
        }
        try {
            pendingGroupMemberQb.where().eq(PendingGroupMember.FK_GROUP, groupId);
            contactRefQB.join(ContactRef.GEN_ID, PendingGroupMember.FK_CONTACT_REF, pendingGroupMemberQb);
            contactQb.join(Contact.GEN_ID, ContactRef.FK_CONTACT, contactRefQB);
            contactQb.orderBy(Contact.SORT_DISPLAY_NAME, true);
            return contactQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getSortedContactPendingGroupMembers", throwables);
            return null;
        }
    }

    public List<Contact> getSortedGroupMembers(Id<Group> group) {
        ObvQueryBuilder contactQb = this.queryBuilder();
        ObvQueryBuilder contactGroupJoinLongQb = DbManager.getInstance().getContactGroupJoinDao().queryBuilder();
        this.checkThread();
        if (group == null) {
            AppLogger.e("Invalid parameters: getSortedGroupMembers");
            return null;
        }
        try {
            contactGroupJoinLongQb.where().eq(ContactGroupJoin.FK_GROUP, group);
            contactQb.join(Contact.GEN_ID, ContactGroupJoin.FK_CONTACT, contactGroupJoinLongQb);
            contactQb.orderBy(Contact.SORT_DISPLAY_NAME, true);
            return contactQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getSortedGroupMembers", throwables);
            return null;
        }
    }

    public Contact getIfCollected(Id<Contact> contact) {
        return null;
    }
}

