/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public class ApplicationSettingDao
extends OlvidAbstractDao<ApplicationSetting> {
    public ApplicationSettingDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, ApplicationSetting.class);
    }

    public Optional<ApplicationSetting> getAppConfigSettingItem(ApplicationSetting.GlobalAppSettings globalAppSettings) {
        this.checkThread();
        if (globalAppSettings == null) {
            this.logger.error("ApplicationSettingDao::getAppConfigSettingItem given GlobalAppSettings is null");
            return Optional.empty();
        }
        ObvQueryBuilder applicationSettingLongQB = this.queryBuilder();
        try {
            applicationSettingLongQB.where().eq(ApplicationSetting.PREF_KEY, globalAppSettings);
            return Optional.ofNullable((ApplicationSetting)applicationSettingLongQB.queryForFirst());
        }
        catch (SQLException e) {
            this.logger.error("ApplicationSettingDao::getAppConfigSettingItem error", e);
            return Optional.empty();
        }
    }

    public synchronized void updateApplicationSetting(ApplicationSetting.GlobalAppSettings setting, Optional<String> newValueOpt) {
        this.checkThread();
        Optional<ApplicationSetting> currentSettingOpt = this.getAppConfigSettingItem(setting);
        if (newValueOpt.isEmpty()) {
            if (currentSettingOpt.isPresent()) {
                try {
                    DbManager.getInstance().getApplicationSettingsDao().delete(currentSettingOpt.get());
                }
                catch (SQLException e) {
                    AppLogger.e("Cannot delete application setting", e);
                }
            }
        } else {
            String value = newValueOpt.get();
            if (currentSettingOpt.isEmpty()) {
                this.insert(new ApplicationSetting(setting, value));
            } else if (!currentSettingOpt.get().getPrefValue().equals(value)) {
                ObvUpdateBuilder updateBuilder = this.updateBuilder();
                try {
                    updateBuilder.where().eq(ApplicationSetting.PREF_KEY, setting);
                    updateBuilder.updateColumnValue(ApplicationSetting.PREF_VALUE, value);
                    updateBuilder.update();
                }
                catch (SQLException e) {
                    AppLogger.e("Cannot update application setting", e);
                }
            }
        }
    }

    public Optional<Long> getAutomaticAttachmentDownloadSizeSetting() {
        Optional<ApplicationSetting> setting = this.getAppConfigSettingItem(ApplicationSetting.GlobalAppSettings.AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY);
        if (setting.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Long.parseLong(setting.get().getPrefValue()));
    }

    public boolean getSendReadReceiptSetting() {
        Optional<ApplicationSetting> setting = this.getAppConfigSettingItem(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY);
        if (setting.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(setting.get().getPrefValue());
    }
}

