/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.configuration;

import io.olvid.windows.messenger.configuration.AbstractConfiguration;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;

public class AppConfiguration
extends AbstractConfiguration {
    private static final String CONFIG_FILE_NAME = "app_configuration.properties";
    private static String APP_CONFIG_ABS_PATH_LOCATION;
    private static final String APP_CONFIG_ABS_REL_PATH;
    private static final String APP_GLOBAL_CONFIGURATION_ABS_PATH;
    private static final String APP_UPDATE_NOTIFY = "app.update.notify";
    private static final boolean APP_UPDATE_NOTIFY_DEFAULT_VALUE = true;
    private static AppConfiguration instance;

    private AppConfiguration() {
        super(APP_GLOBAL_CONFIGURATION_ABS_PATH);
    }

    public static synchronized AppConfiguration getInstance() {
        if (instance == null) {
            instance = new AppConfiguration();
        }
        return instance;
    }

    public boolean getNotifyOnUpdateProperty() {
        System.out.println("APP_GLOBAL_CONFIGURATION_ABS_PATH : " + APP_GLOBAL_CONFIGURATION_ABS_PATH);
        if (this.configurationProperties == null) {
            return true;
        }
        String propertyAsString = this.configurationProperties.getProperty(APP_UPDATE_NOTIFY);
        boolean prop = propertyAsString == null || propertyAsString.isEmpty() ? true : Boolean.parseBoolean(propertyAsString);
        return prop;
    }

    public String getConfigurationDir() {
        return APP_CONFIG_ABS_REL_PATH;
    }

    @Override
    AbstractConfiguration.ConfigurationLocation getLocation() {
        return AbstractConfiguration.ConfigurationLocation.EXTERNAL;
    }

    static {
        if (AppRuntimeHelper.isDevMode) {
            APP_CONFIG_ABS_PATH_LOCATION = "." + File.separator;
        } else if (AppRuntimeHelper.isWindows()) {
            APP_CONFIG_ABS_PATH_LOCATION = AppRuntimeHelper.JRE_DIR_ABSOLUTE_PATH + File.separator + ".." + File.separator;
        } else if (AppRuntimeHelper.isLinux()) {
            APP_CONFIG_ABS_PATH_LOCATION = AppRuntimeHelper.JRE_DIR_ABSOLUTE_PATH + File.separator + ".." + File.separator + ".." + File.separator;
        } else {
            throw new IllegalStateException("AppConfiguration::static couldn't determine config relative path location for production, inconsistent state");
        }
        APP_CONFIG_ABS_REL_PATH = APP_CONFIG_ABS_PATH_LOCATION + "conf" + File.separator;
        APP_GLOBAL_CONFIGURATION_ABS_PATH = APP_CONFIG_ABS_REL_PATH + CONFIG_FILE_NAME;
    }
}

