/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.configuration;

import io.olvid.windows.messenger.logger.AppLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class AbstractConfiguration {
    protected Properties configurationProperties;
    protected AppLogger logger = new AppLogger(this.getClass());

    abstract ConfigurationLocation getLocation();

    protected AbstractConfiguration(String configFileName) {
        switch (this.getLocation().ordinal()) {
            case 0: {
                try (InputStream fileInStream = this.getClass().getClassLoader().getResourceAsStream(configFileName);){
                    this.loadProperties(fileInStream);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Configuration not found ...", e);
                }
                catch (IOException e) {
                    this.logger.error("Unable to read file ...", e);
                }
                break;
            }
            case 1: {
                try (FileInputStream fileInStream = new FileInputStream(configFileName);){
                    this.loadProperties(fileInStream);
                    break;
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Configuration not found ...", e);
                    break;
                }
                catch (IOException e) {
                    this.logger.error("Unable to read file ...", e);
                }
            }
        }
    }

    private void loadProperties(InputStream stream) throws IOException {
        this.configurationProperties = new Properties();
        this.configurationProperties.load(stream);
    }

    static enum ConfigurationLocation {
        EMBEDDED,
        EXTERNAL;

    }
}

