/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.async;

import io.olvid.windows.messenger.async.CustomThreadFactory;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncTaskExecutor {
    public static final String THREAD_NAME_PREFIX = "App-AsyncTaskExecutor-";
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 40, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new CustomThreadFactory("App-AsyncTaskExecutor-"));

    public static void submitTask(Runnable runnable) {
        executor.submit(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                AppLogger.e("Something wrong happened while executing background task", e);
            }
        });
    }

    public static <returnType> Future<returnType> submitTask(Callable<returnType> task) {
        return executor.submit(task);
    }

    public static void shutdownNow() {
        executor.shutdownNow();
    }
}

