/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.scenes_management.AppScenesManager;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.net.URL;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class FXApp
extends Application {
    public static void main(String[] args) {
        FXApp.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        Platform.runLater(() -> DbManager.setUIThreadId(Thread.currentThread().threadId()));
        primaryStage.setOnCloseRequest(event -> {
            if (AppRuntimeHelper.isBackgroundModeSupported()) {
                AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.RUNNING_BACKGROUND));
            }
        });
        primaryStage.setTitle("Olvid Desktop");
        URL imageURL = ViewControllerHelper.class.getClassLoader().getResource("fx/icons/olvid/ic-launcher.png");
        if (imageURL != null) {
            primaryStage.getIcons().add((Object)new Image(imageURL.toString()));
        }
        ViewControllerHelper.setMainStage(primaryStage);
        AppScenesManager appScenesManager = new AppScenesManager();
        Application.Parameters appArgs = this.getParameters();
        appScenesManager.init(appArgs.getRaw());
        AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.PREREQUISITE));
        if (AppRuntimeHelper.isBackgroundModeSupported()) {
            Platform.setImplicitExit((boolean)false);
        }
    }
}

