/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;

final class DecodeWorker
implements Callable<Integer> {
    private static final int RED = -65536;
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private final Config config;
    private final Queue<Path> inputs;

    DecodeWorker(Config config, Queue<Path> inputs) {
        this.config = config;
        this.inputs = inputs;
    }

    @Override
    public Integer call() throws IOException {
        Path input;
        int successful = 0;
        while ((input = this.inputs.poll()) != null) {
            if (Files.exists(input, new LinkOption[0])) {
                if (this.config.isMulti()) {
                    Result[] results = this.decodeMulti(input.toUri(), this.config.getHints());
                    if (results == null) continue;
                    ++successful;
                    if (!this.config.isDumpResults()) continue;
                    DecodeWorker.dumpResultMulti(input, results);
                    continue;
                }
                Result result = this.decode(input.toUri(), this.config.getHints());
                if (result == null) continue;
                ++successful;
                if (!this.config.isDumpResults()) continue;
                DecodeWorker.dumpResult(input, result);
                continue;
            }
            if (this.decode(input.toUri(), this.config.getHints()) == null) continue;
            ++successful;
        }
        return successful;
    }

    private static void dumpResult(Path input, Result result) throws IOException {
        String name = input.getFileName().toString();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos) + ".txt";
        }
        Path dumpFile = input.getParent().resolve(name);
        Files.write(dumpFile, Collections.singleton(result.getText()), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static void dumpResultMulti(Path input, Result[] results) throws IOException {
        String name = input.getFileName().toString();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos) + ".txt";
        }
        Path dumpFile = input.getParent().resolve(name);
        ArrayList<String> resultTexts = new ArrayList<String>();
        for (Result result : results) {
            resultTexts.add(result.getText());
        }
        Files.write(dumpFile, resultTexts, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private Result decode(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image = ImageReader.readImage(uri);
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uri, image, bitmap);
            }
            Result result = new MultiFormatReader().decode(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                System.out.println(uri + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                for (int i = 0; i < result.getResultPoints().length; ++i) {
                    ResultPoint rp = result.getResultPoints()[i];
                    if (rp == null) continue;
                    System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                }
            }
            return result;
        }
        catch (NotFoundException ignored) {
            System.out.println(uri + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image = ImageReader.readImage(uri);
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uri, image, bitmap);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader((Reader)multiFormatReader);
            Result[] results = reader.decodeMultiple(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri + ": Success");
            } else {
                for (Result result : results) {
                    ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                    System.out.println(uri + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    for (int i = 0; i < result.getResultPoints().length; ++i) {
                        ResultPoint rp = result.getResultPoints()[i];
                        System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                    }
                }
            }
            return results;
        }
        catch (NotFoundException ignored) {
            System.out.println(uri + ": No barcode found");
            return null;
        }
    }

    private static void dumpBlackPoint(URI uri, BufferedImage image, BinaryBitmap bitmap) {
        int offset;
        int y;
        if (uri.getPath().contains(".mono.png")) {
            return;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int stride = width * 3;
        int[] pixels = new int[stride * height];
        int[] argb = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            image.getRGB(0, y2, width, 1, argb, 0, width);
            System.arraycopy(argb, 0, pixels, y2 * stride, width);
        }
        BitArray row = new BitArray(width);
        for (y = 0; y < height; ++y) {
            try {
                row = bitmap.getBlackRow(y, row);
            }
            catch (NotFoundException nfe) {
                offset = y * stride + width;
                Arrays.fill(pixels, offset, offset + width, -65536);
                continue;
            }
            int offset2 = y * stride + width;
            for (int x = 0; x < width; ++x) {
                pixels[offset2 + x] = row.get(x) ? -16777216 : -1;
            }
        }
        try {
            for (y = 0; y < height; ++y) {
                BitMatrix matrix = bitmap.getBlackMatrix();
                offset = y * stride + width * 2;
                for (int x = 0; x < width; ++x) {
                    pixels[offset + x] = matrix.get(x, y) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException ignored) {
            // empty catch block
        }
        DecodeWorker.writeResultImage(stride, height, pixels, uri, ".mono.png");
    }

    private static void writeResultImage(int stride, int height, int[] pixels, URI uri, String suffix) {
        int pos;
        BufferedImage result = new BufferedImage(stride, height, 2);
        result.setRGB(0, 0, stride, height, pixels, 0, stride);
        String resultName = uri.getPath();
        if ("http".equals(uri.getScheme()) && (pos = resultName.lastIndexOf(47)) > 0) {
            resultName = '.' + resultName.substring(pos);
        }
        if ((pos = resultName.lastIndexOf(46)) > 0) {
            resultName = resultName.substring(0, pos);
        }
        resultName = resultName + suffix;
        try {
            if (!ImageIO.write((RenderedImage)result, "png", Paths.get(resultName, new String[0]).toFile())) {
                System.err.println("Could not encode an image to " + resultName);
            }
        }
        catch (IOException ignored) {
            System.err.println("Could not write to " + resultName);
        }
    }
}

