/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.secure_io.PropertiesHelper;
import io.olvid.engine.secure_io.datatypes.Pair;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

public class SeedHandler {
    private static final String PROPS_FILE = "seeds.properties";
    private static final String ENGINE_DATABASE_ID = "engine_database_id";
    private static final String APP_DATABASE_ID = "app_database_id";
    private static final String FILE_ENCRYPTION_ID = "file_encryption_id";
    private final PropertiesHelper propsHelper;

    public SeedHandler(String confBaseDir, String userSecret) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, DecryptionException, InvalidKeyException {
        this.propsHelper = new PropertiesHelper(confBaseDir, PROPS_FILE, userSecret);
    }

    Seed getEncryptionSeed(EncryptionSeedType encryptionSeedType) {
        switch (encryptionSeedType.ordinal()) {
            case 0: {
                return this.getSeed(ENGINE_DATABASE_ID);
            }
            case 1: {
                return this.getSeed(APP_DATABASE_ID);
            }
            case 2: {
                return this.getSeed(FILE_ENCRYPTION_ID);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)encryptionSeedType));
    }

    private Seed getSeed(String propId) {
        Seed fileNameEncSeed;
        if (null == this.propsHelper.getProps().getProperty(propId)) {
            fileNameEncSeed = new Seed(Suite.getDefaultPRNGService(0));
            try {
                this.propsHelper.addProp(new Pair<String, String>(propId, Logger.toHexString(fileNameEncSeed.getBytes())));
            }
            catch (DecryptionException | IOException | InvalidKeyException e) {
                e.printStackTrace();
            }
        } else {
            fileNameEncSeed = new Seed(Logger.fromHexString(this.propsHelper.getProps().getProperty(propId)));
        }
        return fileNameEncSeed;
    }

    public static enum EncryptionSeedType {
        ENGINE_DATABASE,
        APP_DATABASE,
        FILE_NAME,
        FILE_CONTENT;

    }
}

