/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.secure_io.SecureIOHelper;
import io.olvid.engine.secure_io.datatypes.FileKeys;
import java.security.InvalidKeyException;

public class SecureFileHeader {
    private long fileSize;
    private final byte[] plainFileName;
    private byte[] encryptedFileName;
    private final Encoded contentEncryptionFileKey;
    private final FileKeys associatedKeys;

    public SecureFileHeader(long fileSize, byte[] fileName, Encoded contentEncryptionFileKey, FileKeys associatedKeys, byte[] plainFileName) {
        this.fileSize = fileSize;
        this.encryptedFileName = fileName;
        this.contentEncryptionFileKey = contentEncryptionFileKey;
        this.associatedKeys = associatedKeys;
        this.plainFileName = plainFileName;
    }

    public byte[] buildHeaderBlock(AuthEncKey fileNameAuthEncKey) {
        try {
            EncryptedBytes encryptedKey = SecureIOHelper.authEnc.encrypt(fileNameAuthEncKey, this.contentEncryptionFileKey.getBytes(), Suite.getPRNGService("prng_hmac_sha-256"));
            Encoded encodedList = Encoded.of(new Encoded[]{Encoded.of(this.fileSize), Encoded.of(this.encryptedFileName), Encoded.of(encryptedKey)});
            byte[] headerToWrite = new byte[4096];
            System.arraycopy(encodedList.getBytes(), 0, headerToWrite, 0, encodedList.getBytes().length);
            return headerToWrite;
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.e("Invalid Key Exception : \n" + invalidKeyException.getMessage(), invalidKeyException);
            return null;
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setEncryptedFileName(byte[] newEncryptedFileName) {
        this.encryptedFileName = newEncryptedFileName;
    }

    public FileKeys getAssociatedKeys() {
        return this.associatedKeys;
    }

    public byte[] getPlainFileName() {
        return this.plainFileName;
    }
}

