/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.secure_io.SeedHandler;
import io.olvid.engine.secure_io.datatypes.Pair;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

public class KeyManagerSingleton {
    private static KeyManagerSingleton keyManagerSingletonInstance;
    private SeedHandler seedHandler;
    private static final String DEFAULT = "unsafe";

    private KeyManagerSingleton() {
    }

    public static synchronized KeyManagerSingleton getInstance() {
        if (keyManagerSingletonInstance == null) {
            keyManagerSingletonInstance = new KeyManagerSingleton();
        }
        return keyManagerSingletonInstance;
    }

    public boolean tryToInitKeyManagement(String confBaseDir, String password) {
        try {
            KeyManagerSingleton.getInstance().initKeyManagement(confBaseDir + "/security", password);
            return true;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            Logger.e("Critical error during initKeyManagement, exiting", e);
            return false;
        }
        catch (DecryptionException | InvalidKeyException e) {
            return false;
        }
    }

    public String getDbEncryptionKey(SeedHandler.EncryptionSeedType seedTarget) {
        Seed appDbEncKeySeed = this.seedHandler.getEncryptionSeed(seedTarget);
        return "x'" + Logger.toHexString(appDbEncKeySeed.getBytes()) + "'";
    }

    public AuthEncKey generateKeyForFileEnc() {
        Logger.d("Executing last step in key generation");
        PRNGService prng = Suite.getPRNGService("prng_hmac_sha-256");
        AuthEnc authEnc = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256");
        return authEnc.generateKey(prng);
    }

    public Pair<MACKey, AuthEncKey> generateKeysForFileName() {
        Seed seed = new Seed(this.seedHandler.getEncryptionSeed(SeedHandler.EncryptionSeedType.FILE_NAME).getBytes());
        PRNG prng = Suite.getPRNG("prng_hmac_sha-256", seed);
        MAC MACHmacsha256 = Suite.getMAC("hmac_sha-256");
        if (MACHmacsha256 != null) {
            MACKey macKey = MACHmacsha256.generateKey(prng);
            AuthEncKey authEncKey = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256").generateKey(prng);
            return new Pair<MACKey, AuthEncKey>(macKey, authEncKey);
        }
        Logger.e("Something went wrong generating key for file Pair<MACKey,AuthEncKey> : ");
        return null;
    }

    private void initKeyManagement(String confBaseDir, String pwd) throws IOException, InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException, DecryptionException {
        if (confBaseDir == null) {
            confBaseDir = System.getProperty("java.io.tmpdir");
        }
        if (pwd.isEmpty()) {
            pwd = DEFAULT;
        }
        this.seedHandler = new SeedHandler(confBaseDir, pwd);
    }
}

