/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.ContactManagementProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceDiscoveryProtocol;
import java.nio.charset.StandardCharsets;

public class OwnedDeviceManagementProtocol
extends ConcreteProtocol {
    public static final int REQUEST_SENT_STATE_ID = 1;
    public static final int RESPONSE_PROCESSED_STATE_ID = 2;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int SERVER_QUERY_MESSAGE_ID = 1;

    public OwnedDeviceManagementProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 24;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return RequestSentState.class;
            }
            case 2: {
                return ResponseProcessedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ServerQueryMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendRequestStep.class};
            }
            case 1: {
                return new Class[]{ProcessResponseStateStep.class};
            }
        }
        return new Class[0];
    }

    public static class RequestSentState
    extends ConcreteProtocolState {
        public final ObvDeviceManagementRequest deviceManagementRequest;

        public RequestSentState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.deviceManagementRequest = ObvDeviceManagementRequest.of(list[0]);
        }

        public RequestSentState(ObvDeviceManagementRequest deviceManagementRequest) {
            super(1);
            this.deviceManagementRequest = deviceManagementRequest;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.deviceManagementRequest.encode()});
        }
    }

    public static class ResponseProcessedState
    extends ConcreteProtocolState {
        public ResponseProcessedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public ResponseProcessedState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        public final ObvDeviceManagementRequest deviceManagementRequest;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, ObvDeviceManagementRequest deviceManagementRequest) {
            super(coreProtocolMessage);
            this.deviceManagementRequest = deviceManagementRequest;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.deviceManagementRequest = ObvDeviceManagementRequest.of(receivedMessage.getInputs()[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.deviceManagementRequest.encode()};
        }
    }

    public static class ServerQueryMessage
    extends ConcreteProtocolMessage {
        public ServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public ServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class SendRequestStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public SendRequestStep(InitialProtocolState startState, InitialMessage receivedMessage, OwnedDeviceManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), switch (this.receivedMessage.deviceManagementRequest.action) {
                case 0 -> {
                    byte[] encodedDeviceName = Encoded.of(new Encoded[]{Encoded.of(this.receivedMessage.deviceManagementRequest.nickname.getBytes(StandardCharsets.UTF_8))}).getBytes();
                    byte[] plaintext = new byte[(encodedDeviceName.length - 1 | 0x7F) + 1];
                    System.arraycopy(encodedDeviceName, 0, plaintext, 0, encodedDeviceName.length);
                    EncryptedBytes encryptedDeviceName = Suite.getPublicKeyEncryption(this.getOwnedIdentity().getEncryptionPublicKey()).encrypt(this.getOwnedIdentity().getEncryptionPublicKey(), plaintext, Suite.getDefaultPRNGService(0));
                    UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                    yield new ServerQuery.DeviceManagementSetNicknameQuery(this.getOwnedIdentity(), this.receivedMessage.deviceManagementRequest.getDeviceUid(), encryptedDeviceName, currentDeviceUid.equals(this.receivedMessage.deviceManagementRequest.getDeviceUid()));
                }
                case 1 -> new ServerQuery.DeviceManagementDeactivateDeviceQuery(this.getOwnedIdentity(), this.receivedMessage.deviceManagementRequest.getDeviceUid());
                case 2 -> new ServerQuery.DeviceManagementSetUnexpiringDeviceQuery(this.getOwnedIdentity(), this.receivedMessage.deviceManagementRequest.getDeviceUid());
                default -> {
                    Logger.e("OwnedDeviceManagementProtocol received an invalid ObvDeviceManagementRequest: unknown action");
                    throw new Exception();
                }
            }));
            ChannelServerQueryMessageToSend messageToSend = new ServerQueryMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new RequestSentState(this.receivedMessage.deviceManagementRequest);
        }
    }

    public static class ProcessResponseStateStep
    extends ProtocolStep {
        private final RequestSentState startState;
        private final ServerQueryMessage receivedMessage;

        public ProcessResponseStateStep(RequestSentState startState, ServerQueryMessage receivedMessage, OwnedDeviceManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID protocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 21, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new OwnedDeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.getPrng());
            if (this.startState.deviceManagementRequest.action == 1) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()), this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage2 = new CoreProtocolMessage(sendChannelInfo, 10, new UID(this.getPrng()));
                        ChannelProtocolMessageToSend message2 = new ContactManagementProtocol.PerformContactDeviceDiscoveryMessage(coreProtocolMessage2).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message2, this.getPrng());
                    }
                    catch (NoAcceptableChannelException e) {
                        Logger.d("One SendChannelInfo with no channel during OwnedDeviceManagementProtocol.ProcessResponseStateStep");
                    }
                }
            }
            return new ResponseProcessedState();
        }
    }
}

