/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.EncodedOwnedPreKey;
import io.olvid.engine.datatypes.containers.OwnedDeviceAndPreKey;
import io.olvid.engine.datatypes.containers.PreKey;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OwnedDeviceDiscoveryProtocol
extends ConcreteProtocol {
    public static final int REQUEST_SENT_STATE_ID = 1;
    public static final int FINISHED_STATE_ID = 2;
    public static final int CANCELLED_STATE_ID = 3;
    public static final int UPLOADING_PRE_KEY_STATE_ID = 4;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int SERVER_QUERY_MESSAGE_ID = 1;
    public static final int TRIGGER_OWNED_DEVICE_DISCOVERY_MESSAGE_ID = 2;
    public static final int UPLOAD_PRE_KEY_MESSAGE_ID = 3;

    public OwnedDeviceDiscoveryProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 21;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{3, 2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return RequestSentState.class;
            }
            case 2: {
                return FinishedState.class;
            }
            case 4: {
                return UploadingPreKeyState.class;
            }
            case 3: {
                return CancelledState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ServerQueryMessage.class;
            }
            case 2: {
                return TriggerOwnedDeviceDiscoveryMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendRequestStep.class};
            }
            case 1: {
                return new Class[]{ProcessResponseStateStep.class};
            }
            case 4: {
                return new Class[]{PreKeyUploadedStep.class};
            }
        }
        return new Class[0];
    }

    public static class RequestSentState
    extends ConcreteProtocolState {
        public RequestSentState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public RequestSentState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class FinishedState
    extends ConcreteProtocolState {
        public FinishedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class UploadingPreKeyState
    extends ConcreteProtocolState {
        public UploadingPreKeyState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public UploadingPreKeyState() {
            super(4);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class CancelledState
    extends ConcreteProtocolState {
        public CancelledState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public CancelledState() {
            super(3);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        public InitialMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class ServerQueryMessage
    extends ConcreteProtocolMessage {
        private final EncryptedBytes encryptedOwnedDeviceList;

        public ServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.encryptedOwnedDeviceList = null;
        }

        public ServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.encryptedOwnedDeviceList = receivedMessage.getEncodedResponse().decodeEncryptedData();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class TriggerOwnedDeviceDiscoveryMessage
    extends EmptyProtocolMessage {
        public TriggerOwnedDeviceDiscoveryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public TriggerOwnedDeviceDiscoveryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }
    }

    public static class SendRequestStep
    extends ProtocolStep {
        private final InitialProtocolState startState;

        public SendRequestStep(InitialProtocolState startState, InitialMessage receivedMessage, OwnedDeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
        }

        public SendRequestStep(InitialProtocolState startState, TriggerOwnedDeviceDiscoveryMessage receivedMessage, OwnedDeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.OwnedDeviceDiscoveryQuery(this.getOwnedIdentity())));
            ChannelServerQueryMessageToSend messageToSend = new ServerQueryMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new RequestSentState();
        }
    }

    public static class ProcessResponseStateStep
    extends ProtocolStep {
        private final RequestSentState startState;
        private final ServerQueryMessage receivedMessage;

        public ProcessResponseStateStep(RequestSentState startState, ServerQueryMessage receivedMessage, OwnedDeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            PreKeyBlobOnServer preKeyBlob;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            byte[] decryptedPayload = protocolManagerSession.encryptionForIdentityDelegate.decrypt(protocolManagerSession.session, this.receivedMessage.encryptedOwnedDeviceList, this.getOwnedIdentity());
            if (decryptedPayload == null) {
                Logger.w("Unable to DECRYPT received OwnedDeviceDiscoveryProtocol payload (or expired query)!");
                return new CancelledState();
            }
            HashMap<UID, SignedPreKeyAndServerInfo> serverOwnedDevices = new HashMap<UID, SignedPreKeyAndServerInfo>();
            Long serverTimestamp = null;
            try {
                HashMap<DictionaryKey, Encoded> map = new Encoded(decryptedPayload).decodeDictionary();
                Encoded encodedTimestamp = map.get(new DictionaryKey("st"));
                if (encodedTimestamp != null) {
                    serverTimestamp = encodedTimestamp.decodeLong();
                }
                Encoded[] encodedDevices = map.get(new DictionaryKey("dev")).decodeList();
                for (Encoded encodedDevice : encodedDevices) {
                    HashMap<DictionaryKey, Encoded> deviceMap = encodedDevice.decodeDictionary();
                    UID deviceUid = deviceMap.get(new DictionaryKey("uid")).decodeUid();
                    Encoded encodedExpiration = deviceMap.get(new DictionaryKey("exp"));
                    Long expirationTimestamp = encodedExpiration == null ? null : Long.valueOf(encodedExpiration.decodeLong());
                    Encoded encodedRegistration = deviceMap.get(new DictionaryKey("reg"));
                    Long lastRegistrationTimestamp = encodedRegistration == null ? null : Long.valueOf(encodedRegistration.decodeLong());
                    Encoded encodedName = deviceMap.get(new DictionaryKey("name"));
                    String deviceName = null;
                    if (encodedName != null) {
                        try {
                            byte[] plaintext = protocolManagerSession.encryptionForIdentityDelegate.decrypt(protocolManagerSession.session, encodedName.decodeEncryptedData(), this.getOwnedIdentity());
                            byte[] bytesDeviceName = new Encoded(plaintext).decodeListWithPadding()[0].decodeBytes();
                            if (bytesDeviceName.length != 0) {
                                deviceName = new String(bytesDeviceName, StandardCharsets.UTF_8);
                            }
                        }
                        catch (Exception plaintext) {
                            // empty catch block
                        }
                    }
                    Encoded encodedSignedPreKey = deviceMap.get(new DictionaryKey("prk"));
                    serverOwnedDevices.put(deviceUid, new SignedPreKeyAndServerInfo(encodedSignedPreKey, new ObvOwnedDevice.ServerDeviceInfo(deviceName, expirationTimestamp, lastRegistrationTimestamp)));
                }
            }
            catch (Exception e) {
                Logger.w("Unable to DECODE received OwnedDeviceDiscoveryProtocol payload!");
                return new CancelledState();
            }
            List<OwnedDeviceAndPreKey> oldOwnedDevices = protocolManagerSession.identityDelegate.getDevicesAndPreKeysOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            UID currentDeviceUid = null;
            PreKey currentDevicePreKeyOnServer = null;
            for (OwnedDeviceAndPreKey ownedDeviceAndPreKey : oldOwnedDevices) {
                boolean preKeyChanged;
                PreKeyBlobOnServer newPreKeyBlob;
                SignedPreKeyAndServerInfo signedPreKeyAndServerInfo = (SignedPreKeyAndServerInfo)serverOwnedDevices.remove(ownedDeviceAndPreKey.deviceUid);
                if (signedPreKeyAndServerInfo == null) {
                    if (ownedDeviceAndPreKey.currentDevice) {
                        currentDeviceUid = ownedDeviceAndPreKey.deviceUid;
                        protocolManagerSession.pushNotificationDelegate.forceRegisterPushNotification(this.getOwnedIdentity(), true);
                        continue;
                    }
                    protocolManagerSession.channelDelegate.deleteObliviousChannelIfItExists(protocolManagerSession.session, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid, this.getOwnedIdentity());
                    protocolManagerSession.identityDelegate.removeDeviceForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid);
                    continue;
                }
                if (ownedDeviceAndPreKey.currentDevice) {
                    currentDeviceUid = ownedDeviceAndPreKey.deviceUid;
                    currentDevicePreKeyOnServer = signedPreKeyAndServerInfo.encodedSignedPreKey != null ? ((preKeyBlob = PreKeyBlobOnServer.verifySignatureAndDecode(signedPreKeyAndServerInfo.encodedSignedPreKey, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid, serverTimestamp)) == null ? null : preKeyBlob.preKey) : null;
                    if (Objects.equals(ownedDeviceAndPreKey.serverDeviceInfo, signedPreKeyAndServerInfo.serverDeviceInfo)) continue;
                    protocolManagerSession.identityDelegate.updateOwnedDevice(protocolManagerSession.session, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid, signedPreKeyAndServerInfo.serverDeviceInfo.displayName, signedPreKeyAndServerInfo.serverDeviceInfo.expirationTimestamp, signedPreKeyAndServerInfo.serverDeviceInfo.lastRegistrationTimestamp, null);
                    continue;
                }
                if (signedPreKeyAndServerInfo.encodedSignedPreKey != null) {
                    PreKeyBlobOnServer preKeyBlob2 = PreKeyBlobOnServer.verifySignatureAndDecode(signedPreKeyAndServerInfo.encodedSignedPreKey, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid, serverTimestamp);
                    if (preKeyBlob2 != null && (ownedDeviceAndPreKey.preKey == null || !preKeyBlob2.preKey.keyId.equals(ownedDeviceAndPreKey.preKey.keyId) && ownedDeviceAndPreKey.preKey.expirationTimestamp < preKeyBlob2.preKey.expirationTimestamp)) {
                        newPreKeyBlob = preKeyBlob2;
                        preKeyChanged = true;
                    } else {
                        newPreKeyBlob = new PreKeyBlobOnServer(ownedDeviceAndPreKey.preKey, null);
                        preKeyChanged = false;
                    }
                } else if (ownedDeviceAndPreKey.preKey != null) {
                    Logger.w("A preKey was removed from the server, this should never happen...");
                    newPreKeyBlob = null;
                    preKeyChanged = true;
                } else {
                    newPreKeyBlob = null;
                    preKeyChanged = false;
                }
                if (!preKeyChanged && Objects.equals(ownedDeviceAndPreKey.serverDeviceInfo, signedPreKeyAndServerInfo.serverDeviceInfo)) continue;
                protocolManagerSession.identityDelegate.updateOwnedDevice(protocolManagerSession.session, this.getOwnedIdentity(), ownedDeviceAndPreKey.deviceUid, signedPreKeyAndServerInfo.serverDeviceInfo.displayName, signedPreKeyAndServerInfo.serverDeviceInfo.expirationTimestamp, signedPreKeyAndServerInfo.serverDeviceInfo.lastRegistrationTimestamp, newPreKeyBlob);
            }
            for (Map.Entry entry : serverOwnedDevices.entrySet()) {
                ObvOwnedDevice.ServerDeviceInfo serverDeviceInfo = ((SignedPreKeyAndServerInfo)entry.getValue()).serverDeviceInfo;
                preKeyBlob = ((SignedPreKeyAndServerInfo)entry.getValue()).encodedSignedPreKey == null ? null : PreKeyBlobOnServer.verifySignatureAndDecode(((SignedPreKeyAndServerInfo)entry.getValue()).encodedSignedPreKey, this.getOwnedIdentity(), (UID)entry.getKey(), serverTimestamp);
                protocolManagerSession.identityDelegate.addDeviceForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), (UID)entry.getKey(), serverDeviceInfo.displayName, serverDeviceInfo.expirationTimestamp, serverDeviceInfo.lastRegistrationTimestamp, preKeyBlob, false);
            }
            if (serverTimestamp != null) {
                void var9_20;
                Encoded encodedNewPreKey;
                boolean generatePreKey;
                boolean latestPreKeyIsValid;
                protocolManagerSession.identityDelegate.expireContactAndOwnedPreKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.getOwnedIdentity().getServer(), serverTimestamp);
                EncodedOwnedPreKey latestPreKey = protocolManagerSession.identityDelegate.getLatestPreKeyForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                boolean bl = latestPreKeyIsValid = latestPreKey != null && latestPreKey.expirationTimestamp > serverTimestamp + 5184000000L - 604800000L;
                if (currentDevicePreKeyOnServer != null) {
                    if (latestPreKeyIsValid) {
                        if (Objects.equals(latestPreKey.keyId, currentDevicePreKeyOnServer.keyId)) {
                            generatePreKey = false;
                            boolean bl2 = false;
                        } else if (currentDevicePreKeyOnServer.expirationTimestamp < latestPreKey.expirationTimestamp) {
                            generatePreKey = false;
                            boolean bl3 = true;
                        } else {
                            Logger.e("Found an unknown newer PreKey on the server!");
                            generatePreKey = true;
                            boolean bl4 = false;
                        }
                    } else {
                        generatePreKey = true;
                        boolean bl5 = false;
                    }
                } else if (latestPreKeyIsValid) {
                    generatePreKey = false;
                    boolean bl6 = true;
                } else {
                    generatePreKey = true;
                    boolean bl7 = false;
                }
                Object encodedPreKeyToUpload = generatePreKey ? (Object)((encodedNewPreKey = protocolManagerSession.identityDelegate.generateNewPreKey(protocolManagerSession.session, this.getOwnedIdentity(), serverTimestamp + 5184000000L)) != null ? encodedNewPreKey.getBytes() : null) : (var9_20 != false ? latestPreKey.encodedSignedPreKey.getBytes() : null);
                if (encodedPreKeyToUpload != null && currentDeviceUid != null) {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.UploadPreKeyQuery(this.getOwnedIdentity(), currentDeviceUid, (byte[])encodedPreKeyToUpload)));
                    ChannelServerQueryMessageToSend messageToSend = new UploadPreKeyMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    return new UploadingPreKeyState();
                }
            }
            protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_owned_device_discovery_done", Collections.singletonMap("owned_identity", this.getOwnedIdentity()));
            return new FinishedState();
        }

        private static class SignedPreKeyAndServerInfo {
            public final Encoded encodedSignedPreKey;
            public final ObvOwnedDevice.ServerDeviceInfo serverDeviceInfo;

            public SignedPreKeyAndServerInfo(Encoded encodedSignedPreKey, ObvOwnedDevice.ServerDeviceInfo serverDeviceInfo) {
                this.encodedSignedPreKey = encodedSignedPreKey;
                this.serverDeviceInfo = serverDeviceInfo;
            }
        }
    }

    public static class PreKeyUploadedStep
    extends ProtocolStep {
        private final RequestSentState startState;
        private final UploadPreKeyMessage receivedMessage;

        public PreKeyUploadedStep(RequestSentState startState, UploadPreKeyMessage receivedMessage, OwnedDeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            return new FinishedState();
        }
    }

    public static class UploadPreKeyMessage
    extends ConcreteProtocolMessage {
        public UploadPreKeyMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public UploadPreKeyMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }
}

