/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.databases.WaitingForOneToOneContactProtocolInstance;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.ContactManagementProtocol;
import java.sql.SQLException;
import java.util.UUID;

public class OneToOneContactInvitationProtocol
extends ConcreteProtocol {
    public static final int INVITATION_SENT_STATE_ID = 1;
    public static final int INVITATION_RECEIVED_STATE_ID = 2;
    public static final int FINISHED_STATE_ID = 3;
    private static final int INITIAL_MESSAGE_ID = 0;
    private static final int ONE_TO_ONE_INVITATION_MESSAGE_ID = 1;
    private static final int DIALOG_INVITATION_SENT_MESSAGE_ID = 2;
    private static final int PROPAGATE_ONE_TO_ONE_INVITATION_MESSAGE_ID = 3;
    private static final int DIALOG_ACCEPT_ONE_TO_ONE_INVITATION_MESSAGE_ID = 4;
    private static final int ONE_TO_ONE_RESPONSE_MESSAGE_ID = 5;
    private static final int PROPAGATE_ONE_TO_ONE_RESPONSE_MESSAGE_ID = 6;
    private static final int ABORT_MESSAGE_ID = 7;
    private static final int CONTACT_UPGRADED_TO_ONE_TO_ONE_MESSAGE_ID = 8;
    private static final int PROPAGATE_ABORT_MESSAGE_ID = 9;
    private static final int INITIATE_ONE_TO_ONE_STATUS_SYNC_WITH_ALL_CONTACTS_MESSAGE_ID = 10;
    private static final int ONE_TO_ONE_STATUS_SYNC_REQUEST_MESSAGE_ID = 11;
    private static final int INITIATE_ONE_TO_ONE_STATUS_SYNC_WITH_ONE_CONTACT_MESSAGE_ID = 12;

    public OneToOneContactInvitationProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.requiresProtocolInstanceToBeInsertedBeforeInitialStep = true;
    }

    @Override
    public int getProtocolId() {
        return 17;
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return InvitationSentState.class;
            }
            case 2: {
                return InvitationReceivedState.class;
            }
            case 3: {
                return FinishedState.class;
            }
        }
        return null;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{3};
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return OneToOneInvitationMessage.class;
            }
            case 2: {
                return DialogInvitationSentMessage.class;
            }
            case 3: {
                return PropagateOneToOneInvitationMessage.class;
            }
            case 4: {
                return DialogAcceptOneToOneInvitationMessage.class;
            }
            case 5: {
                return OneToOneResponseMessage.class;
            }
            case 6: {
                return PropagateOneToOneResponseMessage.class;
            }
            case 7: {
                return AbortMessage.class;
            }
            case 8: {
                return ContactUpgradedToOneToOneMessage.class;
            }
            case 9: {
                return PropagateAbortMessage.class;
            }
            case 10: {
                return InitiateOneToOneStatusSyncWithAllContactsMessage.class;
            }
            case 11: {
                return OneToOneStatusSyncRequestMessage.class;
            }
            case 12: {
                return InitiateOneToOneStatusSyncWithOneContactMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{AliceInvitesBobStep.class, BobProcessesAlicesInvitationStep.class, AliceProcessesPropagatedInvitationStep.class, AliceAbortsHerInvitationToBobStep.class, AliceProcessesUnexpectedBobResponseStep.class, AliceInitiatesOneToOneStatusSyncWithAllContactsStep.class, AliceInitiatesOneToOneStatusSyncWithOneContactStep.class, BobProcessesSyncRequestStep.class};
            }
            case 1: {
                return new Class[]{AliceReceivesBobsResponseStep.class, AliceAbortsHerInvitationToBobStep.class, ProcessContactUpgradedToOneToOneStep.class, AliceProcessesPropagatedAbortStep.class};
            }
            case 2: {
                return new Class[]{BobRespondsToAlicesInvitationStep.class, BobProcessesAbortStep.class, BobProcessesPropagatedResponseStep.class, ProcessContactUpgradedToOneToOneStep.class};
            }
        }
        return new Class[0];
    }

    public static class InvitationSentState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final UUID dialogUuid;

        public InvitationSentState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.dialogUuid = list[1].decodeUuid();
        }

        public InvitationSentState(Identity contactIdentity, UUID dialogUuid) {
            super(1);
            this.contactIdentity = contactIdentity;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.dialogUuid)});
        }
    }

    public static class InvitationReceivedState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final UUID dialogUuid;

        public InvitationReceivedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.dialogUuid = list[1].decodeUuid();
        }

        public InvitationReceivedState(Identity contactIdentity, UUID dialogUuid) {
            super(2);
            this.contactIdentity = contactIdentity;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.dialogUuid)});
        }
    }

    public static class FinishedState
    extends ConcreteProtocolState {
        public FinishedState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedState() {
            super(3);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class OneToOneInvitationMessage
    extends ConcreteProtocolMessage {
        public OneToOneInvitationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public OneToOneInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class DialogInvitationSentMessage
    extends ConcreteProtocolMessage {
        private final boolean abort;
        private final UUID dialogUuid;

        DialogInvitationSentMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.abort = false;
            this.dialogUuid = null;
        }

        public DialogInvitationSentMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.abort = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateOneToOneInvitationMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;

        public PropagateOneToOneInvitationMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public PropagateOneToOneInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class DialogAcceptOneToOneInvitationMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final UUID dialogUuid;

        DialogAcceptOneToOneInvitationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.invitationAccepted = false;
            this.dialogUuid = null;
        }

        public DialogAcceptOneToOneInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class OneToOneResponseMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;

        public OneToOneResponseMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
        }

        public OneToOneResponseMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted)};
        }
    }

    public static class PropagateOneToOneResponseMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;

        public PropagateOneToOneResponseMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
        }

        public PropagateOneToOneResponseMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted)};
        }
    }

    public static class AbortMessage
    extends ConcreteProtocolMessage {
        public AbortMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public AbortMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 7;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class ContactUpgradedToOneToOneMessage
    extends ConcreteProtocolMessage {
        Identity trustLevelIncreasedIdentity;

        public ContactUpgradedToOneToOneMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.trustLevelIncreasedIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 8;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateAbortMessage
    extends ConcreteProtocolMessage {
        public PropagateAbortMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public PropagateAbortMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class InitiateOneToOneStatusSyncWithAllContactsMessage
    extends ConcreteProtocolMessage {
        public InitiateOneToOneStatusSyncWithAllContactsMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public InitiateOneToOneStatusSyncWithAllContactsMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 10;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class OneToOneStatusSyncRequestMessage
    extends ConcreteProtocolMessage {
        private final boolean aliceConsidersBobAsOneToOne;

        public OneToOneStatusSyncRequestMessage(CoreProtocolMessage coreProtocolMessage, boolean aliceConsidersBobAsOneToOne) {
            super(coreProtocolMessage);
            this.aliceConsidersBobAsOneToOne = aliceConsidersBobAsOneToOne;
        }

        public OneToOneStatusSyncRequestMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.aliceConsidersBobAsOneToOne = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 11;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.aliceConsidersBobAsOneToOne)};
        }
    }

    public static class InitiateOneToOneStatusSyncWithOneContactMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;

        public InitiateOneToOneStatusSyncWithOneContactMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public InitiateOneToOneStatusSyncWithOneContactMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 12;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class AliceInvitesBobStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public AliceInvitesBobStep(InitialProtocolState startState, InitialMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = UUID.randomUUID();
            if (!protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createOneToOneInvitationSentDialog(this.receivedMessage.contactIdentity), dialogUuid));
                messageToSend = new DialogInvitationSentMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
            messageToSend = new OneToOneInvitationMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            WaitingForOneToOneContactProtocolInstance.create(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.contactIdentity, this.getProtocolId(), 8);
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateOneToOneInvitationMessage(coreProtocolMessage2, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new InvitationSentState(this.receivedMessage.contactIdentity, dialogUuid);
        }
    }

    public static class BobProcessesAlicesInvitationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final OneToOneInvitationMessage receivedMessage;

        public BobProcessesAlicesInvitationStep(InitialProtocolState startState, OneToOneInvitationMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            WaitingForOneToOneContactProtocolInstance[] waitingForOneToOneContactProtocolInstances;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new OneToOneResponseMessage(coreProtocolMessage, true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinishedState();
            }
            for (WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance : waitingForOneToOneContactProtocolInstances = WaitingForOneToOneContactProtocolInstance.getAllForContact(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                ProtocolInstance protocolInstance;
                if (waitingForOneToOneContactProtocolInstance.getProtocolId() != this.getProtocolId() || (protocolInstance = ProtocolInstance.get(protocolManagerSession, waitingForOneToOneContactProtocolInstance.getProtocolUid(), this.getOwnedIdentity())) == null || protocolInstance.getCurrentStateId() != 1) continue;
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new OneToOneResponseMessage(coreProtocolMessage, true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), true);
                return new FinishedState();
            }
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptOneToOneInvitationDialog(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.receivedMessage.getServerTimestamp()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new DialogAcceptOneToOneInvitationMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            WaitingForOneToOneContactProtocolInstance.create(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getProtocolId(), 8);
            return new InvitationReceivedState(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), dialogUuid);
        }
    }

    public static class AliceProcessesPropagatedInvitationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateOneToOneInvitationMessage receivedMessage;

        public AliceProcessesPropagatedInvitationStep(InitialProtocolState startState, PropagateOneToOneInvitationMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = UUID.randomUUID();
            if (!protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createOneToOneInvitationSentDialog(this.receivedMessage.contactIdentity), dialogUuid));
                ChannelDialogMessageToSend messageToSend = new DialogInvitationSentMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            WaitingForOneToOneContactProtocolInstance.create(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.contactIdentity, this.getProtocolId(), 8);
            return new InvitationSentState(this.receivedMessage.contactIdentity, dialogUuid);
        }
    }

    public static class AliceAbortsHerInvitationToBobStep
    extends ProtocolStep {
        private final InvitationSentState startState;
        private final DialogInvitationSentMessage receivedMessage;

        public AliceAbortsHerInvitationToBobStep(InvitationSentState startState, DialogInvitationSentMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.abort) {
                return this.startState;
            }
            if (protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.startState.contactIdentity, this.getOwnedIdentity()));
                messageToSend = new AbortMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.receivedMessage.dialogUuid));
            messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateAbortMessage(coreProtocolMessage2).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinishedState();
        }
    }

    public static class AliceProcessesUnexpectedBobResponseStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final OneToOneResponseMessage receivedMessage;

        public AliceProcessesUnexpectedBobResponseStep(InitialProtocolState startState, OneToOneResponseMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.invitationAccepted) {
                return new FinishedState();
            }
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), false);
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 10, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new ContactManagementProtocol.InitiateContactDowngradeMessage(coreProtocolMessage, this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity()).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class AliceInitiatesOneToOneStatusSyncWithAllContactsStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateOneToOneStatusSyncWithAllContactsMessage receivedMessage;

        public AliceInitiatesOneToOneStatusSyncWithAllContactsStep(InitialProtocolState startState, InitiateOneToOneStatusSyncWithAllContactsMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            Identity[] contactIdentities;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            for (Identity contactIdentity : contactIdentities = protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())) {
                try {
                    boolean oneToOne;
                    if (protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), contactIdentity)) {
                        oneToOne = true;
                    } else {
                        if (!protocolManagerSession.identityDelegate.isIdentityANotOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), contactIdentity)) continue;
                        oneToOne = false;
                    }
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new OneToOneStatusSyncRequestMessage(coreProtocolMessage, oneToOne).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (SQLException e) {
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new FinishedState();
        }
    }

    public static class AliceInitiatesOneToOneStatusSyncWithOneContactStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateOneToOneStatusSyncWithOneContactMessage receivedMessage;

        public AliceInitiatesOneToOneStatusSyncWithOneContactStep(InitialProtocolState startState, InitiateOneToOneStatusSyncWithOneContactMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            boolean oneToOne;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                oneToOne = true;
            } else if (protocolManagerSession.identityDelegate.isIdentityANotOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                oneToOne = false;
            } else {
                return new FinishedState();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new OneToOneStatusSyncRequestMessage(coreProtocolMessage, oneToOne).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class BobProcessesSyncRequestStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final OneToOneStatusSyncRequestMessage receivedMessage;

        public BobProcessesSyncRequestStep(InitialProtocolState startState, OneToOneStatusSyncRequestMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            boolean aliceIsOneToOne;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                aliceIsOneToOne = true;
            } else if (protocolManagerSession.identityDelegate.isIdentityANotOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                aliceIsOneToOne = false;
            } else {
                return new FinishedState();
            }
            if (aliceIsOneToOne != this.receivedMessage.aliceConsidersBobAsOneToOne) {
                if (aliceIsOneToOne) {
                    protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), false);
                } else {
                    WaitingForOneToOneContactProtocolInstance[] waitingForOneToOneContactProtocolInstances;
                    for (WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance : waitingForOneToOneContactProtocolInstances = WaitingForOneToOneContactProtocolInstance.getAllForContact(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                        ProtocolInstance protocolInstance;
                        if (waitingForOneToOneContactProtocolInstance.getProtocolId() != this.getProtocolId() || (protocolInstance = ProtocolInstance.get(protocolManagerSession, waitingForOneToOneContactProtocolInstance.getProtocolUid(), this.getOwnedIdentity())) == null || protocolInstance.getCurrentStateId() != 1) continue;
                        protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), true);
                        return new FinishedState();
                    }
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity()), this.getProtocolId(), new UID(this.getPrng()));
                    ChannelProtocolMessageToSend messageToSend = new OneToOneStatusSyncRequestMessage(coreProtocolMessage, false).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            return new FinishedState();
        }
    }

    public static class AliceReceivesBobsResponseStep
    extends ProtocolStep {
        private final InvitationSentState startState;
        private final OneToOneResponseMessage receivedMessage;

        public AliceReceivesBobsResponseStep(InvitationSentState startState, OneToOneResponseMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.contactIdentity.equals(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                Logger.e("Contact identity mismatch in AliceReceivesBobsResponseStep: ignoring message.");
                return this.startState;
            }
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, this.receivedMessage.invitationAccepted);
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class ProcessContactUpgradedToOneToOneStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final Identity contactIdentity;
        private final UUID dialogUuid;
        private final ContactUpgradedToOneToOneMessage receivedMessage;

        public ProcessContactUpgradedToOneToOneStep(InvitationSentState startState, ContactUpgradedToOneToOneMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.contactIdentity = startState.contactIdentity;
            this.dialogUuid = startState.dialogUuid;
            this.receivedMessage = receivedMessage;
        }

        public ProcessContactUpgradedToOneToOneStep(InvitationReceivedState startState, ContactUpgradedToOneToOneMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.contactIdentity = startState.contactIdentity;
            this.dialogUuid = startState.dialogUuid;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.contactIdentity)) {
                return this.startState;
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class AliceProcessesPropagatedAbortStep
    extends ProtocolStep {
        private final InvitationSentState startState;
        private final PropagateAbortMessage receivedMessage;

        public AliceProcessesPropagatedAbortStep(InvitationSentState startState, PropagateAbortMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class BobRespondsToAlicesInvitationStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final DialogAcceptOneToOneInvitationMessage receivedMessage;

        public BobRespondsToAlicesInvitationStep(InvitationReceivedState startState, DialogAcceptOneToOneInvitationMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.startState.contactIdentity, this.getOwnedIdentity()));
                messageToSend = new OneToOneResponseMessage(coreProtocolMessage, this.receivedMessage.invitationAccepted).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, this.receivedMessage.invitationAccepted);
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.receivedMessage.dialogUuid));
            messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateOneToOneResponseMessage(coreProtocolMessage2, this.receivedMessage.invitationAccepted).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinishedState();
        }
    }

    public static class BobProcessesAbortStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final AbortMessage receivedMessage;

        public BobProcessesAbortStep(InvitationReceivedState startState, AbortMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.contactIdentity.equals(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                Logger.e("Contact identity mismatch in BobProcessesAbortStep: ignoring message.");
                return this.startState;
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }

    public static class BobProcessesPropagatedResponseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final PropagateOneToOneResponseMessage receivedMessage;

        public BobProcessesPropagatedResponseStep(InvitationReceivedState startState, PropagateOneToOneResponseMessage receivedMessage, OneToOneContactInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.identityDelegate.setContactOneToOne(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, this.receivedMessage.invitationAccepted);
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedState();
        }
    }
}

