/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.IdentityDetailsPublicationProtocol;
import java.util.HashMap;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public class KeycloakBindingAndUnbindingProtocol
extends ConcreteProtocol {
    public static final int FINISHED_STATED_ID = 1;
    static final int OWNED_IDENTITY_KEYCLOAK_BINDING_MESSAGE_ID = 0;
    static final int OWNED_IDENTITY_KEYCLOAK_UNBINDING_MESSAGE_ID = 1;
    static final int PROPAGATE_KEYCLOAK_BINDING_MESSAGE_ID = 2;
    static final int PROPAGATE_KEYCLOAK_UNBINDING_MESSAGE_ID = 3;

    public KeycloakBindingAndUnbindingProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 23;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return FinishedProtocolState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return OwnedIdentityKeycloakBindingMessage.class;
            }
            case 1: {
                return OwnedIdentityKeycloakUnbindingMessage.class;
            }
            case 2: {
                return PropagateKeycloakBindingMessage.class;
            }
            case 3: {
                return PropagateKeycloakUnbindingMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{OwnedIdentityKeycloakBindingStep.class, OwnedIdentityKeycloakUnbindingStep.class};
            }
        }
        return new Class[0];
    }

    public static class FinishedProtocolState
    extends ConcreteProtocolState {
        public FinishedProtocolState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedProtocolState() {
            super(4);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class OwnedIdentityKeycloakBindingMessage
    extends ConcreteProtocolMessage {
        private final ObvKeycloakState keycloakState;
        private final String keycloakUserId;

        public OwnedIdentityKeycloakBindingMessage(CoreProtocolMessage coreProtocolMessage, ObvKeycloakState keycloakState, String keycloakUserId) {
            super(coreProtocolMessage);
            this.keycloakState = keycloakState;
            this.keycloakUserId = keycloakUserId;
        }

        public OwnedIdentityKeycloakBindingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.keycloakState = ObvKeycloakState.of(receivedMessage.getInputs()[0]);
            this.keycloakUserId = receivedMessage.getInputs()[1].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.keycloakState.encode(), Encoded.of(this.keycloakUserId)};
        }
    }

    public static class OwnedIdentityKeycloakUnbindingMessage
    extends ConcreteProtocolMessage {
        public OwnedIdentityKeycloakUnbindingMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public OwnedIdentityKeycloakUnbindingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateKeycloakBindingMessage
    extends ConcreteProtocolMessage {
        public final String keycloakUserId;
        public final String keycloakServer;
        public final String clientId;
        public final String clientSecret;
        public final String jwks;
        public final String signatureKey;

        public PropagateKeycloakBindingMessage(CoreProtocolMessage coreProtocolMessage, String keycloakUserId, ObvKeycloakState keycloakState) {
            super(coreProtocolMessage);
            this.keycloakUserId = keycloakUserId;
            this.keycloakServer = keycloakState.keycloakServer;
            this.clientId = keycloakState.clientId;
            this.clientSecret = keycloakState.clientSecret;
            this.jwks = keycloakState.jwks.toJson();
            this.signatureKey = keycloakState.signatureKey.toJson();
        }

        public PropagateKeycloakBindingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 6) {
                throw new Exception();
            }
            this.keycloakUserId = receivedMessage.getInputs()[0].decodeString();
            this.keycloakServer = receivedMessage.getInputs()[1].decodeString();
            this.clientId = receivedMessage.getInputs()[2].decodeString();
            String clientSecret = receivedMessage.getInputs()[3].decodeString();
            this.clientSecret = clientSecret.isEmpty() ? null : clientSecret;
            this.jwks = receivedMessage.getInputs()[4].decodeString();
            this.signatureKey = receivedMessage.getInputs()[5].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.keycloakUserId), Encoded.of(this.keycloakServer), Encoded.of(this.clientId), Encoded.of(this.clientSecret == null ? "" : this.clientSecret), Encoded.of(this.jwks), Encoded.of(this.signatureKey)};
        }
    }

    public static class PropagateKeycloakUnbindingMessage
    extends ConcreteProtocolMessage {
        public PropagateKeycloakUnbindingMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public PropagateKeycloakUnbindingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class OwnedIdentityKeycloakBindingStep
    extends ProtocolStep {
        InitialProtocolState startState;
        String keycloakUserId;
        ObvKeycloakState keycloakState;
        boolean propagationNeeded;

        public OwnedIdentityKeycloakBindingStep(InitialProtocolState startState, OwnedIdentityKeycloakBindingMessage receivedMessage, KeycloakBindingAndUnbindingProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.keycloakUserId = receivedMessage.keycloakUserId;
            this.keycloakState = receivedMessage.keycloakState;
            this.propagationNeeded = true;
        }

        public OwnedIdentityKeycloakBindingStep(InitialProtocolState startState, PropagateKeycloakBindingMessage receivedMessage, KeycloakBindingAndUnbindingProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.keycloakUserId = receivedMessage.keycloakUserId;
            this.keycloakState = new ObvKeycloakState(receivedMessage.keycloakServer, receivedMessage.clientId, receivedMessage.clientSecret, new JsonWebKeySet(receivedMessage.jwks), JsonWebKey.Factory.newJwk((String)receivedMessage.signatureKey), null, false, null, 0L, 0L);
            this.propagationNeeded = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.keycloakUserId == null || this.keycloakState == null || this.keycloakState.keycloakServer == null || this.keycloakState.jwks == null) {
                Logger.w("Bad inputs for OwnedIdentityKeycloakBindingStep, aborting.");
                return new FinishedProtocolState();
            }
            protocolManagerSession.identityDelegate.bindOwnedIdentityToKeycloak(protocolManagerSession.session, this.getOwnedIdentity(), this.keycloakUserId, this.keycloakState);
            protocolManagerSession.identityDelegate.reCheckAllCertifiedByOwnKeycloakContacts(protocolManagerSession.session, this.getOwnedIdentity());
            if (this.propagationNeeded) {
                int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
                if (numberOfOtherDevices > 0) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                        ChannelProtocolMessageToSend messageToSend = new PropagateKeycloakBindingMessage(coreProtocolMessage, this.keycloakUserId, this.keycloakState).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (NoAcceptableChannelException noAcceptableChannelException) {}
                }
            } else {
                protocolManagerSession.session.addSessionCommitListener(() -> {
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", this.getOwnedIdentity());
                    protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_keycloak_synchronization_required", userInfo);
                });
            }
            return new FinishedProtocolState();
        }
    }

    public static class OwnedIdentityKeycloakUnbindingStep
    extends ProtocolStep {
        InitialProtocolState startState;
        boolean propagationNeeded;

        public OwnedIdentityKeycloakUnbindingStep(InitialProtocolState startState, OwnedIdentityKeycloakUnbindingMessage receivedMessage, KeycloakBindingAndUnbindingProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.propagationNeeded = true;
        }

        public OwnedIdentityKeycloakUnbindingStep(InitialProtocolState startState, PropagateKeycloakUnbindingMessage receivedMessage, KeycloakBindingAndUnbindingProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.propagationNeeded = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            int version = protocolManagerSession.identityDelegate.unbindOwnedIdentityFromKeycloak(protocolManagerSession.session, this.getOwnedIdentity());
            if (version == -2) {
                throw new Exception();
            }
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 6, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new IdentityDetailsPublicationProtocol.InitialMessage(coreProtocolMessage, version).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            protocolManagerSession.identityDelegate.unmarkAllCertifiedByOwnKeycloakContacts(protocolManagerSession.session, this.getOwnedIdentity());
            if (this.propagationNeeded && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    messageToSend = new PropagateKeycloakUnbindingMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinishedProtocolState();
        }
    }
}

