/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DownloadIdentityPhotoChildProtocol;
import java.util.Arrays;

public class IdentityDetailsPublicationProtocol
extends ConcreteProtocol {
    public static final int UPLOADING_PHOTO_STATE_ID = 1;
    public static final int DETAILS_SENT_STATE_ID = 2;
    public static final int DETAILS_RECEIVED_STATE_ID = 3;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int SERVER_PUT_PHOTO_MESSAGE_ID = 1;
    public static final int SEND_DETAILS_MESSAGE_ID = 2;
    public static final int PROPAGATE_OWN_DETAILS_MESSAGE_ID = 3;

    public IdentityDetailsPublicationProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 6;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{2, 3};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return UploadingPhotoState.class;
            }
            case 2: {
                return DetailsSentState.class;
            }
            case 3: {
                return DetailsReceivedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ServerPutPhotoMessage.class;
            }
            case 2: {
                return SendDetailsMessage.class;
            }
            case 3: {
                return PropagateOwnDetailsMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{StartPhotoUploadStep.class, ReceiveDetailsStep.class, ReceiveOwnDetailsStep.class};
            }
            case 1: {
                return new Class[]{SendDetailsStep.class};
            }
        }
        return new Class[0];
    }

    public static class UploadingPhotoState
    extends ConcreteProtocolState {
        private final String jsonIdentityDetailsWithVersionAndPhoto;

        public UploadingPhotoState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.jsonIdentityDetailsWithVersionAndPhoto = list[0].decodeString();
        }

        public UploadingPhotoState(String jsonIdentityDetailsWithVersionAndPhoto) {
            super(1);
            this.jsonIdentityDetailsWithVersionAndPhoto = jsonIdentityDetailsWithVersionAndPhoto;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.jsonIdentityDetailsWithVersionAndPhoto)});
        }
    }

    public static class DetailsSentState
    extends ConcreteProtocolState {
        public DetailsSentState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public DetailsSentState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class DetailsReceivedState
    extends ConcreteProtocolState {
        public DetailsReceivedState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public DetailsReceivedState() {
            super(3);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final int version;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, int version) {
            super(coreProtocolMessage);
            this.version = version;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.version = (int)receivedMessage.getInputs()[0].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.version)};
        }
    }

    public static class ServerPutPhotoMessage
    extends ConcreteProtocolMessage {
        private ServerPutPhotoMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public ServerPutPhotoMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() != null) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class SendDetailsMessage
    extends ConcreteProtocolMessage {
        private final String jsonIdentityDetailsWithVersionAndPhoto;

        public SendDetailsMessage(CoreProtocolMessage coreProtocolMessage, String jsonIdentityDetailsWithVersionAndPhoto) {
            super(coreProtocolMessage);
            this.jsonIdentityDetailsWithVersionAndPhoto = jsonIdentityDetailsWithVersionAndPhoto;
        }

        public SendDetailsMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.jsonIdentityDetailsWithVersionAndPhoto = receivedMessage.getInputs()[0].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.jsonIdentityDetailsWithVersionAndPhoto)};
        }
    }

    public static class PropagateOwnDetailsMessage
    extends ConcreteProtocolMessage {
        private final String jsonIdentityDetailsWithVersionAndPhoto;

        public PropagateOwnDetailsMessage(CoreProtocolMessage coreProtocolMessage, String jsonIdentityDetailsWithVersionAndPhoto) {
            super(coreProtocolMessage);
            this.jsonIdentityDetailsWithVersionAndPhoto = jsonIdentityDetailsWithVersionAndPhoto;
        }

        public PropagateOwnDetailsMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.jsonIdentityDetailsWithVersionAndPhoto = receivedMessage.getInputs()[0].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.jsonIdentityDetailsWithVersionAndPhoto)};
        }
    }

    public static class StartPhotoUploadStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public StartPhotoUploadStep(InitialProtocolState startState, InitialMessage receivedMessage, IdentityDetailsPublicationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity ownedIdentity = this.getOwnedIdentity();
            JsonIdentityDetailsWithVersionAndPhoto[] jsons = protocolManagerSession.identityDelegate.getOwnedIdentityPublishedAndLatestDetails(protocolManagerSession.session, ownedIdentity);
            if (jsons == null) {
                return null;
            }
            if (jsons[0].getVersion() != this.receivedMessage.version) {
                Logger.i("Version mismatch in IdentityDetailsPublicationProtocol " + jsons[0].getVersion() + " " + this.receivedMessage.version);
                return null;
            }
            JsonIdentityDetailsWithVersionAndPhoto publishedDetails = jsons[0];
            if (publishedDetails.getPhotoUrl() != null && (publishedDetails.getPhotoServerLabel() == null || publishedDetails.getPhotoServerKey() == null)) {
                UID photoServerLabel = new UID(this.getPrng());
                AuthEnc authEnc = Suite.getDefaultAuthEnc(0);
                AuthEncKey photoServerKey = authEnc.generateKey(this.getPrng());
                publishedDetails.setPhotoServerKey(Encoded.of(photoServerKey).getBytes());
                publishedDetails.setPhotoServerLabel(photoServerLabel.getBytes());
                protocolManagerSession.identityDelegate.setOwnedIdentityDetailsServerLabelAndKey(protocolManagerSession.session, ownedIdentity, publishedDetails.getVersion(), photoServerLabel, photoServerKey);
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(ownedIdentity, new ServerQuery.PutUserDataQuery(ownedIdentity, photoServerLabel, publishedDetails.getPhotoUrl(), photoServerKey)));
                ChannelServerQueryMessageToSend messageToSend = new ServerPutPhotoMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                String jsonPublishedDetails = this.protocol.getJsonObjectMapper().writeValueAsString((Object)publishedDetails);
                return new UploadingPhotoState(jsonPublishedDetails);
            }
            String jsonPublishedDetails = this.protocol.getJsonObjectMapper().writeValueAsString((Object)publishedDetails);
            Identity[] contactIdentities = protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, ownedIdentity);
            if (contactIdentities.length > 0) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(contactIdentities, ownedIdentity)) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend = new SendDetailsMessage(coreProtocolMessage, jsonPublishedDetails).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception e) {
                        Logger.d("One contact with no channel during IdentityDetailsPublicationProtocol.StartPhotoUploadStep");
                    }
                }
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage noAcceptableChannelException = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateOwnDetailsMessage(noAcceptableChannelException, jsonPublishedDetails).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new DetailsSentState();
        }
    }

    public static class ReceiveDetailsStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final SendDetailsMessage receivedMessage;

        public ReceiveDetailsStep(InitialProtocolState startState, SendDetailsMessage receivedMessage, IdentityDetailsPublicationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity contactIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            Identity ownedIdentity = this.getOwnedIdentity();
            JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto = (JsonIdentityDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.jsonIdentityDetailsWithVersionAndPhoto, JsonIdentityDetailsWithVersionAndPhoto.class);
            if (jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel() != null && jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() != null) {
                JsonIdentityDetailsWithVersionAndPhoto publishedDetails = protocolManagerSession.identityDelegate.getContactPublishedAndTrustedDetails(protocolManagerSession.session, ownedIdentity, contactIdentity)[0];
                if (!(Arrays.equals(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel(), publishedDetails.getPhotoServerLabel()) && (jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() == null && publishedDetails.getPhotoServerKey() == null || jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() != null && publishedDetails.getPhotoServerKey() != null && new Encoded(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey().equals(new Encoded(publishedDetails.getPhotoServerKey()).decodeSymmetricKey())) && publishedDetails.getPhotoUrl() != null)) {
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 7, new UID(this.getPrng()));
                    ChannelProtocolMessageToSend messageToSend = new DownloadIdentityPhotoChildProtocol.InitialMessage(coreProtocolMessage, contactIdentity, this.receivedMessage.jsonIdentityDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            protocolManagerSession.identityDelegate.setContactPublishedDetails(protocolManagerSession.session, contactIdentity, ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto, false);
            return new DetailsReceivedState();
        }
    }

    public static class ReceiveOwnDetailsStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateOwnDetailsMessage receivedMessage;

        public ReceiveOwnDetailsStep(InitialProtocolState startState, PropagateOwnDetailsMessage receivedMessage, IdentityDetailsPublicationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            JsonIdentityDetailsWithVersionAndPhoto ownDetailsWithVersionAndPhoto;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity ownedIdentity = this.getOwnedIdentity();
            boolean photoDownloadNeeded = protocolManagerSession.identityDelegate.setOwnedIdentityDetailsFromOtherDevice(protocolManagerSession.session, ownedIdentity, ownDetailsWithVersionAndPhoto = (JsonIdentityDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.jsonIdentityDetailsWithVersionAndPhoto, JsonIdentityDetailsWithVersionAndPhoto.class));
            if (photoDownloadNeeded) {
                protocolManagerSession.identityDelegate.createOwnedIdentityServerUserData(protocolManagerSession.session, this.getOwnedIdentity(), new UID(ownDetailsWithVersionAndPhoto.getPhotoServerLabel()));
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 7, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DownloadIdentityPhotoChildProtocol.InitialMessage(coreProtocolMessage, this.getOwnedIdentity(), this.receivedMessage.jsonIdentityDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new DetailsReceivedState();
        }
    }

    public static class SendDetailsStep
    extends ProtocolStep {
        private final UploadingPhotoState startState;
        private final ServerPutPhotoMessage receivedMessage;

        public SendDetailsStep(UploadingPhotoState startState, ServerPutPhotoMessage receivedMessage, IdentityDetailsPublicationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity[] contactIdentities = protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (contactIdentities.length > 0) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(contactIdentities, this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend = new SendDetailsMessage(coreProtocolMessage, this.startState.jsonIdentityDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception e) {
                        Logger.d("One contact with no channel during IdentityDetailsPublicationProtocol.SendDetailsStep");
                    }
                }
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateOwnDetailsMessage(coreProtocolMessage, this.startState.jsonIdentityDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new DetailsSentState();
        }
    }
}

