/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.GroupMembersChangedCallback;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.Group;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DownloadGroupPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.GroupInvitationProtocol;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public class GroupManagementProtocol
extends ConcreteProtocol {
    static final int FINAL_STATE_ID = 1;
    private static final int INITIATE_GROUP_CREATION_MESSAGE_ID = 0;
    private static final int PROPAGATE_GROUP_CREATION_MESSAGE_ID = 1;
    private static final int GROUP_MEMBERS_CHANGED_TRIGGER_MESSAGE_ID = 2;
    private static final int NEW_MEMBERS_MESSAGE_ID = 3;
    private static final int ADD_GROUP_MEMBERS_MESSAGE_ID = 4;
    private static final int REMOVE_GROUP_MEMBERS_MESSAGE_ID = 5;
    private static final int KICK_FROM_GROUP_MESSAGE_ID = 6;
    private static final int NOTIFY_GROUP_LEFT_MESSAGE_ID = 7;
    private static final int REINVITE_PENDING_MEMBER_MESSAGE_ID = 8;
    private static final int DISBAND_GROUP_MESSAGE_ID = 9;
    private static final int LEAVE_GROUP_MESSAGE_ID = 10;
    private static final int INITIATE_GROUP_MEMBERS_QUERY_MESSAGE_ID = 11;
    private static final int QUERY_GROUP_MEMBERS_MESSAGE_ID = 12;
    private static final int TRIGGER_REINVITE_MESSAGE_ID = 13;
    private static final int TRIGGER_UPDATE_MEMBERS_MESSAGE_ID = 14;
    private static final int UPLOAD_GROUP_PHOTO_MESSAGE_MESSAGE_ID = 15;
    private static final int PROPAGATE_REINVITE_PENDING_MEMBER_MESSAGE_ID = 16;
    private static final int PROPAGATE_DISBAND_GROUP_MESSAGE_ID = 17;
    private static final int PROPAGATE_LEAVE_GROUP_MESSAGE_ID = 18;

    public GroupManagementProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.eraseReceivedMessagesAfterReachingAFinalState = false;
    }

    @Override
    public int getProtocolId() {
        return 9;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return FinalState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitiateGroupCreationMessage.class;
            }
            case 1: {
                return PropagateGroupCreationMessage.class;
            }
            case 2: {
                return GroupMembersOrDetailsChangedTriggerMessage.class;
            }
            case 3: {
                return NewMembersMessage.class;
            }
            case 4: {
                return AddGroupMembersMessage.class;
            }
            case 5: {
                return RemoveGroupMembersMessage.class;
            }
            case 6: {
                return KickFromGroupMessage.class;
            }
            case 8: {
                return ReinvitePendingMemberMessage.class;
            }
            case 9: {
                return DisbandGroupMessage.class;
            }
            case 10: {
                return LeaveGroupMessage.class;
            }
            case 7: {
                return NotifyGroupLeftMessage.class;
            }
            case 11: {
                return InitiateGroupMembersQueryMessage.class;
            }
            case 12: {
                return QueryGroupMembersMessage.class;
            }
            case 13: {
                return TriggerReinviteMessage.class;
            }
            case 14: {
                return TriggerUpdateMembersMessage.class;
            }
            case 15: {
                return UploadGroupPhotoMessage.class;
            }
            case 16: {
                return PropagateReinvitePendingMemberMessage.class;
            }
            case 17: {
                return PropagateDisbandGroupMessage.class;
            }
            case 18: {
                return PropagateLeaveGroupMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        if (stateId == 0) {
            return new Class[]{InitiateGroupCreationStep.class, ProcessPropagateGroupCreationMessage.class, NotifyMembersChangedStep.class, ProcessNewMembersStep.class, AddGroupMembersStep.class, RemoveGroupMembersStep.class, GetKickedStep.class, ReinvitePendingMemberStep.class, ProcessPropagateReinvitePendingMemberStep.class, DisbandGroupStep.class, ProcessPropagateDisbandGroupMessageStep.class, LeaveGroupStep.class, ProcessPropagateLeaveGroupMessageStep.class, ProcessGroupLeftStep.class, QueryGroupMembersStep.class, SendGroupMembersStep.class, ReinviteStep.class, UpdateMembersStep.class};
        }
        return new Class[0];
    }

    public static class FinalState
    extends ConcreteProtocolState {
        public FinalState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        FinalState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitiateGroupCreationMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;
        private final String absolutePhotoUrl;

        public InitiateGroupCreationMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, String absolutePhotoUrl, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
            this.absolutePhotoUrl = absolutePhotoUrl;
        }

        public InitiateGroupCreationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[1].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
            this.absolutePhotoUrl = receivedMessage.getInputs()[2].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodeds = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodeds[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodeds), this.absolutePhotoUrl == null ? Encoded.of("") : Encoded.of(this.absolutePhotoUrl)};
        }
    }

    public static class PropagateGroupCreationMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;

        PropagateGroupCreationMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
        }

        public PropagateGroupCreationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[1].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodeds = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodeds[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodeds)};
        }
    }

    public static class GroupMembersOrDetailsChangedTriggerMessage
    extends GroupInformationOnlyMessage {
        public GroupMembersOrDetailsChangedTriggerMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public GroupMembersOrDetailsChangedTriggerMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }
    }

    public static class NewMembersMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;
        private final HashSet<IdentityWithSerializedDetails> pendingMemberIdentitiesAndSerializedDetails;
        private final long membersVersion;

        public NewMembersMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails, HashSet<IdentityWithSerializedDetails> pendingMemberIdentitiesAndSerializedDetails, long membersVersion) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
            this.pendingMemberIdentitiesAndSerializedDetails = pendingMemberIdentitiesAndSerializedDetails;
            this.membersVersion = membersVersion;
        }

        public NewMembersMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[1].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
            this.pendingMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[2].decodeList()) {
                this.pendingMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
            this.membersVersion = receivedMessage.getInputs()[3].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodedMembers = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodedMembers[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            Encoded[] encodedPendings = new Encoded[this.pendingMemberIdentitiesAndSerializedDetails.size()];
            i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.pendingMemberIdentitiesAndSerializedDetails) {
                encodedPendings[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodedMembers), Encoded.of(encodedPendings), Encoded.of(this.membersVersion)};
        }
    }

    public static class AddGroupMembersMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<Identity> newMembersIdentity;

        public AddGroupMembersMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, HashSet<Identity> newMembersIdentity) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.newMembersIdentity = newMembersIdentity;
        }

        public AddGroupMembersMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.newMembersIdentity = new HashSet();
            for (Encoded encodedIdentity : receivedMessage.getInputs()[1].decodeList()) {
                this.newMembersIdentity.add(encodedIdentity.decodeIdentity());
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodedMembers = new Encoded[this.newMembersIdentity.size()];
            int i = 0;
            for (Identity identity : this.newMembersIdentity) {
                encodedMembers[i] = Encoded.of(identity);
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodedMembers)};
        }
    }

    public static class RemoveGroupMembersMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<Identity> removedMemberIdentities;

        public RemoveGroupMembersMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, HashSet<Identity> removedMemberIdentities) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.removedMemberIdentities = removedMemberIdentities;
        }

        public RemoveGroupMembersMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.removedMemberIdentities = new HashSet();
            for (Encoded encodedIdentity : receivedMessage.getInputs()[1].decodeList()) {
                this.removedMemberIdentities.add(encodedIdentity.decodeIdentity());
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodedMembers = new Encoded[this.removedMemberIdentities.size()];
            int i = 0;
            for (Identity identity : this.removedMemberIdentities) {
                encodedMembers[i] = Encoded.of(identity);
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodedMembers)};
        }
    }

    public static class KickFromGroupMessage
    extends GroupInformationOnlyMessage {
        public KickFromGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public KickFromGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }
    }

    public static class ReinvitePendingMemberMessage
    extends ConcreteProtocolMessage {
        protected final GroupInformation groupInformation;
        protected final Identity pendingMemberIdentity;

        public ReinvitePendingMemberMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, Identity pendingMemberIdentity) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.pendingMemberIdentity = pendingMemberIdentity;
        }

        public ReinvitePendingMemberMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.pendingMemberIdentity = receivedMessage.getInputs()[1].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 8;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(this.pendingMemberIdentity)};
        }
    }

    public static class DisbandGroupMessage
    extends GroupInformationOnlyMessage {
        public DisbandGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public DisbandGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }
    }

    public static class LeaveGroupMessage
    extends GroupInformationOnlyMessage {
        public LeaveGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public LeaveGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 10;
        }
    }

    public static class NotifyGroupLeftMessage
    extends GroupInformationOnlyMessage {
        public NotifyGroupLeftMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public NotifyGroupLeftMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 7;
        }
    }

    public static class InitiateGroupMembersQueryMessage
    extends GroupInformationOnlyMessage {
        public InitiateGroupMembersQueryMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public InitiateGroupMembersQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 11;
        }
    }

    public static class QueryGroupMembersMessage
    extends GroupInformationOnlyMessage {
        public QueryGroupMembersMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public QueryGroupMembersMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 12;
        }
    }

    public static class TriggerReinviteMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final Identity memberIdentity;

        public TriggerReinviteMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, Identity memberIdentity) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.memberIdentity = memberIdentity;
        }

        public TriggerReinviteMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.memberIdentity = receivedMessage.getInputs()[1].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 13;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(this.memberIdentity)};
        }
    }

    public static class TriggerUpdateMembersMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final Identity memberIdentity;

        public TriggerUpdateMembersMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, Identity memberIdentity) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.memberIdentity = memberIdentity;
        }

        public TriggerUpdateMembersMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.memberIdentity = receivedMessage.getInputs()[1].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 14;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(this.memberIdentity)};
        }
    }

    public static class UploadGroupPhotoMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;

        private UploadGroupPhotoMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
        }

        public UploadGroupPhotoMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() != null) {
                throw new Exception();
            }
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 15;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupInformation.encode()};
        }
    }

    public static class PropagateReinvitePendingMemberMessage
    extends ReinvitePendingMemberMessage {
        public PropagateReinvitePendingMemberMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, Identity pendingMemberIdentity) {
            super(coreProtocolMessage, groupInformation, pendingMemberIdentity);
        }

        public PropagateReinvitePendingMemberMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 16;
        }
    }

    public static class PropagateDisbandGroupMessage
    extends GroupInformationOnlyMessage {
        public PropagateDisbandGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public PropagateDisbandGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 17;
        }
    }

    public static class PropagateLeaveGroupMessage
    extends GroupInformationOnlyMessage {
        public PropagateLeaveGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage, groupInformation);
        }

        public PropagateLeaveGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 18;
        }
    }

    public static class InitiateGroupCreationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateGroupCreationMessage receivedMessage;

        public InitiateGroupCreationStep(InitialProtocolState startState, InitiateGroupCreationMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(this.getOwnedIdentity(), ""))) {
                Logger.w("Error: the groupMemberIdentitiesAndSerializedDetails contains the ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            GroupInformation groupInformation = this.receivedMessage.groupInformation;
            protocolManagerSession.identityDelegate.createContactGroup(protocolManagerSession.session, this.getOwnedIdentity(), groupInformation, new Identity[0], this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.toArray(new IdentityWithSerializedDetails[0]), false);
            if (this.receivedMessage.absolutePhotoUrl != null && this.receivedMessage.absolutePhotoUrl.length() > 0) {
                try {
                    protocolManagerSession.identityDelegate.updateOwnedGroupPhoto(protocolManagerSession.session, this.getOwnedIdentity(), groupInformation.getGroupOwnerAndUid(), this.receivedMessage.absolutePhotoUrl, true);
                    JsonGroupDetailsWithVersionAndPhoto publishedDetails = protocolManagerSession.identityDelegate.getGroupPublishedAndLatestOrTrustedDetails(protocolManagerSession.session, this.getOwnedIdentity(), groupInformation.getGroupOwnerAndUid())[0];
                    UID photoServerLabel = new UID(this.getPrng());
                    AuthEnc authEnc = Suite.getDefaultAuthEnc(0);
                    AuthEncKey photoServerKey = authEnc.generateKey(this.getPrng());
                    publishedDetails.setPhotoServerKey(Encoded.of(photoServerKey).getBytes());
                    publishedDetails.setPhotoServerLabel(photoServerLabel.getBytes());
                    String serializedGroupDetailsWithVersionAndPhoto = this.protocol.getJsonObjectMapper().writeValueAsString((Object)publishedDetails);
                    groupInformation = new GroupInformation(groupInformation.groupOwnerIdentity, groupInformation.groupUid, serializedGroupDetailsWithVersionAndPhoto);
                    protocolManagerSession.identityDelegate.setOwnedGroupDetailsServerLabelAndKey(protocolManagerSession.session, this.getOwnedIdentity(), groupInformation.getGroupOwnerAndUid(), publishedDetails.getVersion(), photoServerLabel, photoServerKey);
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutUserDataQuery(this.getOwnedIdentity(), photoServerLabel, publishedDetails.getPhotoUrl(), photoServerKey)));
                    ChannelServerQueryMessageToSend messageToSend = new UploadGroupPhotoMessage(coreProtocolMessage, groupInformation).generateChannelServerQueryMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (Exception publishedDetails) {
                    // empty catch block
                }
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateGroupCreationMessage(coreProtocolMessage, groupInformation, this.receivedMessage.groupMemberIdentitiesAndSerializedDetails).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.receivedMessage.groupMemberIdentitiesAndSerializedDetails) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 8, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new GroupInvitationProtocol.InitialMessage(coreProtocolMessage, identityWithSerializedDetails.identity, groupInformation, this.receivedMessage.groupMemberIdentitiesAndSerializedDetails).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class ProcessPropagateGroupCreationMessage
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateGroupCreationMessage receivedMessage;

        public ProcessPropagateGroupCreationMessage(InitialProtocolState startState, PropagateGroupCreationMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(this.getOwnedIdentity(), ""))) {
                Logger.w("Error: the groupMemberIdentitiesAndSerializedDetails contains the ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            protocolManagerSession.identityDelegate.createContactGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation, new Identity[0], this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.toArray(new IdentityWithSerializedDetails[0]), true);
            JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
            if (jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel() != null && jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() != null) {
                protocolManagerSession.identityDelegate.createGroupV1ServerUserData(protocolManagerSession.session, this.getOwnedIdentity(), new UID(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel()), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 14, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DownloadGroupPhotoChildProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class NotifyMembersChangedStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final GroupInformation groupInformation;

        public NotifyMembersChangedStep(InitialProtocolState startState, GroupMembersOrDetailsChangedTriggerMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupInformation = receivedMessage.groupInformation;
        }

        public NotifyMembersChangedStep(InitialProtocolState startState, UploadGroupPhotoMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupInformation = receivedMessage.groupInformation;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            Identity[] recipientIdentities;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            JsonGroupDetailsWithVersionAndPhoto groupInfoDetails = (JsonGroupDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
            JsonGroupDetailsWithVersionAndPhoto publishedDetails = protocolManagerSession.identityDelegate.getGroupPublishedAndLatestOrTrustedDetails(protocolManagerSession.session, this.getOwnedIdentity(), this.groupInformation.getGroupOwnerAndUid())[0];
            if (publishedDetails.getVersion() == groupInfoDetails.getVersion() && publishedDetails.getPhotoUrl() != null && (publishedDetails.getPhotoServerLabel() == null || publishedDetails.getPhotoServerKey() == null)) {
                UID photoServerLabel = new UID(this.getPrng());
                AuthEnc authEnc = Suite.getDefaultAuthEnc(0);
                AuthEncKey photoServerKey = authEnc.generateKey(this.getPrng());
                publishedDetails.setPhotoServerKey(Encoded.of(photoServerKey).getBytes());
                publishedDetails.setPhotoServerLabel(photoServerLabel.getBytes());
                String serializedGroupDetailsWithVersionAndPhoto = this.protocol.getJsonObjectMapper().writeValueAsString((Object)publishedDetails);
                GroupInformation groupInformationWithKeyAndLabel = new GroupInformation(this.groupInformation.groupOwnerIdentity, this.groupInformation.groupUid, serializedGroupDetailsWithVersionAndPhoto);
                protocolManagerSession.identityDelegate.setOwnedGroupDetailsServerLabelAndKey(protocolManagerSession.session, this.getOwnedIdentity(), this.groupInformation.getGroupOwnerAndUid(), publishedDetails.getVersion(), photoServerLabel, photoServerKey);
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutUserDataQuery(this.getOwnedIdentity(), photoServerLabel, publishedDetails.getPhotoUrl(), photoServerKey)));
                ChannelServerQueryMessageToSend messageToSend = new UploadGroupPhotoMessage(coreProtocolMessage, groupInformationWithKeyAndLabel).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinalState();
            }
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.groupInformation.getGroupOwnerAndUid());
            HashSet<IdentityWithSerializedDetails> groupMembers = new HashSet<IdentityWithSerializedDetails>();
            HashSet<IdentityWithSerializedDetails> pendingMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity memberIdentity : group.getGroupMembers()) {
                groupMembers.add(new IdentityWithSerializedDetails(memberIdentity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), memberIdentity)));
            }
            groupMembers.add(new IdentityWithSerializedDetails(this.getOwnedIdentity(), protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())));
            if (protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length > 0) {
                recipientIdentities = new Identity[group.getGroupMembers().length + 1];
                recipientIdentities[0] = this.getOwnedIdentity();
                System.arraycopy(group.getGroupMembers(), 0, recipientIdentities, 1, group.getGroupMembers().length);
            } else {
                recipientIdentities = group.getGroupMembers();
            }
            if (recipientIdentities.length > 0) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(recipientIdentities, this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend = new NewMembersMessage(coreProtocolMessage, this.groupInformation, groupMembers, pendingMembers, group.getGroupMembersVersion()).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return new FinalState();
        }
    }

    public static class ProcessNewMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final NewMembersMessage receivedMessage;

        public ProcessNewMembersStep(InitialProtocolState startState, NewMembersMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                Logger.w("Error: NewMembersMessage not received from the group owner");
                return null;
            }
            boolean receivedFromOtherOwnedDevice = Objects.equals(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity());
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                return null;
            }
            if (!receivedFromOtherOwnedDevice && group.getGroupOwner() == null) {
                Logger.w("Error: received a NewMembersMessage from someone else for a group you own");
                return null;
            }
            if (receivedFromOtherOwnedDevice && group.getGroupOwner() != null) {
                Logger.w("Error: received a NewMembersMessage from another owned device and for a group you do not own");
                return null;
            }
            if (group.getGroupMembersVersion() > this.receivedMessage.membersVersion) {
                return new FinalState();
            }
            JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
            if (jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel() != null && jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() != null) {
                JsonGroupDetailsWithVersionAndPhoto publishedDetails = protocolManagerSession.identityDelegate.getGroupPublishedAndLatestOrTrustedDetails(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid())[0];
                if (!(Arrays.equals(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel(), publishedDetails.getPhotoServerLabel()) && (jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() == null && publishedDetails.getPhotoServerKey() == null || jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey() != null && publishedDetails.getPhotoServerKey() != null && new Encoded(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey().equals(new Encoded(publishedDetails.getPhotoServerKey()).decodeSymmetricKey())) && publishedDetails.getPhotoUrl() != null)) {
                    if (receivedFromOtherOwnedDevice) {
                        protocolManagerSession.identityDelegate.createGroupV1ServerUserData(protocolManagerSession.session, this.getOwnedIdentity(), new UID(jsonGroupDetailsWithVersionAndPhoto.getPhotoServerLabel()), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
                    }
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 14, new UID(this.getPrng()));
                    ChannelProtocolMessageToSend messageToSend = new DownloadGroupPhotoChildProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            protocolManagerSession.identityDelegate.updateGroupMembersAndDetails(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation, this.receivedMessage.groupMemberIdentitiesAndSerializedDetails, this.receivedMessage.pendingMemberIdentitiesAndSerializedDetails, this.receivedMessage.membersVersion);
            return new FinalState();
        }
    }

    public static class AddGroupMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final AddGroupMembersMessage receivedMessage;

        public AddGroupMembersStep(InitialProtocolState startState, AddGroupMembersMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            GroupMembersChangedCallback groupMembersChangedCallback = () -> {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            };
            protocolManagerSession.identityDelegate.addPendingMembersToGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity(), this.receivedMessage.newMembersIdentity.toArray(new Identity[0]), groupMembersChangedCallback);
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                throw new Exception();
            }
            HashSet<IdentityWithSerializedDetails> allGroupMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity identity : group.getGroupMembers()) {
                allGroupMembers.add(new IdentityWithSerializedDetails(identity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), identity)));
            }
            for (Identity contactIdentity : this.receivedMessage.newMembersIdentity) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 8, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new GroupInvitationProtocol.InitialMessage(coreProtocolMessage, contactIdentity, this.receivedMessage.groupInformation, allGroupMembers).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class RemoveGroupMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final RemoveGroupMembersMessage receivedMessage;

        public RemoveGroupMembersStep(InitialProtocolState startState, RemoveGroupMembersMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            GroupMembersChangedCallback groupMembersChangedCallback = () -> {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            };
            protocolManagerSession.identityDelegate.removeMembersAndPendingFromGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity(), this.receivedMessage.removedMemberIdentities.toArray(new Identity[0]), groupMembersChangedCallback);
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                throw new Exception();
            }
            for (Identity contactIdentity : this.receivedMessage.removedMemberIdentities) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new KickFromGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (Exception exception) {}
            }
            return new FinalState();
        }
    }

    public static class GetKickedStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final KickFromGroupMessage receivedMessage;

        public GetKickedStep(InitialProtocolState startState, KickFromGroupMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            this.protocol.eraseReceivedMessagesAfterReachingAFinalState = true;
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity())) {
                Logger.w("Error: NewMembersMessage not received from the group owner");
                return null;
            }
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group != null) {
                protocolManagerSession.identityDelegate.leaveGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity());
            }
            return new FinalState();
        }
    }

    public static class ReinvitePendingMemberStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final ReinvitePendingMemberMessage receivedMessage;

        public ReinvitePendingMemberStep(InitialProtocolState startState, ReinvitePendingMemberMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            protocolManagerSession.identityDelegate.setPendingMemberDeclined(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity(), this.receivedMessage.pendingMemberIdentity, false);
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                throw new Exception();
            }
            HashSet<IdentityWithSerializedDetails> allGroupMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity identity : group.getGroupMembers()) {
                allGroupMembers.add(new IdentityWithSerializedDetails(identity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), identity)));
            }
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 8, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new GroupInvitationProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.pendingMemberIdentity, this.receivedMessage.groupInformation, allGroupMembers).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateReinvitePendingMemberMessage(coreProtocolMessage2, this.receivedMessage.groupInformation, this.receivedMessage.pendingMemberIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinalState();
        }
    }

    public static class ProcessPropagateReinvitePendingMemberStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateReinvitePendingMemberMessage receivedMessage;

        public ProcessPropagateReinvitePendingMemberStep(InitialProtocolState startState, PropagateReinvitePendingMemberMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            protocolManagerSession.identityDelegate.setPendingMemberDeclined(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity(), this.receivedMessage.pendingMemberIdentity, false);
            return new FinalState();
        }
    }

    public static class DisbandGroupStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final DisbandGroupMessage receivedMessage;

        public DisbandGroupStep(InitialProtocolState startState, DisbandGroupMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                throw new Exception();
            }
            if (group.getGroupMembers().length > 0) {
                SendChannelInfo[] sendChannelInfos;
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(group.getGroupMembers(), this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend = new KickFromGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception coreProtocolMessage) {
                        // empty catch block
                    }
                }
            }
            if (group.getPendingGroupMembers().length > 0) {
                SendChannelInfo[] sendChannelInfos;
                Identity[] pendingMemberIdentities = new Identity[group.getPendingGroupMembers().length];
                for (int i = 0; i < pendingMemberIdentities.length; ++i) {
                    pendingMemberIdentities[i] = group.getPendingGroupMembers()[i].identity;
                }
                for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(pendingMemberIdentities, this.getOwnedIdentity())) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(sendChannelInfo);
                        ChannelProtocolMessageToSend messageToSend = new KickFromGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateDisbandGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.identityDelegate.deleteGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static class ProcessPropagateDisbandGroupMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateDisbandGroupMessage receivedMessage;

        public ProcessPropagateDisbandGroupMessageStep(InitialProtocolState startState, PropagateDisbandGroupMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            protocolManagerSession.identityDelegate.deleteGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static class LeaveGroupStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final LeaveGroupMessage receivedMessage;

        public LeaveGroupStep(InitialProtocolState startState, LeaveGroupMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: cannot leave a group you own");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            try {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.groupInformation.groupOwnerIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new NotifyGroupLeftMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (Exception e) {
                Logger.w("LeaveGroupStep: Error notifying group owner. Probably no channel with him.");
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateLeaveGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.identityDelegate.leaveGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static class ProcessPropagateLeaveGroupMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateLeaveGroupMessage receivedMessage;

        public ProcessPropagateLeaveGroupMessageStep(InitialProtocolState startState, PropagateLeaveGroupMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: cannot leave a group you own");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            protocolManagerSession.identityDelegate.leaveGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static class ProcessGroupLeftStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final NotifyGroupLeftMessage receivedMessage;

        public ProcessGroupLeftStep(InitialProtocolState startState, NotifyGroupLeftMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: you are not the group owner");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            GroupMembersChangedCallback groupMembersChangedCallback = () -> {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            };
            protocolManagerSession.identityDelegate.removeMembersAndPendingFromGroup(protocolManagerSession.session, this.receivedMessage.groupInformation.getGroupOwnerAndUid(), this.getOwnedIdentity(), new Identity[]{this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity()}, groupMembersChangedCallback);
            return new FinalState();
        }
    }

    public static class QueryGroupMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateGroupMembersQueryMessage receivedMessage;

        public QueryGroupMembersStep(InitialProtocolState startState, InitiateGroupMembersQueryMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: you are the group owner");
                return null;
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.groupInformation.groupOwnerIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new QueryGroupMembersMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinalState();
        }
    }

    public static class SendGroupMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final QueryGroupMembersMessage receivedMessage;

        public SendGroupMembersStep(InitialProtocolState startState, QueryGroupMembersMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: you are not the group owner");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            Identity contactIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group != null && group.isPendingMember(contactIdentity)) {
                return new FinalState();
            }
            if (group == null || !group.isMember(contactIdentity)) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new KickFromGroupMessage(coreProtocolMessage, this.receivedMessage.groupInformation).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinalState();
            }
            HashSet<IdentityWithSerializedDetails> groupMembers = new HashSet<IdentityWithSerializedDetails>();
            HashSet<IdentityWithSerializedDetails> pendingMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity memberIdentity : group.getGroupMembers()) {
                groupMembers.add(new IdentityWithSerializedDetails(memberIdentity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), memberIdentity)));
            }
            groupMembers.add(new IdentityWithSerializedDetails(this.getOwnedIdentity(), protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())));
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new NewMembersMessage(coreProtocolMessage, protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid()), groupMembers, pendingMembers, group.getGroupMembersVersion()).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinalState();
        }
    }

    public static class ReinviteStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final TriggerReinviteMessage receivedMessage;

        public ReinviteStep(InitialProtocolState startState, TriggerReinviteMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.memberIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: trying to reinvite yourself to a group");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: you are not the group owner");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                Logger.w("Error: group not found");
                return null;
            }
            if (!group.isMember(this.receivedMessage.memberIdentity) && !group.isPendingMember(this.receivedMessage.memberIdentity)) {
                Logger.w("Error in ReinviteStep: member is neither member, nor pending");
                return null;
            }
            HashSet<IdentityWithSerializedDetails> allGroupMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity identity : group.getGroupMembers()) {
                allGroupMembers.add(new IdentityWithSerializedDetails(identity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), identity)));
            }
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 8, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new GroupInvitationProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.memberIdentity, this.receivedMessage.groupInformation, allGroupMembers).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinalState();
        }
    }

    public static class UpdateMembersStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final TriggerUpdateMembersMessage receivedMessage;

        public UpdateMembersStep(InitialProtocolState startState, TriggerUpdateMembersMessage receivedMessage, GroupManagementProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.memberIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: trying to reinvite yourself to a group");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: you are not the group owner");
                return null;
            }
            if (!this.receivedMessage.groupInformation.computeProtocolUid().equals(this.protocol.getProtocolInstanceUid())) {
                Logger.w("Error: protocolUid mismatch");
                return null;
            }
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                Logger.w("Error: group not found");
                return null;
            }
            if (!group.isMember(this.receivedMessage.memberIdentity)) {
                Logger.w("Error in UpdateMembersStep: contact is not member");
                return null;
            }
            HashSet<IdentityWithSerializedDetails> groupMembers = new HashSet<IdentityWithSerializedDetails>();
            HashSet<IdentityWithSerializedDetails> pendingMembers = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (Identity memberIdentity : group.getGroupMembers()) {
                groupMembers.add(new IdentityWithSerializedDetails(memberIdentity, protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), memberIdentity)));
            }
            groupMembers.add(new IdentityWithSerializedDetails(this.getOwnedIdentity(), protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())));
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.memberIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new NewMembersMessage(coreProtocolMessage, this.receivedMessage.groupInformation, groupMembers, pendingMembers, group.getGroupMembersVersion()).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinalState();
        }
    }

    private static abstract class GroupInformationOnlyMessage
    extends ConcreteProtocolMessage {
        final GroupInformation groupInformation;

        public GroupInformationOnlyMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
        }

        public GroupInformationOnlyMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupInformation.encode()};
        }
    }
}

