/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.CiphertextAndKey;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;

public class FullRatchetProtocol
extends ConcreteProtocol {
    public static final int ALICE_WAITING_FOR_K1_STATE_ID = 1;
    public static final int BOB_WAITING_FOR_K2_STATE_ID = 2;
    public static final int ALICE_WAITING_FOR_ACK_STATE_ID = 3;
    public static final int FULL_RATCHET_DONE_STATE_ID = 4;
    public static final int CANCELLED_STATE_ID = 5;
    static final int INITIAL_MESSAGE_ID = 0;
    static final int ALICE_EPHEMERAL_KEY_MESSAGE_ID = 1;
    static final int BOB_EPHEMERAL_KEY_AND_K1_MESSAGE_ID = 2;
    static final int ALICE_K2_MESSAGE_ID = 3;
    static final int BOB_ACK_MESSAGE_ID = 4;

    public FullRatchetProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 13;
    }

    public static UID computeProtocolUid(Identity aliceIdentity, Identity bobIdentity, UID aliceDeviceUid, UID bobDeviceUid) {
        Seed prngSeed = new Seed(new Seed(aliceIdentity.getBytes()), new Seed(bobIdentity.getBytes()), new Seed(aliceDeviceUid.getBytes()), new Seed(bobDeviceUid.getBytes()));
        PRNG seededPRNG = Suite.getDefaultPRNG(0, prngSeed);
        return new UID(seededPRNG);
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{4, 5};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return AliceWaitingForK1State.class;
            }
            case 2: {
                return BobWaitingForK2State.class;
            }
            case 3: {
                return AliceWaitingForAckState.class;
            }
            case 4: {
                return FullRatchetDoneState.class;
            }
            case 5: {
                return CancelledState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return AliceEphemeralKeyMessage.class;
            }
            case 2: {
                return BobEphemeralKeyAndK1Message.class;
            }
            case 3: {
                return AliceK2Message.class;
            }
            case 4: {
                return BobAckMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{AliceSendEphemeralKeyStep.class, BobSendEphemeralKeyAndK1Step.class};
            }
            case 1: {
                return new Class[]{AliceRecoverK1AndSendK2Step.class, AliceResendEphemeralKeyStep.class};
            }
            case 2: {
                return new Class[]{BobRecoverK2ToUpdateReceiveSeedAndSendAckStep.class, BobSendEphemeralKeyAndK1Step.class};
            }
            case 3: {
                return new Class[]{AliceUpdateSendSeedStep.class, AliceResendEphemeralKeyStep.class};
            }
        }
        return new Class[0];
    }

    public static class AliceWaitingForK1State
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;
        private final EncryptionPrivateKey ephemeralPrivateKey;
        private final long restartCounter;

        public AliceWaitingForK1State(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactDeviceUid = list[1].decodeUid();
            this.ephemeralPrivateKey = (EncryptionPrivateKey)list[2].decodePrivateKey();
            this.restartCounter = list[3].decodeLong();
        }

        AliceWaitingForK1State(Identity contactIdentity, UID contactDeviceUid, EncryptionPrivateKey ephemeralPrivateKey, long restartCounter) {
            super(1);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.restartCounter = restartCounter;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid), Encoded.of(this.ephemeralPrivateKey), Encoded.of(this.restartCounter)});
        }
    }

    public static class BobWaitingForK2State
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;
        private final EncryptionPrivateKey ephemeralPrivateKey;
        private final AuthEncKey k1;
        private final long restartCounter;

        public BobWaitingForK2State(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactDeviceUid = list[1].decodeUid();
            this.ephemeralPrivateKey = (EncryptionPrivateKey)list[2].decodePrivateKey();
            this.k1 = (AuthEncKey)list[3].decodeSymmetricKey();
            this.restartCounter = list[4].decodeLong();
        }

        BobWaitingForK2State(Identity contactIdentity, UID contactDeviceUid, EncryptionPrivateKey ephemeralPrivateKey, AuthEncKey k1, long restartCounter) {
            super(2);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.k1 = k1;
            this.restartCounter = restartCounter;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid), Encoded.of(this.ephemeralPrivateKey), Encoded.of(this.k1), Encoded.of(this.restartCounter)});
        }
    }

    public static class AliceWaitingForAckState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;
        private final Seed seed;
        private final long restartCounter;

        public AliceWaitingForAckState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactDeviceUid = list[1].decodeUid();
            this.seed = list[2].decodeSeed();
            this.restartCounter = list[3].decodeLong();
        }

        AliceWaitingForAckState(Identity contactIdentity, UID contactDeviceUid, Seed seed, long restartCounter) {
            super(3);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
            this.seed = seed;
            this.restartCounter = restartCounter;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid), Encoded.of(this.seed), Encoded.of(this.restartCounter)});
        }
    }

    public static class FullRatchetDoneState
    extends ConcreteProtocolState {
        public FullRatchetDoneState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        FullRatchetDoneState() {
            super(4);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class CancelledState
    extends ConcreteProtocolState {
        public CancelledState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        CancelledState() {
            super(5);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, UID contactDeviceUid) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactDeviceUid = receivedMessage.getInputs()[1].decodeUid();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid)};
        }
    }

    public static class AliceEphemeralKeyMessage
    extends ConcreteProtocolMessage {
        private final EncryptionPublicKey contactEphemeralPublicKey;
        private final long restartCounter;

        public AliceEphemeralKeyMessage(CoreProtocolMessage coreProtocolMessage, EncryptionPublicKey contactEphemeralPublicKey, long restartCounter) {
            super(coreProtocolMessage);
            this.contactEphemeralPublicKey = contactEphemeralPublicKey;
            this.restartCounter = restartCounter;
        }

        public AliceEphemeralKeyMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactEphemeralPublicKey = (EncryptionPublicKey)receivedMessage.getInputs()[0].decodePublicKey();
            this.restartCounter = receivedMessage.getInputs()[1].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactEphemeralPublicKey), Encoded.of(this.restartCounter)};
        }
    }

    public static class BobEphemeralKeyAndK1Message
    extends ConcreteProtocolMessage {
        private final EncryptionPublicKey contactEphemeralPublicKey;
        private final EncryptedBytes c1;
        private final long restartCounter;

        public BobEphemeralKeyAndK1Message(CoreProtocolMessage coreProtocolMessage, EncryptionPublicKey contactEphemeralPublicKey, EncryptedBytes c1, long restartCounter) {
            super(coreProtocolMessage);
            this.contactEphemeralPublicKey = contactEphemeralPublicKey;
            this.c1 = c1;
            this.restartCounter = restartCounter;
        }

        public BobEphemeralKeyAndK1Message(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.contactEphemeralPublicKey = (EncryptionPublicKey)receivedMessage.getInputs()[0].decodePublicKey();
            this.c1 = receivedMessage.getInputs()[1].decodeEncryptedData();
            this.restartCounter = receivedMessage.getInputs()[2].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactEphemeralPublicKey), Encoded.of(this.c1), Encoded.of(this.restartCounter)};
        }
    }

    public static class AliceK2Message
    extends ConcreteProtocolMessage {
        private final EncryptedBytes c2;
        private final long restartCounter;

        public AliceK2Message(CoreProtocolMessage coreProtocolMessage, EncryptedBytes c2, long restartCounter) {
            super(coreProtocolMessage);
            this.c2 = c2;
            this.restartCounter = restartCounter;
        }

        public AliceK2Message(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.c2 = receivedMessage.getInputs()[0].decodeEncryptedData();
            this.restartCounter = receivedMessage.getInputs()[1].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.c2), Encoded.of(this.restartCounter)};
        }
    }

    public static class BobAckMessage
    extends ConcreteProtocolMessage {
        private final long restartCounter;

        public BobAckMessage(CoreProtocolMessage coreProtocolMessage, long restartCounter) {
            super(coreProtocolMessage);
            this.restartCounter = restartCounter;
        }

        public BobAckMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.restartCounter = receivedMessage.getInputs()[0].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.restartCounter)};
        }
    }

    public static class AliceSendEphemeralKeyStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public AliceSendEphemeralKeyStep(InitialProtocolState startState, InitialMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            byte[] bytes = this.getPrng().bytes(5);
            long restartCounter = 0L;
            for (int i = 0; i < 5; ++i) {
                restartCounter <<= 8;
                restartCounter += (long)(bytes[i] & 0xFF);
            }
            restartCounter <<= 23;
            KeyPair keyPair = Suite.generateEncryptionKeyPair(this.getOwnedIdentity().getEncryptionPublicKey().getAlgorithmImplementation(), this.getPrng());
            if (keyPair == null) {
                throw new Exception();
            }
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), new UID[]{this.receivedMessage.contactDeviceUid}, true), this.getProtocolId(), this.getProtocolInstanceUid(), false);
            ChannelProtocolMessageToSend messageToSend = new AliceEphemeralKeyMessage(coreProtocolMessage, (EncryptionPublicKey)keyPair.getPublicKey(), restartCounter).generateChannelProtocolMessageToSend();
            try {
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (NoAcceptableChannelException e) {
                return new CancelledState();
            }
            return new AliceWaitingForK1State(this.receivedMessage.contactIdentity, this.receivedMessage.contactDeviceUid, (EncryptionPrivateKey)keyPair.getPrivateKey(), restartCounter);
        }
    }

    public static class BobSendEphemeralKeyAndK1Step
    extends ProtocolStep {
        private final BobWaitingForK2State previousState;
        private final AliceEphemeralKeyMessage receivedMessage;

        public BobSendEphemeralKeyAndK1Step(InitialProtocolState startState, AliceEphemeralKeyMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelInfo(), receivedMessage, protocol);
            this.previousState = null;
            this.receivedMessage = receivedMessage;
        }

        public BobSendEphemeralKeyAndK1Step(BobWaitingForK2State startState, AliceEphemeralKeyMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.contactDeviceUid, startState.contactIdentity), receivedMessage, protocol);
            this.previousState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.previousState != null && this.receivedMessage.restartCounter >> 23 == this.previousState.restartCounter >> 23 && this.receivedMessage.restartCounter <= this.previousState.restartCounter) {
                return this.previousState;
            }
            UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (!this.getProtocolInstanceUid().equals(FullRatchetProtocol.computeProtocolUid(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), currentDeviceUid))) {
                return new CancelledState();
            }
            KeyPair keyPair = Suite.generateEncryptionKeyPair(this.getOwnedIdentity().getEncryptionPublicKey().getAlgorithmImplementation(), this.getPrng());
            if (keyPair == null) {
                throw new Exception();
            }
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.receivedMessage.contactEphemeralPublicKey);
            CiphertextAndKey ciphertextAndKey = publicKeyEncryption.kemEncrypt(this.receivedMessage.contactEphemeralPublicKey, this.getPrng());
            AuthEncKey k1 = ciphertextAndKey.getKey();
            EncryptedBytes c1 = ciphertextAndKey.getCiphertext();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid()}, true));
            ChannelProtocolMessageToSend messageToSend = new BobEphemeralKeyAndK1Message(coreProtocolMessage, (EncryptionPublicKey)keyPair.getPublicKey(), c1, this.receivedMessage.restartCounter).generateChannelProtocolMessageToSend();
            try {
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (NoAcceptableChannelException e) {
                return new CancelledState();
            }
            return new BobWaitingForK2State(this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), this.receivedMessage.getReceptionChannelInfo().getRemoteDeviceUid(), (EncryptionPrivateKey)keyPair.getPrivateKey(), k1, this.receivedMessage.restartCounter);
        }
    }

    public static class AliceRecoverK1AndSendK2Step
    extends ProtocolStep {
        private final AliceWaitingForK1State startState;
        private final BobEphemeralKeyAndK1Message receivedMessage;

        public AliceRecoverK1AndSendK2Step(AliceWaitingForK1State startState, BobEphemeralKeyAndK1Message receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.contactDeviceUid, startState.contactIdentity), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.restartCounter != this.startState.restartCounter) {
                return this.startState;
            }
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.startState.ephemeralPrivateKey);
            AuthEncKey k1 = publicKeyEncryption.kemDecrypt(this.startState.ephemeralPrivateKey, this.receivedMessage.c1);
            if (k1 == null) {
                Logger.e("Could not recover k1.");
                return new CancelledState();
            }
            publicKeyEncryption = Suite.getPublicKeyEncryption(this.receivedMessage.contactEphemeralPublicKey);
            CiphertextAndKey ciphertextAndKey = publicKeyEncryption.kemEncrypt(this.receivedMessage.contactEphemeralPublicKey, this.getPrng());
            AuthEncKey k2 = ciphertextAndKey.getKey();
            EncryptedBytes c2 = ciphertextAndKey.getCiphertext();
            Seed seed = Seed.of(k1, k2);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), new UID[]{this.startState.contactDeviceUid}, true), this.getProtocolId(), this.getProtocolInstanceUid(), false);
            ChannelProtocolMessageToSend messageToSend = new AliceK2Message(coreProtocolMessage, c2, this.startState.restartCounter).generateChannelProtocolMessageToSend();
            try {
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (NoAcceptableChannelException e) {
                return new CancelledState();
            }
            return new AliceWaitingForAckState(this.startState.contactIdentity, this.startState.contactDeviceUid, seed, this.startState.restartCounter);
        }
    }

    public static class AliceResendEphemeralKeyStep
    extends ProtocolStep {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;
        private final long previousRestartCounter;
        private final InitialMessage receivedMessage;

        public AliceResendEphemeralKeyStep(AliceWaitingForK1State startState, InitialMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.contactIdentity = startState.contactIdentity;
            this.contactDeviceUid = startState.contactDeviceUid;
            this.previousRestartCounter = startState.restartCounter;
            this.receivedMessage = receivedMessage;
        }

        public AliceResendEphemeralKeyStep(AliceWaitingForAckState startState, InitialMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.contactIdentity = startState.contactIdentity;
            this.contactDeviceUid = startState.contactDeviceUid;
            this.previousRestartCounter = startState.restartCounter;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.contactDeviceUid.equals(this.contactDeviceUid) || !this.receivedMessage.contactIdentity.equals(this.contactIdentity)) {
                throw new Exception();
            }
            long restartCounter = this.previousRestartCounter + 1L;
            KeyPair keyPair = Suite.generateEncryptionKeyPair(this.getOwnedIdentity().getEncryptionPublicKey().getAlgorithmImplementation(), this.getPrng());
            if (keyPair == null) {
                throw new Exception();
            }
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), new UID[]{this.receivedMessage.contactDeviceUid}, true), this.getProtocolId(), this.getProtocolInstanceUid(), false);
            ChannelProtocolMessageToSend messageToSend = new AliceEphemeralKeyMessage(coreProtocolMessage, (EncryptionPublicKey)keyPair.getPublicKey(), restartCounter).generateChannelProtocolMessageToSend();
            try {
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            catch (NoAcceptableChannelException e) {
                return new CancelledState();
            }
            return new AliceWaitingForK1State(this.receivedMessage.contactIdentity, this.receivedMessage.contactDeviceUid, (EncryptionPrivateKey)keyPair.getPrivateKey(), restartCounter);
        }
    }

    public static class BobRecoverK2ToUpdateReceiveSeedAndSendAckStep
    extends ProtocolStep {
        private final BobWaitingForK2State startState;
        private final AliceK2Message receivedMessage;

        public BobRecoverK2ToUpdateReceiveSeedAndSendAckStep(BobWaitingForK2State startState, AliceK2Message receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.contactDeviceUid, startState.contactIdentity), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.restartCounter != this.startState.restartCounter) {
                return this.startState;
            }
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.startState.ephemeralPrivateKey);
            AuthEncKey k2 = publicKeyEncryption.kemDecrypt(this.startState.ephemeralPrivateKey, this.receivedMessage.c2);
            if (k2 == null) {
                Logger.e("Could not recover k2.");
                return new CancelledState();
            }
            Seed seed = Seed.of(this.startState.k1, k2);
            protocolManagerSession.channelDelegate.updateObliviousChannelReceiveSeed(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactDeviceUid, this.startState.contactIdentity, seed, 0);
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), new UID[]{this.startState.contactDeviceUid}, true));
            ChannelProtocolMessageToSend messageToSend = new BobAckMessage(coreProtocolMessage, this.startState.restartCounter).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FullRatchetDoneState();
        }
    }

    public static class AliceUpdateSendSeedStep
    extends ProtocolStep {
        private final AliceWaitingForAckState startState;
        private final BobAckMessage receivedMessage;

        public AliceUpdateSendSeedStep(AliceWaitingForAckState startState, BobAckMessage receivedMessage, FullRatchetProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.contactDeviceUid, startState.contactIdentity), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.restartCounter != this.startState.restartCounter) {
                return this.startState;
            }
            protocolManagerSession.channelDelegate.updateObliviousChannelSendSeed(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactDeviceUid, this.startState.contactIdentity, this.startState.seed, 0);
            return new FullRatchetDoneState();
        }
    }
}

