/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import java.io.ByteArrayOutputStream;

public class DownloadGroupV2PhotoProtocol
extends ConcreteProtocol {
    public static final int DOWNLOADING_PHOTO_STATE_ID = 1;
    public static final int PHOTO_DOWNLOADED_STATE_ID = 2;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int SERVER_GET_PHOTO_MESSAGE_ID = 1;

    public DownloadGroupV2PhotoProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 19;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return DownloadingPhotoState.class;
            }
            case 2: {
                return PhotoDownloadedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ServerGetPhotoMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{QueryServerStep.class};
            }
            case 1: {
                return new Class[]{ProcessPhotoStep.class};
            }
        }
        return new Class[0];
    }

    public static class DownloadingPhotoState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final GroupV2.ServerPhotoInfo serverPhotoInfo;

        public DownloadingPhotoState(GroupV2.Identifier groupIdentifier, GroupV2.ServerPhotoInfo serverPhotoInfo) {
            super(1);
            this.groupIdentifier = groupIdentifier;
            this.serverPhotoInfo = serverPhotoInfo;
        }

        public DownloadingPhotoState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.serverPhotoInfo = GroupV2.ServerPhotoInfo.of(list[1]);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), this.serverPhotoInfo.encode()});
        }
    }

    public static class PhotoDownloadedState
    extends ConcreteProtocolState {
        public PhotoDownloadedState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final GroupV2.ServerPhotoInfo serverPhotoInfo;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, GroupV2.ServerPhotoInfo serverPhotoInfo) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.serverPhotoInfo = serverPhotoInfo;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.serverPhotoInfo = GroupV2.ServerPhotoInfo.of(list[1]);
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), this.serverPhotoInfo.encode()};
        }
    }

    public static class ServerGetPhotoMessage
    extends ConcreteProtocolMessage {
        private final EncryptedBytes encryptedPhoto;
        private final String photoPathToDelete;

        private ServerGetPhotoMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.encryptedPhoto = null;
            this.photoPathToDelete = null;
        }

        public ServerGetPhotoMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.photoPathToDelete = receivedMessage.getEncodedResponse().decodeString();
            if ("".equals(this.photoPathToDelete)) {
                this.encryptedPhoto = null;
            } else {
                try (SecureFileInputStream fis = new SecureFileInputStream(new SecureFile(receivedMessage.getProtocolManagerSession().engineBaseDirectory, this.photoPathToDelete));
                     ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int c;
                    byte[] buffer = new byte[32768];
                    while ((c = fis.read(buffer)) > 0) {
                        baos.write(buffer, 0, c);
                    }
                    this.encryptedPhoto = new EncryptedBytes(baos.toByteArray());
                }
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class QueryServerStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public QueryServerStep(InitialProtocolState startState, InitialMessage receivedMessage, DownloadGroupV2PhotoProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public DownloadingPhotoState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupIdentifier.category == 1) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.GetKeycloakDataQuery(this.receivedMessage.groupIdentifier.serverUrl, this.receivedMessage.serverPhotoInfo.serverPhotoLabel)));
                ChannelServerQueryMessageToSend messageToSend = new ServerGetPhotoMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new DownloadingPhotoState(this.receivedMessage.groupIdentifier, this.receivedMessage.serverPhotoInfo);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.GetUserDataQuery(this.receivedMessage.serverPhotoInfo.serverPhotoIdentity, this.receivedMessage.serverPhotoInfo.serverPhotoLabel)));
            ChannelServerQueryMessageToSend messageToSend = new ServerGetPhotoMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new DownloadingPhotoState(this.receivedMessage.groupIdentifier, this.receivedMessage.serverPhotoInfo);
        }
    }

    public static class ProcessPhotoStep
    extends ProtocolStep {
        private final DownloadingPhotoState startState;
        private final ServerGetPhotoMessage receivedMessage;

        public ProcessPhotoStep(DownloadingPhotoState startState, ServerGetPhotoMessage receivedMessage, DownloadGroupV2PhotoProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.encryptedPhoto == null) {
                return new PhotoDownloadedState();
            }
            byte[] decryptedPhoto = Suite.getAuthEnc(this.startState.serverPhotoInfo.serverPhotoKey).decrypt(this.startState.serverPhotoInfo.serverPhotoKey, this.receivedMessage.encryptedPhoto);
            protocolManagerSession.identityDelegate.setGroupV2DownloadedPhoto(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, this.startState.serverPhotoInfo, decryptedPhoto);
            try {
                new SecureFile(protocolManagerSession.engineBaseDirectory, this.receivedMessage.photoPathToDelete).delete();
            }
            catch (Exception e) {
                Logger.x(e);
            }
            return new PhotoDownloadedState();
        }
    }
}

