/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import java.util.HashMap;

public class DeviceDiscoveryChildProtocol
extends ConcreteProtocol {
    public static final int DEVICE_UIDS_RECEIVED_STATE_ID = 2;
    public static final int SERVER_REQUEST_SENT_STATE_ID = 4;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int SERVER_QUERY_MESSAGE_ID = 3;

    public DeviceDiscoveryChildProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.mayBeRunAsLinkedChildProtocol = true;
    }

    @Override
    public int getProtocolId() {
        return 3;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 2: {
                return DeviceUidsReceivedState.class;
            }
            case 4: {
                return ServerRequestSentState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 3: {
                return ServerQueryMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendRequestStep.class};
            }
            case 4: {
                return new Class[]{ProcessDeviceUidsStep.class};
            }
        }
        return new Class[0];
    }

    public static class DeviceUidsReceivedState
    extends ConcreteProtocolState {
        private final Identity remoteIdentity;
        private final boolean recentlyOnline;
        private final long serverTimestamp;
        private final HashMap<DictionaryKey, Encoded>[] deviceUidsAndPreKeys;

        public DeviceUidsReceivedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length == 2) {
                this.remoteIdentity = list[0].decodeIdentity();
                this.recentlyOnline = true;
                this.serverTimestamp = 0L;
                UID[] deviceUids = list[1].decodeUidArray();
                this.deviceUidsAndPreKeys = new HashMap[deviceUids.length];
                for (int i = 0; i < deviceUids.length; ++i) {
                    this.deviceUidsAndPreKeys[i] = new HashMap();
                    this.deviceUidsAndPreKeys[i].put(new DictionaryKey("uid"), Encoded.of(deviceUids[i]));
                }
            } else if (list.length == 4) {
                this.remoteIdentity = list[0].decodeIdentity();
                this.recentlyOnline = list[1].decodeBoolean();
                this.serverTimestamp = list[2].decodeLong();
                this.deviceUidsAndPreKeys = list[3].decodeDictionaryArray();
            } else {
                throw new Exception();
            }
        }

        public DeviceUidsReceivedState(Identity remoteIdentity, boolean recentlyOnline, long serverTimestamp, HashMap<DictionaryKey, Encoded>[] deviceUidsAndPreKeys) {
            super(2);
            this.remoteIdentity = remoteIdentity;
            this.recentlyOnline = recentlyOnline;
            this.serverTimestamp = serverTimestamp;
            this.deviceUidsAndPreKeys = deviceUidsAndPreKeys;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteIdentity), Encoded.of(this.recentlyOnline), Encoded.of(this.serverTimestamp), Encoded.of(this.deviceUidsAndPreKeys)});
        }

        public boolean isRecentlyOnline() {
            return this.recentlyOnline;
        }

        public long getServerTimestamp() {
            return this.serverTimestamp;
        }

        public HashMap<DictionaryKey, Encoded>[] getDeviceUidsAndPreKeys() {
            return this.deviceUidsAndPreKeys;
        }

        public Identity getRemoteIdentity() {
            return this.remoteIdentity;
        }
    }

    public static class ServerRequestSentState
    extends ConcreteProtocolState {
        private final Identity remoteIdentity;

        public ServerRequestSentState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.remoteIdentity = list[0].decodeIdentity();
        }

        public ServerRequestSentState(Identity remoteIdentity) {
            super(4);
            this.remoteIdentity = remoteIdentity;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteIdentity)});
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity remoteIdentity;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity remoteIdentity) {
            super(coreProtocolMessage);
            this.remoteIdentity = remoteIdentity;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.remoteIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteIdentity)};
        }
    }

    public static class ServerQueryMessage
    extends ConcreteProtocolMessage {
        private final boolean recentlyOnline;
        private final long serverTimestamp;
        private final HashMap<DictionaryKey, Encoded>[] deviceUidsAndPreKeys;

        public ServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.recentlyOnline = false;
            this.serverTimestamp = 0L;
            this.deviceUidsAndPreKeys = null;
        }

        public ServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            HashMap<DictionaryKey, Encoded> dict = receivedMessage.getEncodedResponse().decodeDictionary();
            if (dict.isEmpty()) {
                this.recentlyOnline = false;
                this.serverTimestamp = 0L;
                this.deviceUidsAndPreKeys = new HashMap[0];
            } else {
                Encoded encodedRecentlyOnline = dict.get(new DictionaryKey("ro"));
                this.recentlyOnline = encodedRecentlyOnline == null || encodedRecentlyOnline.decodeBoolean();
                Encoded encodedServerTimestamp = dict.get(new DictionaryKey("st"));
                this.serverTimestamp = encodedServerTimestamp == null ? 0L : encodedServerTimestamp.decodeLong();
                Encoded encodedDeviceUidsAndPreKeys = dict.get(new DictionaryKey("dev"));
                this.deviceUidsAndPreKeys = encodedDeviceUidsAndPreKeys == null ? new HashMap[0] : encodedDeviceUidsAndPreKeys.decodeDictionaryArray();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class SendRequestStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public SendRequestStep(InitialProtocolState startState, InitialMessage receivedMessage, DeviceDiscoveryChildProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ServerRequestSentState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.DeviceDiscoveryQuery(this.receivedMessage.remoteIdentity)));
            ChannelServerQueryMessageToSend messageToSend = new ServerQueryMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new ServerRequestSentState(this.receivedMessage.remoteIdentity);
        }
    }

    public static class ProcessDeviceUidsStep
    extends ProtocolStep {
        private final ServerRequestSentState startState;
        private final ServerQueryMessage receivedMessage;

        public ProcessDeviceUidsStep(ServerRequestSentState startState, ServerQueryMessage receivedMessage, DeviceDiscoveryChildProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            return new DeviceUidsReceivedState(this.startState.remoteIdentity, this.receivedMessage.recentlyOnline, this.receivedMessage.serverTimestamp, this.receivedMessage.deviceUidsAndPreKeys);
        }
    }
}

